<?php
/*------------------------------------------------------------------------
# Component 4rss
# ------------------------------------------------------------------------
# Copyright (C) 2009 T4 Media Group LLC. All rights reserved
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Author: Naresh Saini, E-FusionSoft Technologies Private Limited.
# Author Email: 4rss@4rss.com
# Websites:  http://www.4rss.com
# Creation Date: 7/21/2009
# Version: 1.0
-------------------------------------------------------------------------*/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class RssControllerFeedpost extends JController
{

	function __construct( $default = array())
	{
		parent::__construct( $default );
		
		## Register Extra tasks
		
		$this->registerTask( 'addfeedpost' , 'editfeedpost' );
		$this->registerTask( 'feedpostunpublish' , 'feedpostpublish' );
		$this->registerTask( 'applyfeedpost' , 'savefeedpost' );
		
		
		
	}
	

	function display() {
		$view = JRequest::getVar( 'view','feedposts','request','word');
		JRequest::setVar( 'layout', 'default');
		JRequest::setVar( 'view', $view);
		parent::display();		
	}

	

	/**
	 * Logic to mass ordering feedposts
	 *
	 * @access public
	 * @return void
	 * @since 1.0
	 */
	function saveOrderFeedPosts()
	{
		$cid 	= JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$order 	= JRequest::getVar( 'order', array(0), 'post', 'array' );
		JArrayHelper::toInteger($order, array(0));

		$model = $this->getModel('feedposts');
		$model->saveorder($cid, $order);

		$msg = 'New ordering saved';
		$this->setRedirect( 'index.php?option=com_4rss&controller=feedpost&view=feedposts', $msg );
	}


   
	

	/**	
	 * Save the ordering of the one record.
	 *	 	
	 * @access public
	 *
	 **/	 
	function orderUp()
	{
		
		global $mainframe;
	
		// Determine whether to order it up or down
		$direction	= ( JRequest::getWord( 'task' , '' ) == 'orderup' ) ? -1 : 1;
		
		// Get the ID in the correct location
 		$id			= JRequest::getVar( 'cid', array(), 'post', 'array' );

		if( isset( $id[0] ) )
		{
			$id		= (int) $id[0];

			// Load the JTable Object.
			$table	=& JTable::getInstance( 'feedposts' , 'feedpostTable' );			
			$table->load( $id );
			$table->move( $direction );

			$cache	=& JFactory::getCache( 'com_4rss');
			$cache->clean();
			
			$mainframe->redirect( 'index.php?option=com_4rss&controller=feedpost' );
		}
		
	}


	 /**	
	 * Save the ordering of the one record.
	 *	 	
	 * @access public
	 *
	 **/
	 
	function orderDown()
	{
		
		global $mainframe;
	
		// Determine whether to order it up or down
		$direction	= ( JRequest::getWord( 'task' , '' ) == 'orderup' ) ? -1 : 1;
		
		// Get the ID in the correct location
 		$id			= JRequest::getVar( 'cid', array(), 'post', 'array' );

		if( isset( $id[0] ) )
		{
			$id		= (int) $id[0];

			// Load the JTable Object.
			$table	=& JTable::getInstance( 'feedpost' , 'feedpostTable' );	

			$table->load( $id );
			$table->move( $direction );

			$cache	=& JFactory::getCache( 'com_4rss');
			$cache->clean();
			
			$mainframe->redirect( 'index.php?option=com_4rss&controller=feedpost' );
		}
		
	}


	function removeFeedPost() {
	
		
		global $mainframe, $option;
	
		$cid = JRequest::getVar('cid', 0);
		$model = $this->getModel('feedposts');

		if(!($msg = $model->remove($cid))) {
			echo "<script> alert('".$model->getError(true)."'); window.history.go(-1); </script>\n";
		}

		## Nothing went wrong, redirect now to the overview.
		$mainframe->redirect('index.php?option='.$option.'&controller=feedpost&view=feedposts', $msg);	
		
	}




	/**	
	 * This function will publish or unpublish feedposts
	 *	 	
	 * @access public
	 *
	 **/	

	function feedPostPublish()
	{
		
		global $mainframe;

		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		
		## Getting the task (publish/upnpublish)
		if ($this->getTask() == 'feedpostpublish') {
			$publish = 1;
		} else {
			$publish = 0;
		}		
	
		if (count( $cid ) < 1) {
			$link = 'index.php?option=com_4rss&controller=feedpost&view=feedposts';
			$this->setRedirect($link, 'Select a feedpost to publish');
		}

		$model = $this->getModel('feedposts');

		if(!$model->publish($cid, $publish)) {
			$link = 'index.php?option=com_4rss&controller=feedpost&view=feedposts';
			$this->setRedirect($link, 'The Model Doesn\'t Exists');
		}

		$link = 'index.php?option=com_4rss&controller=feedpost&view=feedposts';
		$this->setRedirect($link, "Status of the selected feedpost(s) changed!");
	}

		

	/**	
	 * This function will save   feedposts
	 *	 	
	 * @access public
	 *
	 **/

	
	function saveFeedpost() {
		global $mainframe;
		$post	            = JRequest::get('post');
		
		$model	=& $this->getModel('feedpost');

		if ($model->store($post)) {
			$msg = JText::_( 'Feedpost Saved' );
		} else {
			$msg = JText::_( 'Error Saving...' );
		}
	
		$link = 'index.php?option=com_4rss&controller=feedpost&view=feedposts';
		$this->setRedirect($link, $msg);

	}

	

	


	/**	
	 * This function will edit feedposts
	 *	 	
	 * @access public
	 *
	 **/

	

		function editFeedpost() {
		
		JRequest::setVar( 'layout', 'form');
		JRequest::setVar( 'view', 'feedpost');		
		JRequest::setVar( 'hidemainmenu', 1 );

		
		$model= $this->getModel('feedpost');
		$task= JRequest::getVar('task');
		if ($task == 'addfeedpost'){
		JRequest::setVar( 'cid', 0 );
		}
		
		parent::display();
		}

		
		
		/**	
	 * This function will get data  feedposts  and save all to database 
	 *	 	
	 * @access public
	 *
	 **/

	
	function postAll(){
		set_time_limit(0);
		global $mainframe;
		global $countFeedItem;
		$feedid = JRequest::getVar('feedid', 0);
		
		if($feedid=='end'){
		sleep(5);
		echo '';
		}
		else{
			if (!$feedid) {
			$msg = JText::_('Error:  Select a feedpost to Post All');
			echo $msg;
			}
		
			$model = $this->getModel('Showfeeditem');
			
			
			if($model->feedDataInfo($feedid)) {

				echo '<br><img src="images/save_f2.png" width="20" height="20" border="0"  />';
				echo  $countFeedItem .' Item Saved ';
				echo "<br> Saved  Feed ID: ". $feedid;
			}
			else{
				echo " Error Processing Feed ID: ". $feedid;
			}
	
		}

	}


	/**	
	 * This function used for popup the window  
	 *	 	
	 * @access public
	 *
	 **/



function windowpopup() {
		
		?>
				<script type="text/javascript">
		<?php $links= JRequest::getVar('links');
				if ($links == 'feeds'){ ?>
					window.open('http://www.4rss.com/feeds.html');

		<?php
			} elseif ($links == 'download'){ ?>
					window.open('http://www.4rss.com/download.html');
		<?php
			}elseif ($links == 'forum'){ ?>
					window.open('http://www.4rss.com/forum.html');
		<?php
			}?>
				</script>
		<?php

			
		JRequest::setVar( 'view', 'feedposts');	
		parent::display();	
	}





	}

?>