<?php
/**
 * @version Id: ms_merchant.php version 1.0 2007-09-01 
 * @package CMS Shop Builder for joomla
 * @copyright Copyright (C) 2005 - 2008 Wasan Ongart. All rights reserved.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


class Ms_merchantViewMs_merchant
{
	function setMs_merchantsToolbar()
	{
		JToolBarHelper::title( JText::_( 'Merchant' ), 'generic.png' );
		JToolBarHelper::deleteList();
		JToolBarHelper::editListX();
		JToolBarHelper::addNewX();
				JToolBarHelper::customX( 'close', 'cancel.png', 'cancel_f2.png', 'Close',false );

	}

	function ms_merchants( &$rows, &$pageNav, &$lists )
	{
		Ms_merchantViewMs_merchant::setMs_merchantsToolbar();
		JHTML::_('behavior.tooltip');
		?>
		
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'remove') {
			    if (confirm('You are about to remove all producs from this merchant! Are you Sure?'))
					 submitform( pressbutton );
			}else {
				submitform( pressbutton );
			}
		}
		
		</script>
		<form action="index.php?option=com_cmsshopbuilder&c=ms_merchant" method="post" name="adminForm">
		<table>
		<tr>
			<td align="left" width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			
		</tr>
		</table>

			<table class="adminlist">
			<thead>
				<tr>
					<td colspan="4">
						<?php echo $pageNav->getListFooter(); ?>
					</td>
				</tr>   
				<tr>
					<th width="10">
						<?php echo JText::_( 'Num' ); ?>
					</th>
					<th width="10">
						<input type="checkbox" name="toggle" value=""  onclick="checkAll(<?php echo count( $rows ); ?>);" />
					</th>
					<th width="70%" nowrap="nowrap" class="title">
						<?php echo JHTML::_('grid.sort',  'Merchant Name', 'm.mc_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					
					<th width="30%" nowrap="nowrap" >
						<?php echo JText::_( 'Merchant Logo' ); ?>
					</th>
					
				</tr>
			</thead>
			
			<tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $rows ); $i < $n; $i++) {
				$row = &$rows[$i];

				$row->id	= $row->mc_id;
				$link		= JRoute::_( 'index.php?option=com_cmsshopbuilder&c=ms_merchant&task=edit&cid[]='. $row->mc_id );
				$checked		= JHTML::_('grid.checkedout',   $row, $i );

		
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="center">
						<?php echo $pageNav->getRowOffset($i); ?>
					</td>
					<td align="center">
						<?php echo $checked; ?>
					</td>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Merchant' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>'; ?>">
						<?php echo $row->mc_name; ?></a>
					
					</td>
					
					<td>
					    <img src="<?php echo '../components/com_cmsshopbuilder/images/merchants/'.$row->mc_logo;?>"   border="0" title="<?php echo $row->mc_name;?>" alt="<?php echo  $row->mc_name;?>" />
					</td>
					
				
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
			</table>

		<input type="hidden" name="c" value="ms_merchant" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="" />
		</form>
		<?php
	}

	function setMs_merchantToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');

		JToolBarHelper::title( $task == 'add' ? JText::_( 'Merchant' ) . ': <small><small>[ '. JText::_( 'New' ) .' ]</small></small>' : JText::_( 'Merchant' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>', 'generic.png' );
		JToolBarHelper::save( 'save' );
		JToolBarHelper::apply('apply');
		JToolBarHelper::cancel( 'cancel' );
	}

	function ms_merchant( &$row, &$lists )
	{
		Ms_merchantViewMs_merchant::setMs_merchantToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		jimport('joomla.filter.output');
		$upload_dir=  '../components/com_cmsshopbuilder/images/merchants/';
		
		$upload_max_filesize=ini_get("upload_max_filesize");
		if (eregi("([0-9]+)K",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024;
		if (eregi("([0-9]+)M",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024*1024;
		if (eregi("([0-9]+)G",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024*1024*1024;
	
		?>
		<script language="javascript" type="text/javascript">
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			// do field validation
			if (form.mc_name.value == "") {
				alert( "<?php echo JText::_( 'You must provide a Merchant name.', true ); ?>" );
			} else {
				submitform( pressbutton );
			}
		}
		
		</script>
		<form action="index.php" method="post" name="adminForm" enctype="multipart/form-data" >

		<div class="col50">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Details' ); ?></legend>

				<table class="admintable">
				<tbody>
					<tr>
						<td width="40%" class="key">
							<label for="name">
								<?php echo JText::_( 'Merchant Name' ); ?>:
							</label>
						</td>
						<td width="60%">
							<input class="inputbox" type="text" name="mc_name" id="mc_name" size="50" value="<?php echo $row->mc_name;?>" />
						</td>
					</tr>
					
					<tr>
							<td class="key" valign="top" align="right">
								<?php echo JText::_( 'Merchant Image' ); ?>:
							</td>
							<td>
								<?php echo $lists['image']; ?>
							</td>
					</tr>
					<tr>
							<td>&nbsp;</td>
							<td>
								<script language="javascript" type="text/javascript">
								if (document.forms.adminForm.mc_logo.options.value!=''){
									jsimg ='../components/com_cmsshopbuilder/images/merchants/' + getSelectedValue( 'adminForm', 'mc_logo' );
								} else {
									jsimg='../images/M_images/blank.png';
								}
								document.write('<img src=' + jsimg + ' name="imagelib"  border="2" alt="<?php echo JText::_( 'Preview', true ); ?>" />');
								</script>
							</td>
						</tr>
				</tbody>
				</table>
			</fieldset>
		</div>
		<div class="col50">
		<fieldset class="adminform">
 				<legend><?php echo JText::_( 'Upload Merchant Image File' ); ?></legend>
				<table class="admintable">
				
						<tr>
							<td >
								<input type='file' name="logofile" accept="*/*" size="40"  >
								<input type="submit" name="uploadbutton" onclick="javascript:submitbutton('upload_image')" value=" Upload Image ">
							</td>
						</tr>
				</table>	
			</fieldset>	
		</div>	
	    <div class="clr"></div>
		<input type="hidden" name="c" value="ms_merchant" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="mc_id" value="<?php echo $row->mc_id; ?>" />
		<input type="hidden" name="task" value="" />

		</form>
		<?php
	}
}