<?php
/**
 * @version Id: ms_product.php version 1.0 2007-09-01 
 * @package CMS Shop Builder for joomla
 * @copyright Copyright (C) 2005 - 2008 Wasan Ongart. All rights reserved.
 */



// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


class Ms_productsViewProduct
{
	function setMs_productsToolbar()
	{
		JToolBarHelper::title( JText::_( 'Import Manager' ), 'generic.png' );
		JToolBarHelper::customX( 'addall', 'apply.png', 'apply_f2.png', 'Add ALL to Catalog',false );
		JToolBarHelper::customX( 'publish', 'publish.png', 'publish_f2.png', 'Add Selected to Catalog',true );
		JToolBarHelper::customX( 'createcontent', 'copy.png', 'copy_f2.png', 'Add seleced to Content',true );
		JToolBarHelper::customX( 'remove', 'delete.png', 'delete_f2.png', 'Delete Selected',true );
		JToolBarHelper::customX( 'removeall', 'delete.png', 'delete_f2.png', 'Delete All',false );
		JToolBarHelper::editListX();
		JToolBarHelper::addNewX();
		JToolBarHelper::customX( 'close', 'cancel.png', 'cancel_f2.png', 'Close',false );

	}

	function ms_products( &$rows, &$pageNav, &$lists ,$cat_id,$showimage)
	{
		Ms_productsViewProduct::setMs_productsToolbar();
		
		JHTML::_('behavior.tooltip');
		?>
		
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			
			if (pressbutton == 'removeall') {
			    if (confirm('Do you want to clear all products  from  Imported Products ? '))
					 submitform( pressbutton );
			
			}else {
				  submitform( pressbutton );
				
			}
		}
		
		
		</script>
		
		
		<form action="index.php?option=com_cmsshopbuilder&c=ms_product" method="post" name="adminForm">
		<table>
		<tr>
			<td align="left" width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			<td nowrap="nowrap">
				<?php 
				$javascript		= 'onchange="document.adminForm.submit();"';
				?>
				<select class="inputbox" id="cat_id" name="cat_id" <?php echo $javascript ;?> >
				<option value=""><?php echo 'Select Category'; ?></option>
				<?php   echo CmsShopbuilderController_ms_product::cat_tree($cat_id );   ?>
	            </select>
				<?php echo $lists['mcid']; ?>
				<br/>
				
			</td>
			<td nowrap="nowrap">
				<?php echo JText::_( 'Show Product Image' ); ?>:
				<?php echo $lists['showimage'];  	?>
			</td>	
		</tr>
		</table>

			<table class="adminlist">
			<thead>
			
				 <tr>
					<td colspan="8" width = "100%">
						<?php echo $pageNav->getListFooter(); ?>
					</td>
				</tr>
			

				<tr>
					<th width="5%">
						<?php echo JText::_( 'Num' ); ?>
					</th>
					<th width="5%">
						<input type="checkbox" name="toggle" value=""  onclick="checkAll(<?php echo count( $rows ); ?>);" />
					</th>
					<?php if ($showimage) { ?>
						  <th width="10%" nowrap="nowrap" class="title">
						  	<?php echo JText::_( 'Product Image' ); ?>
						  	</th>
					<?php } ?>
							
					<th width="10%" nowrap="nowrap" class="title">
						<?php echo JHTML::_('grid.sort',  'Sku', 'p.product_sku', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th  nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Name', 'p.product_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Price', 'p.product_price', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Sale Price', 'p.product_saleprice', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Category', 'cc.cat_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
				
					<th width="10%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Catalog Status', 'p.product_publish', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="15%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Imported Date', 'p.importdate', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
						
					
				</tr>
			</thead>
			<tfoot>
				<tr>
					
				</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			for ($i=0, $n=count( $rows ); $i < $n; $i++) {
				$row = &$rows[$i];

				$row->id	= $row->product_id;
				$link		= JRoute::_( 'index.php?option=com_cmsshopbuilder&c=ms_product&task=edit&cid[]='. $row->product_id );

				$row->published = $row->product_publish;
				//$published		= JHTML::_('grid.published', $row, $i );
				$published		= $this->addcatalog( $row, $i );
				$checked		= JHTML::_('grid.checkedout',   $row, $i );

				?>
				<tr class="<?php echo "row$k"; ?>">
					<td align="center">
						<?php echo $pageNav->getRowOffset($i); ?>
					</td>
					<td align="center">
						<?php echo $checked; ?>
					</td>
					<?php if ($showimage) { ?>
					<td>
						<img src = "<?php echo $row->product_thumb_image; ?>" width = "100"  />
					</td>
					<?php } ?>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Product SKU' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>'; ?>">
							<?php echo $row->product_sku; ?>
						</a>							
					</td>
					<td>
						<a href="<?php echo $link; ?>" title="<?php echo JText::_( 'Product name' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>'; ?>">
							<?php echo $row->product_name; ?>
						</a>							
					</td>
					
					<td align="center">
						
						 <?php echo $row->currency_code.number_format($row->product_price,2) ; ?>
					</td>
					<td align="center">
						 <?php echo $row->currency_code.number_format($row->product_saleprice,2) ; ?>
					</td>
					<td align="center">
						<?php echo $row->cat_name;?>
					</td>
					
					<td align="center">
						<?php echo $published;?>
					</td>
					<td align="center">
						<?php echo $row->importdate;?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
			</table>

		<input type="hidden" name="c" value="ms_product" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />		
		<input type="hidden" name="boxchecked" value="0" />		
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="" />

		</form>
		<?php
	}

	function setMs_productToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');

		JToolBarHelper::title( $task == 'add' ? JText::_( 'Import manager' ) . ': <small><small>[ '. JText::_( 'New' ) .' ]</small></small>' : JText::_( 'Product' ) . ': <small><small>[ '. JText::_( 'Edit' ) .' ]</small></small>', 'generic.png' );
		JToolBarHelper::save( 'save' );
		JToolBarHelper::apply('apply');
		JToolBarHelper::cancel( 'cancel' );
		JToolBarHelper::help( 'screen.ms_products.edit' );
	}

	function ms_product( &$row, &$lists )
	{
		Ms_productsViewProduct::setMs_productToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		jimport('joomla.filter.output');
		JFilterOutput::objectHTMLSafe( $row, ENT_QUOTES, 'product_desc' );
		?>
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			// do field validation
			if (form.product_name.value == "") {
				alert( "<?php echo JText::_( 'You must provide a product name.', true ); ?>" );
			} else if (getSelectedValue('adminForm','mc_id') =='') {
				alert( "<?php echo JText::_( 'Please select a merchant.', true ); ?>" );
			} else if ( getSelectedValue('adminForm','cat_id') == '') {
				alert( "<?php echo JText::_( 'Please select a category.', true ); ?>" );
			} else {
				submitform( pressbutton );
				
			}
		}
		
		</script>
		<form action="index.php?option=com_cmsshopbuilder&c=ms_product" method="post" name="adminForm">
		<table class="admintable">
		<td width = "50%" valign = "top">
		
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Product Details' ); ?></legend>

				<table class="admintable">
				<tbody>
					<tr>
						
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product SKU' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_sku" id="product_sku" size="60" value="<?php echo $row->product_sku;?>" />
						</td>
					</tr>   
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product Name' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_name" id="product_name" size="60" value="<?php echo $row->product_name;?>" />
						</td>
					</tr>
					 <tr>
						<td class="key">
							<label for="ordering">
								<?php echo JText::_( 'UPC' ); ?>:
							</label>
						</td>
						<td>
							<input class="inputbox" type="text" name="product_upc" id="product_upc" size="20" value="<?php echo $row->product_upc;?>" />
						</td>
					</tr>
					 <tr>
						<td class="key">
							<label for="ordering">
								<?php echo JText::_( 'ISBN' ); ?>:
							</label>
						</td>
						<td>
							<input class="inputbox" type="text" name="product_isbn" id="product_isbn" size="20" value="<?php echo $row->product_isbn;?>" />
						</td>
					</tr>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Alias' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="alias" id="alias" size="60" value="<?php echo $row->alias;?>" />
						</td>
					</tr>
					<tr>
						<td width="20%" class="key">
							<label for="name">
								<?php echo JText::_( 'Product Url' ); ?>:
							</label>
						</td>
						<td width="80%">
							<input class="inputbox" type="text" name="product_url" id="product_url" size="60" value="<?php echo $row->product_url;?>" />
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_( 'Publish' ); ?>:
						</td>
						<td>
							<?php echo $lists['publish']; ?>
						</td>
					</tr>
					
					
					<tr>
						<td valign="top" align="right" class="key">
							<label for="catid">
								<?php echo JText::_( 'Category' ); ?>:
							</label>
						</td>
						<td>
							<select class="inputbox" id="cat_id" name="cat_id"  >
							<option value=""><?php echo 'Select Category'; ?></option>
							<?php   echo CmsShopbuilderController_ms_product::cat_tree($row->cat_id );   ?>
				            </select>
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_( 'Merchant/Store' ); ?>:
						</td>
						<td>
							<?php echo $lists['mcid']; ?>
						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="cid">
								<?php echo JText::_( 'Product Price' ); ?>:
							</label>
						</td>
						<td >
							
							<input class="inputbox" type="text" name="product_price" id="product_price" size="20" value="<?php echo $row->product_price;?>" />

						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="cid">
								<?php echo JText::_( 'Product Sale Price' ); ?>:
							</label>
						</td>
						<td >
							
							<input class="inputbox" type="text" name="product_saleprice" id="product_saleprice" size="20" value="<?php echo $row->product_saleprice;?>" />

						</td>
					</tr>
					<tr>
						<td class="key">
							<label for="cid">
								<?php echo JText::_( 'Price Currency' ); ?>:
							</label>
						</td>
						<td >
							<?php echo $lists['curid']; ?>
						</td>
					</tr>
					<tr >
						<td valign="top" align="right" class="key">
							<?php echo JText::_( 'Hits' ); ?>
						</td>
						<td colspan="2">
							<?php echo $row->hits;?>
							&nbsp;&nbsp;&nbsp;&nbsp;
							<input name="reset_hits" type="button" class="button" value="<?php echo JText::_( 'Reset hits' ); ?>" onclick="submitbutton('resethits');" />
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<label for="Description">
								<?php echo JText::_( 'Product Description' ); ?>:
							</label>
						</td>
						<td>
							<textarea class="inputbox" cols="43" rows="8" name="product_desc" id="product_desc"><?php echo base64_decode($row->product_desc);?></textarea>
						</td>
					</tr>
					

					<tr>
						<td valign="top" class="key">
							<label for="tags">
								<?php echo JText::_( 'Tags' ); ?>:
							</label>
						</td>
						<td>
							<textarea class="inputbox" cols="43" rows="3" name="tags" id="tags"><?php echo $row->tags;?></textarea>
						</td>
					</tr>
				</tbody>
				</table>
			</fieldset>
		</td>		   
		
		<td width = "50%" valign = "top">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Product Images' ); ?></legend>
				<table class="admintable">
					 <tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Small Image url' ); ?>:
						</td>
						<td valign="top">
							<input class="inputbox" type="text" name="product_thumb_image" id="product_thumb_image" size="60" value="<?php echo $row->product_thumb_image;?>" /><br/><br/>
							<img src="<? echo $row->product_thumb_image ?> " name="Small Image">
						</td>
					</tr>
					<tr>
						<td valign="top" class="key">
							<?php echo JText::_( 'Full image url' ); ?>:
						</td>
						<td valign="top">
							<input class="inputbox" type="text" name="product_full_image" id="product_full_image" size="60" value="<?php echo $row->product_full_image;?>" /><br/><br/>
							<img src="<? echo $row->product_full_image ?> " name="Small Image">
						</td>
					</tr>
				</table>
			</fieldset>
		</td>		
		</table>

		<input type="hidden" name="c" value="ms_product" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="product_id" value="<?php echo $row->product_id; ?>" />
		
		<input type="hidden" name="task" value="" />

		</form>
		<?php
	}
	//create product content
	function setMs_productCreatecontentToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');
		JToolBarHelper::title( JText::_( 'Create Products Content' ) , 'generic.png' );
		JToolBarHelper::save( 'savecontentproduct' );
		JToolBarHelper::cancel( 'cancel' );
		
	}

	function createcontent( $rows,$sectCatList )
	{
		Ms_productsViewProduct::setMs_productCreatecontentToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		
		?>
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}else {
				  submitform( pressbutton );
				
			}
		}
		
		</script>
		
		<form action="index.php?option=com_cmsshopbuilder&c=ms_product" method="post" name="adminForm">
		<table class="admintable">
		<td width = "50%" valign = "top">
			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Products  being create content' ); ?></legend>
				<table class="adminlist">
					<tr>
						<th width="20">
							<?php echo JText::_( 'Num' ); ?>
						</th>
						<th width="80%" nowrap="nowrap" class="title">
							<?php echo JText::_( 'Product Name' ); ?>
						</th>
						
					</tr>
					<tbody>
					<?php
					
					$k = 0;
					for ($i=0, $n=count( $rows ); $i < $n; $i++) {
					
						$row = $rows[$i];
						
						?>
						<tr class="<?php echo "row$k"; ?>">
							<td align="left">
								<?php echo $i+1; ?>
							</td>
							
							<td align="left">
								<?php echo $row->product_name; ?>
							</td>
						</tr>	
					
						<?php
						$k = 1 - $k;
						$id = $row->product_id ; 
						echo "\n <input type=\"hidden\" name=\"cid[]\" value=\"$id\" />";
						
					}
					?>
					</tbody>
				</table>
			</fieldset>
		</td>	

		<td width = "50%" valign = "top">	

			<fieldset class="adminform">
				<legend><?php echo JText::_( 'Create to Content Section/Category  ' ); ?></legend>
				<table class="admintable">
				<tbody>
					<tr>
						
						<td>
							<?php   echo $sectCatList;   ?>
						</td>
					</tr>
					
				</tbody>
				</table>
				
			</fieldset>
		</td>		 
		</table>

		<input type="hidden" name="c" value="ms_product" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="savecontentproduct" />
		
		</form>
		<?php
	}
	//clare all imported product
	function setMs_productClearallimportToolbar()
	{
		$task = JRequest::getVar( 'task', '', 'method', 'string');
		JToolBarHelper::title( JText::_( 'Clear all data from import process' ) , 'generic.png' );
		JToolBarHelper::customX( 'removeall', 'delete.png', 'delete_f2.png', 'Purge All',false );
		JToolBarHelper::customX( 'saveclearall', 'delete.png', 'delete_f2.png', 'Purge Seleced',true );
		JToolBarHelper::cancel( 'close' );
		
	}

	function clearallimport( &$rows, &$pageNav )
	{
		Ms_productsViewProduct::setMs_productClearallimportToolbar();
		JRequest::setVar( 'hidemainmenu', 1 );
		
		?>
		<script language="javascript" type="text/javascript">
		
		
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			if (pressbutton == 'removeall') {
			    if (confirm('Do you want to clear all products and categories from all Imported Products ? (Not Product and category in catalog item)'))
					 submitform( pressbutton );
			}else if (pressbutton == 'saveclearall') {
			    if (confirm('Do you want to clear all products and categories from Selected Imported Products ? (Not Product and category in catalog item)'))
					 submitform( pressbutton );
			}else {
				  submitform( pressbutton );
				
			}
		}
		
		
		</script>
		
		<form action="index.php?option=com_cmsshopbuilder&c=ms_product" method="post" name="adminForm">
		<div class="col100">
				<table class="adminlist">
				<thead>
						<tr>
							<td colspan="5">
								<?php echo $pageNav->getListFooter(); ?>
							</td>
						</tr>   
						<tr>
							<th width="10">
								<?php echo JText::_( 'Num' ); ?>
							</th>
							
							<th width="10">
								<input type="checkbox" name="toggle" value=""  onclick="checkAll(<?php echo count( $rows ); ?>);" />
							</th>
							<th  width="30%" nowrap="nowrap" class="title">
								<?php echo JText::_( 'File name' ); ?>
							</th>
							
							<th width="30%" nowrap="nowrap" >
								<?php echo JText::_( 'Feed Define name' ); ?>
							</th>
							
							<th width="30%" nowrap="nowrap">
								<?php echo JText::_( 'Imported Date' ); ?>					
							</th>
							
						</tr>
				</thead>
				<tfoot>
				<tr>
					
				</tr>
			    </tfoot>
				<tbody>
				<?php
				$k = 0;
				for ($i=0, $n=count( $rows ); $i < $n; $i++) {
					$row = &$rows[$i];
					$row->id	= $row->fid;
					$checked		= JHTML::_('grid.checkedout',   $row, $i );
					?>
						<tr class="<?php echo "row$k"; ?>">
							<td align="center">
								<?php echo $pageNav->getRowOffset($i); ?>
							</td>
							<td align="center">
								<?php echo $checked; ?>
							</td>
							
							<td align = "left">
	
								<?php echo $row->filename;?>
							</td>
							<td align = "left">
								<?php echo $row->feedname;?>
		
							</td>
						
							<td align = "center" >
								
								<?php    echo $row->dateimport ; 			?>
							</td>
							
						</tr>
						<?php
						$k = 1 - $k;
				}
				
				?>
				</tbody>
				</table>
				
			
		</div>		
		
		<div class="clr"></div>

		<input type="hidden" name="c" value="ms_product" />
		<input type="hidden" name="option" value="com_cmsshopbuilder" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />

		
		</form>
		<?php
	}
}