<?php
// Custom Gallery admin HTML
class CustomGalleryView {
    function showDashboard() {
        echo 'Dashboard here';
    }
    
    function showGalleries( &$rows, &$lists, &$page ) {
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
    
        require_once ( JPATH_COMPONENT_ADMINISTRATOR.DS.'configuration.php' );
        $cgConfig = new cgConfig();
        $db = &JFactory::getDBO();
        $user = &JFactory::getUser();
        //JToolBarHelper::title(   JText::_( 'Gallery Manager' ), 'generic.png' );
        JToolBarHelper::addNewX('gallery');
        JToolBarHelper::editListX('gallery');
        JToolBarHelper::deleteList(JText::_('DELETE_GALLERIES'),'remove_gallery');
        JHTML::_('behavior.tooltip');
        ?>
        <form action="index.php?option=com_customgallery" method="post" name="adminForm">

            <table>
                <tr>
                    <td width="100%">
                        <?php echo JText::_( 'Filter' ); ?>:
                        <input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" title="<?php echo JText::_( 'FILTER_BY_TITLE' );?>"/>
                        <button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
                        <button onclick="document.getElementById('search').value='';this.form.getElementById('filter_sectionid').value='-1';this.form.getElementById('catid').value='0';this.form.getElementById('filter_authorid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
                    </td>
                    <td nowrap="nowrap">
                        <?php
                        //echo $lists['sectionid'];
                        //echo $lists['catid'];
                        //echo $lists['authorid'];
                        //echo $lists['state'];
                        ?>
                    </td>
                </tr>
            </table>

            <table class="adminlist" cellspacing="1">
            <thead>
                <tr>
                    <th width="5%" align="center">
                        <?php echo JText::_( 'Num' ); ?>
                    </th>
                    <th width="5%" align="center">
                        <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
                    </th>
                    <th class="title">
                        <?php echo JText::_('Gallery Title'); ?>
                    </th>
                    <th width="1%" nowrap="nowrap">
                        <?php echo JText::_('Published'); ?>
                    </th>
                </tr>
            </thead>
            <tfoot>
            <tr>
                <td colspan="15">
                    <?php echo $page->getListFooter(); ?>
                </td>
            </tr>
            </tfoot>
            <tbody>
            <?php
            $k = 0;
            $nullDate = $db->getNullDate();
            for ($i=0, $n=count( $rows ); $i < $n; $i++)
            {
                $row = &$rows[$i];
                $img = ($row->published)? 'publish_g.png':'publish_r.png';

                $link     = 'index.php?option=com_customgallery&task=gallery&cid[]='. $row->id;

                //$access     = JHTML::_('grid.access',   $row, $i, $row->state );
                $row->checked_out = 0;
                $checked     = JHTML::_('grid.checkedout',   $row, $i );
                ?>
                <tr class="<?php echo "row$k"; ?>">
                    <td align="center">
                        <?php echo $page->getRowOffset( $i ); ?>
                    </td>
                    <td align="center">
                        <?php echo $checked; ?>
                    </td>
                    <td>
                            <a href="<?php echo JRoute::_( $link ); ?>"><?php echo htmlspecialchars($row->name, ENT_QUOTES); ?></a>
                    </td>
                    <td align="center">
                            <span class="editlinktip hasTip" title="<?php echo JText::_( 'Publish Information' );?>::<?php echo $times; ?>"><a href="javascript:void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $row->state ? 'unpublish' : 'publish' ?>')"><img src="images/<?php echo $img;?>" width="16" height="16" border="0" alt="<?php echo $alt; ?>" /></a></span>
                    </td>
                    
                </tr>
                <?php
                $k = 1 - $k;
            }
            ?>
            </tbody>
            </table>
            <?php //JHTML::_('content.legend'); ?>

        <input type="hidden" name="option" value="com_customgallery" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="redirect" value="<?php echo $redirect;?>" />
        <input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
        
    } // showGalleries
    
    function showGallery( &$row, &$lists ) {
    
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
        $option = JRequest::getCmd('option');
        $title = isset($row->name)?$row->name:'New';
        //JToolBarHelper::title( JText::_( ucfirst($title) . ' Gallery' ), 'generic.png' );
        if($row->id) JToolBarHelper::addNew('entry', JText::_('New'));
        JToolBarHelper::save('save_gallery');
        JToolBarHelper::cancel('galleries');
        //JToolBarHelper::editListX('gallery');
        //JToolBarHelper::addNewX('gallery');
        
        $editor = &JFactory::getEditor();
        ?>
        <form action="index.php" method="post" name="adminForm">

        <table cellspacing="0" cellpadding="2" border="0" width="100%">
        <tr>
            <td valign="top">
                <table class="adminform">
                <tr>
                    <td width="10%">
                        <?php echo JText::_('Gallery Name'); ?>:
                    </td>
                    <td>
                        <input type="text" name="name" value="<?php echo $row->name; ?>" maxlength="25" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <?php echo JText::_('Gallery Category'); ?>:
                    </td>
                    <td>
                        <?php echo $lists['categories']; ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        <?php echo JText::_('Description'); ?>:
                    </td>
                    <td>&nbsp;</td>
                </tr>
                <tr>
                    <td colspan="2">
                        <?php echo $editor->display('description',$row->description,'100%','200','75','20'); ?>
                    </td>
                </tr>
            </table>
            <input type="hidden" name="gallery_id" value="<?php echo $row->id; ?>" />
            
            <input type="hidden" name="mask" value="0" />
            <input type="hidden" name="option" value="<?php echo $option;?>" />
            <input type="hidden" name="task" value="" />
            <?php echo JHTML::_( 'form.token' ); ?>
            </form>
            
                <?php if( count($lists['entries']) ) { ?>
                <h2><?php echo JText::_('Entries'); ?></h2>
                <table class="adminform">
                <tr>
                    <th><?php echo JText::_('Name'); ?></th>
                    <th><?php echo JText::_('Category'); ?></th>
                    <!-- <th><?php echo JText::_('Type'); ?></th> -->
                    <th><?php echo JText::_('Image'); ?></th>
                    <th><?php echo JText::_('Options'); ?></th>
                </tr>
                <?php foreach( $lists['entries'] as $entry ) {
                        $link = "index2.php?option=com_customgallery";
                        if(!empty($entry->media_id)) {
                            include_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'videothumb.php');
                            $v_thumb = new videothumb($entry);
                            $img_url = $v_thumb->getURL();
                            /*if($entry->media_type == 1) $img_url = 'http://s2.ytimg.com/vi/'.$entry->media_id.'/default.jpg';
                            if($entry->media_type == 2) {
                                // Get the Google video XML.
                                $media_xml = file_get_contents("http://video.google.com/videofeed?docid=".$entry->media_id);
                                if(!empty($media_xml)) {
                                    preg_match('/<media:thumbnail url="([^"]+)/',$media_xml,$thumbnail_array);
                                    $img_url = $thumbnail_array[1];
                                    
                                    $img_url = str_replace('amp;','',$img_url);
                                } else {
                                    $img_url = JURI::root() . 'components/com_customgallery/assets/empty_thumb.png';
                                }
                            }*/
                            // $yahooThumbnailUrl="http://thmg01.video.search.yahoo.com/image/";
                            // $metacafeThumbnailUrl="http://www.metacafe.com/thumb/";
                            // $revverThumbnailUrl="http://frame.revver.com/frame/120x90/";
                            // $dailymotionThumbnailUrl="http://www.dailymotion.com/thumbnail/160x120/video/";
                            // $divshareThumbnailUrl="http://www.divshare.com/direct/video_thumb/";
                            // $stickamThumbnailUrl="http://static.stickam.com/";
                            // $myspaceThumbnailUrl="http://mediaservices.myspace.com/services/rss.ashx?type=video&videoID=";
                            
                            if(!isset($img_url)) $img_url = JURI::root() . 'components/com_customgallery/assets/empty_video_thumb.png';
                        } else {
                            $img_url = JURI::root() . 'media/customgallery/'.$entry->gallery_id.'/'.$entry->filename;
                        }
                ?>
                <tr>
                    <td>
                        <?php echo $entry->name;
                        // parameters : areaname, content, width, height, cols, rows
                        // echo $editor->display( 'text',  $row->text , '100%', '550', '75', '20' ) ;
                        ?>
                    </td>
                    <td>
                        <?php echo $entry->category; ?>
                    </td>
                    <!-- <td>
                        <?php //echo $entry->type; ?>
                    </td> -->
                    <td>
                        <img src="<?php echo $img_url; ?>" width="75" />
                    </td>
                    <td>
                        <a class="cg_remove_button" href="<?php echo $link.'&task=remove_entry&gallery_id='.$row->id.'&cid[]='.$entry->id; ?>" >[<?php echo JText::_('Remove'); ?>]</a>
                        <?php if( $row->entry_id == $entry->id ) { ?>
                        <span class="cg_currthumb_button">[<?php echo JText::_('CURRENT_THUMB'); ?>]</span>
                        <?php } else { ?>
                        <a class="cg_mkthumb_button" href="<?php echo $link.'&task=make_thumb&gallery_id='.$row->id.'&id='.$entry->id; ?>" >[<?php echo JText::_('MAKE_THUMB'); ?>]</a>
                        <?php } ?>
                        <a class="cg_edit_button" href="<?php echo $link.'&task=entry&cid[]='.$entry->id; ?>" >[<?php echo JText::_('Edit'); ?>]</a>
                        <a class="cg_comments_button" href="<?php echo $link.'&task=comments&entry_id='.$entry->id; ?>" >[<?php echo JText::_('VIEW_COMMENTS'); ?> (<?php echo $entry->comment_count; ?>)]</a>
                        <a class="<?php echo $entry->published?'cg_unpub_button':'cg_pub_button'; ?>" href="<?php echo $link.'&task=change_entry&cid[]='.$entry->id; ?>" >[<?php echo $entry->published ? JText::_('Unpublish') : JText::_('Publish'); ?>]</a>
                    </td>
                </tr>
                <?php } ?>
                </table>
                <?php } else { ?>
                <h2><?php echo JText::_('NO_ENTRIES'); ?></h2>
                <?php if(!$row->id) echo '<p>', JText::_('First save this gallery to add new entries'), '</p>';
                      } ?>
            </td>
        </tr>
        </table>

        
        <?php
        
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
        
    }
    
    function showEntry( &$row, $lists ) {
    
    	//include our helper file to create the footer and buttons
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
		//set our page header
		JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
		//Include our stylesheet for our Ninja Component Styling
		$document =& JFactory::getDocument();
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());

		//add ie6 css if needed
		$ua = $_SERVER['HTTP_USER_AGENT'];
		if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
			$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
			$document->addStyleSheet($cssFile, 'text/css', null, array());
		}
    
    
    
        $title = (isset($row->name))?$row->name:JText::_('New entry');
        //JToolBarHelper::title( $title, 'generic.png' );
        JToolBarHelper::custom('comments','edit.png',null, JText::_('Comments'),false);
        JToolBarHelper::save('save_entry');
        JToolBarHelper::cancel('cancel_entry');
        $editor = &JFactory::getEditor();
        $option = JRequest::getCmd('option');
        ?>
        
        <form action="index.php" method="post" name="adminForm" enctype="multipart/form-data">
        <input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
        <table cellspacing="0" cellpadding="2" border="0" width="100%">
        <tr>
            <td><?php echo JText::_('Name'); ?>:</td>
            <td><input type="text" name="name" value="<?php echo $row->name; ?>" maxlength="25" /></td>
            <td width="40%" rowspan="4" valign="top" style="padding-left:20px;">
                <?php
                if ($row->media_type) {
                    include_once(JPATH_COMPONENT_ADMINISTRATOR . DS . 'helpers' . DS . 'videothumb.php');
                    $v_thumb = new videothumb($row);
                    ?>
                    <img src="<?php echo $v_thumb->getURL(); ?>" />
                    <?php
                } elseif (!empty($row->filename)) { ?>
                    <img src="<?php echo JURI::root().'media/customgallery/'.$row->gallery_id.'/'.$row->filename; ?>" width="200" />
                <?php } ?>
                <table cellspacing="0" cellpadding="2" border="0" width="100%">
            <?php
            foreach( $lists['custom_fields'] as $custom_field ) {
                echo '<tr>';
                echo '<td width="30%" valign="top">'.$custom_field['label'].'</td>';
                echo '<td>'.$custom_field['html'].'</td>';
                echo '</tr>';
            }
            ?>
                </table>
            </td>
        </tr>
        <tr>
            <td><?php echo JText::_('Gallery'); ?>: </td>
            <td><?php echo $lists['gallery']; ?></td>
        </tr>
        <!-- <tr>
            <td><?php echo JText::_('Category'); ?>:</td>
            <td><?php //echo $lists['category']; ?></td>
        </tr> -->
        <tr>
            <td valign="top"><?php echo JText::_('Description'); ?>:&nbsp;</td>
            <td><?php echo $editor->display('description',$row->description,'100%','200','75','20'); ?></td>
        </tr>
        <tr>
            <td colspan="2">
                <fieldset><legend><?php echo JText::_('Media Details'); ?></legend>
                <table>
                    <tr>
                        <td valign="top"><?php echo JText::_('Media ID'); ?>:</td>
                        <td><?php echo $lists['media']; ?></td>
                    </tr>
                    <tr>
                        <td valign="top"><?php echo JText::_('Filename'); ?>:</td>
                        <td><input type="file" name="filename" size="64"/> (Max <?php echo ini_get('upload_max_filesize'); ?>)<br /><small><?php echo JText::_('Current Media'); ?>: <b><?php echo $row->filename; ?></b></small></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        </table>
        <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
        <input type="hidden" name="published" value="<?php echo $row->id ? $row->published : 1; ?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="option" value="<?php echo $option; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
    <?php
    
    	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    
    }
    
    function showCategories( &$rows, &$page, &$lists ) {
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
        $db = &JFactory::getDBO();
        $user = &JFactory::getUser();
        //JToolBarHelper::title(   JText::_( 'Category Manager' ), 'generic.png' );
        JToolBarHelper::addNewX('category');
        JToolBarHelper::editListX('category');
        JToolBarHelper::deleteList(JText::_('DELETE_CATEGORIES'),'remove_category');
        
        JHTML::_('behavior.tooltip');
        ?>
        <form action="index.php?option=com_customgallery" method="post" name="adminForm">

            <table>
                <tr>
                    <td width="100%">
                        <?php echo JText::_( 'Filter' ); ?>:
                        <input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" title="<?php echo JText::_( 'Filter by title or enter article ID' );?>"/>
                        <button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
                        <button onclick="document.getElementById('search').value='';this.form.getElementById('filter_sectionid').value='-1';this.form.getElementById('catid').value='0';this.form.getElementById('filter_authorid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
                    </td>
                    <td nowrap="nowrap">
                        <?php
                        //echo $lists['sectionid'];
                        //echo $lists['catid'];
                        //echo $lists['authorid'];
                        //echo $lists['state'];
                        ?>
                    </td>
                </tr>
            </table>

            <table class="adminlist" cellspacing="1">
            <thead>
                <tr>
                    <th width="5%" align="center">
                        <?php echo JText::_( 'Num' ); ?>
                    </th>
                    <th width="5%" align="center">
                        <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
                    </th>
                    <th class="title">
                        <?php echo JText::_('Category Title'); ?>
                    </th>
                </tr>
            </thead>
            <tfoot>
            <tr>
                <td colspan="15">
                    <?php //echo $page->getListFooter(); ?>
                </td>
            </tr>
            </tfoot>
            <tbody>
            <?php
            $k = 0;
            $nullDate = $db->getNullDate();
            for ($i=0, $n=count( $rows ); $i < $n; $i++)
            {
                $row = &$rows[$i];
                //$img = ($row->published)? 'publish_g.png':'publish_r.png';

                $link     = 'index.php?option=com_customgallery&task=category&cid[]='. $row->id;


                //$access     = JHTML::_('grid.access',   $row, $i, $row->state );
                $row->checked_out = 0;
                $checked     = JHTML::_('grid.checkedout',   $row, $i );
                ?>
                <tr class="<?php echo "row$k"; ?>">
                    <td align="center">
                        <?php echo $page->getRowOffset( $i ); ?>
                    </td>
                    <td align="center">
                        <?php echo $checked; ?>
                    </td>
                    <td>
                            <a href="<?php echo JRoute::_( $link ); ?>"><?php echo htmlspecialchars($row->name, ENT_QUOTES); ?></a>
                    </td>
                </tr>
                <?php
                $k = 1 - $k;
            }
            ?>
            </tbody>
            </table>
            <?php //JHTML::_('content.legend'); ?>

        <input type="hidden" name="option" value="com_customgallery" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="redirect" value="<?php echo $redirect;?>" />
        <input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    }
    
    function showCategory( &$row ) {
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
        $title = (isset($row->name))?$row->name:JText::_('New category');
        //JToolBarHelper::title( $title, 'generic.png' );
        JToolBarHelper::save('save_category');
        JToolBarHelper::cancel('categories');
        $editor = &JFactory::getEditor();
        $option = JRequest::getCmd('option');
        ?>
        
        <form action="index.php" method="post" name="adminForm">

        <table cellspacing="0" cellpadding="2" border="0" width="100%">
            <tr>
                <td><?php echo JText::_('Name'); ?>:</td>
                <td><input type="text" class="inputbox" name="name" value="<?php echo $row->name; ?>" maxlength="25" /></td>
            </tr>        
        </table>
        <input type="hidden" name="task" value="save_category" />
        <input type="hidden" name="option" value="<?php echo $option; ?>" />
        <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    }
    
    function showFields( &$rows, &$field_options, &$lists, &$page ) {
    
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
    
    
        $db = &JFactory::getDBO();
        $user = &JFactory::getUser();
        //JToolBarHelper::title(   JText::_( 'Custom Field Manager' ), 'generic.png' );
        JToolBarHelper::addNewX('field');
        JToolBarHelper::editListX('fields');
        JToolBarHelper::deleteList(JText::_('DELETE_FIELDS'),'remove_field');
        
        $ordering = true;
        
        JHTML::_('behavior.tooltip');
        ?>
        <form action="index.php?option=com_customgallery" method="post" name="adminForm">

            <table>
                <tr>
                    <td width="100%">
                        <?php echo JText::_( 'Filter' ); ?>:
                        <input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" title="<?php echo JText::_( 'Filter by title or enter article ID' );?>"/>
                        <button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
                        <button onclick="document.getElementById('search').value='';this.form.getElementById('filter_sectionid').value='-1';this.form.getElementById('catid').value='0';this.form.getElementById('filter_authorid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
                    </td>
                    <td nowrap="nowrap">
                        <?php
                        //echo $lists['sectionid'];
                        //echo $lists['catid'];
                        //echo $lists['authorid'];
                        //echo $lists['state'];
                        ?>
                    </td>
                </tr>
            </table>

            <table class="adminlist" cellspacing="1">
            <thead>
                <tr>
                    <th width="5%" align="center">
                        <?php echo JText::_( 'Num' ); ?>
                    </th>
                    <th width="5%" align="center">
                        <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
                    </th>
                    <th class="title">
                        <?php echo JText::_('Field name'); ?>
                    </th>
                    <th>
                        <?php echo JText::_('Field type'); ?>
                    </th>
                    <th width="10%">
                        <?php echo JText::_('Ordering'); ?>
                        <?php echo JHTML::_('grid.order',  $rows, 'filesave.png', 'fieldsaveorder' ); ?>
                    </th>
                </tr>
            </thead>
            <tfoot>
            <tr>
                <td colspan="15">
                    <?php //echo $page->getListFooter(); ?>
                </td>
            </tr>
            </tfoot>
            <tbody>
            <?php
            $k = 0;
            $nullDate = $db->getNullDate();
            for ($i=0, $n=count( $rows ); $i < $n; $i++)
            {
                $row = &$rows[$i];
                //$img = ($row->published)? 'publish_g.png':'publish_r.png';

                $link     = 'index.php?option=com_customgallery&task=field&cid[]='. $row->id;


                //$access     = JHTML::_('grid.access',   $row, $i, $row->state );
                $row->checked_out = 0;
                $checked     = JHTML::_('grid.checkedout',   $row, $i );
                ?>
                <tr class="<?php echo "row$k"; ?>">
                    <td align="center">
                        <?php echo $page->getRowOffset( $i ); ?>
                    </td>
                    <td align="center">
                        <?php echo $checked; ?>
                    </td>
                    <td>
                            <a href="<?php echo JRoute::_( $link ); ?>"><?php echo htmlspecialchars($row->name, ENT_QUOTES); ?></a>
                    </td>
                    <td><?php echo $lists['field_types'][$row->type]; ?></td>
                    <td>
                        <span><?php echo $page->orderUpIcon( $i, true, 'fieldorderup', JText::_('Move Up'), $ordering); ?></span>
                        <span><?php echo $page->orderDownIcon( $i, $n, true, 'fieldorderdown', JText::_('Move Down'), $ordering ); ?></span>
                        <?php $disabled = $ordering ?  '' : 'disabled="disabled"'; ?>
                        <input type="text" name="order[]" size="5" value="<?php echo $row->ordering; ?>" <?php echo $disabled; ?> class="text_area" style="text-align: center" />
                    </td>
                </tr>
                    
                <?php
                $k = 1 - $k;
            }
            ?>
            </tbody>
            </table>
            <?php //JHTML::_('content.legend'); ?>

        <input type="hidden" name="option" value="com_customgallery" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="redirect" value="<?php echo $redirect;?>" />
        <input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    }
    
    function showField( &$row, &$custom_fields, &$lists ) {
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
        $no_pipe = JText::_('NO_PIPE', true);
        global $mainframe;
        $js = '
        var boxindex = 0;
        var fieldid = 0;
        function submitbutton(pressbutton) {
            var form = document.adminForm;
            var field_options = form.field_options;
            var listfield_options = form.listfield_options;
            for(i=0;i<field_options.options.length;i++){
                field_options.options[i].selected = true;
            }
            for(i=0;i<listfield_options.options.length;i++){
                listfield_options.options[i].selected = true;
            }
            submitform( pressbutton );
        }
        
        function add2list(){
            var form = document.adminForm;
            var option_list = form.field_options;
            var lgth = option_list.options.length;
            
            if( (form.new_opt_val.value.indexOf("|")>-1) || (form.new_opt_text.value.indexOf("|")>-1) ) {
                alert("'.$no_pipe.'");
            } else {
                option_list.options[lgth] = new Option(form.new_opt_val.value + "-" + form.new_opt_text.value,"0|" + form.new_opt_val.value + "|" + form.new_opt_text.value);
                form.new_opt_val.value = "";
                form.new_opt_text.value = "";
            }
        }
        
        function removeoption(){
            var form = document.adminForm;
            var option_list = form.field_options;
            var sel = option_list.options.selectedIndex;
            option_list.options[sel] = null;
        }
        
        function updatepdoption() {
            var form = document.adminForm;
            var option_list = form.field_options;
            if( (form.new_opt_val.value.indexOf("|")>-1) || (form.new_opt_text.value.indexOf("|")>-1) ) {
                alert("'.$no_pipe.'");
            } else {
                option_list.options[boxindex].text = form.new_opt_val.value + "-" + form.new_opt_text.value;
                option_list.options[boxindex].value = fieldid + "|" + form.new_opt_val.value + "|" + form.new_opt_text.value;
                form.new_opt_val.value = "";
                form.new_opt_text.value = "";
                form.pdadd.value = "Add";
                form.pdadd.onclick = add2list;
                
            }
        }
        
        function editpdoption() {
            var form = document.adminForm;
            var option_list = form.field_options;
            var str = option_list.options[option_list.selectedIndex].value;
            var textstr = option_list.options[option_list.selectedIndex].text;
            var splitvals = str.split("|",3);
            var splittext = textstr.split("-",2);
            form.new_opt_val.value = splitvals[1];
            form.new_opt_text.value = splittext[1];
            form.pdadd.value = "Update";
            form.pdadd.onclick = updatepdoption;
            boxindex = option_list.selectedIndex;
            fieldid = splitvals[0];
        }
        
        function add2sellist() {
            var form = document.adminForm;
            var option_list = form.listfield_options;
            var lgth = option_list.options.length;
            
            if( (form.new_listopt_val.value.indexOf("|")>-1) || (form.new_listopt_text.value.indexOf("|")>-1) ) {
                alert("'.$no_pipe.'");
            } else {
                option_list.options[lgth] = new Option(form.new_listopt_val.value + "-" + form.new_listopt_text.value,"0|" + form.new_listopt_val.value + "|" + form.new_listopt_text.value);
                form.new_listopt_val.value = "";
                form.new_listopt_text.value = "";
            }
        }
        
        function removeseloption() {
            var form = document.adminForm;
            var option_list = form.listfield_options;
            var sel = option_list.options.selectedIndex;
            option_list.options[sel] = null;
        }
        
        function updateseloption() {
            var form = document.adminForm;
            var option_list = form.listfield_options;
            if( (form.new_listopt_val.value.indexOf("|")>-1) || (form.new_listopt_text.value.indexOf("|")>-1) ) {
                alert("'.$no_pipe.'");
            } else {
                option_list.options[boxindex].text = form.new_listopt_val.value + "-" + form.new_listopt_text.value;
                option_list.options[boxindex].value = fieldid + "|" + form.new_listopt_val.value + "|" + form.new_listopt_text.value;
                form.new_listopt_val.value = "";
                form.new_listopt_text.value = "";
                form.listadd.value = "Add";
                form.listadd.onclick = add2sellist;
                
            }
        }
        
        function editseloption() {
            var form = document.adminForm;
            var option_list = form.listfield_options;
            var str = option_list.options[option_list.selectedIndex].value;
            var textstr = option_list.options[option_list.selectedIndex].text;
            var splitvals = str.split("|",3);
            var splittext = textstr.split("-",2);
            form.new_listopt_val.value = splitvals[1];
            form.new_listopt_text.value = splittext[1];
            form.listadd.value = "Update";
            form.listadd.onclick = updateseloption;
            boxindex = option_list.selectedIndex;
            fieldid = splitvals[0];
        }
        ';
        $doc = &JFactory::getDocument();
        $doc->addScriptDeclaration( $js );
        $title = (isset($row->name))?$row->name:JText::_('New field');
        //JToolBarHelper::title( $title, 'generic.png' );
        JToolBarHelper::save('save_field');
        JToolBarHelper::cancel('fields');
        jimport('joomla.html.pane');
        $pane    =& JPane::getInstance('sliders');
        $editor = &JFactory::getEditor();
        $option = JRequest::getCmd('option');
        
        ?>
        
        <form action="index.php" method="post" name="adminForm">

        <table cellspacing="0" cellpadding="2" border="0" width="100%">
            <tr>
                <td><?php echo JText::_('Name'); ?>:</td>
                <td><input type="text" name="name" value="<?php echo $row->name; ?>" maxlength="25" /></td>
                <td rowspan="3">
                <?php
                    $title = JText::_( 'PARAM_TEXT_FIELD' );
                    echo $pane->startPane("content-pane");
                    echo $pane->startPanel( $title, "txtfield-page" );
                ?>
					<table>
                    <tr>
                        <td><?php echo $lists['txtfield_options']; ?></td>
                    </tr>
					</table>
                <?php
                    $title = JText::_( 'PARAM_PULL_DOWN' );
                    echo $pane->endPanel();
                    echo $pane->startPanel( $title, "pdfield-page" );
                ?>
					<table>
                    <tr>
                        <td>
                            <?php echo $lists['pdfield_options']; ?><input type="button" name="remove_option" value="<?php echo JText::_('Remove'); ?>" onclick="removeoption()" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            
                            <fieldset><legend><?php echo JText::_('Add option'); ?></legend>
                                <?php echo JText::_('Option Value'); ?>:<input type="text" name="new_opt_val" value="" />
                                <?php echo JText::_('Option Label'); ?>:<input type="text" name="new_opt_text" value="" /><input type="button" id="pdadd" name="add" value="<?php echo JText::_('Add'); ?>" onclick="add2list()" />
                            </fieldset>
                            
                        </td>
                    </tr>
                </table>
                <?php
                    $title = JText::_( 'PARAM_LISTBOX' );
                    echo $pane->endPanel();
                    echo $pane->startPanel( $title, "lbfield-page" );
                ?>
                <table>
                    <tr>
                        <td>
                            <?php echo $lists['listfield_options']; ?><input type="button" name="remove_listoption" value="<?php echo JText::_('Remove'); ?>" onclick="removelistoption()" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            
                            <fieldset><legend><?php echo JText::_('Add option'); ?></legend>
                                <?php echo JText::_('Option Value'); ?>:<input type="text" name="new_listopt_val" value="" />
                                <?php echo JText::_('Option Label'); ?>:<input type="text" name="new_listopt_text" value="" /><input type="button" id="listadd" name="add" value="<?php echo JText::_('Add'); ?>" onclick="add2sellist()" />
                            </fieldset>
                            
                        </td>
                    </tr>
                </table>
                <?php
                    echo $pane->endPanel();
                    echo $pane->endPane();
                ?>
                </td>
            </tr>
            <tr>
                <td><?php echo JText::_('Type'); ?>:</td>
                <td><?php echo $lists['field_type']; ?></td>
            </tr>
            <tr>
                <td valign="top"><?php echo JText::_('Categories'); ?>:</td>
                <td><?php echo $lists['categories']; ?></td>
            </tr>
        </table>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="option" value="<?php echo $option; ?>" />
        <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    }
    
    function showComments( &$rows, &$lists, $page ) {
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
    
        $db = &JFactory::getDBO();
        $user = &JFactory::getUser();
        //JToolBarHelper::title(   JText::_( 'Comment Manager' ), 'generic.png' );
        JToolBarHelper::publishList('publish_comment','Publish');
        JToolBarHelper::unpublishList('unpublish_comment','Unpublish');
        JToolBarHelper::addNewX('comment');
        JToolBarHelper::editListX('comment');
        JToolBarHelper::deleteList(JText::_('DELETE_COMMENTS'),'remove_comment');
        JToolBarHelper::cancel('cancel_comments');
        
        JHTML::_('behavior.tooltip');
        ?>
        <form action="index.php?option=com_customgallery" method="post" name="adminForm">

            <table>
                <tr>
                    <td width="100%">
                        <?php echo JText::_( 'Filter' ); ?>:
                        <input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" title="<?php echo JText::_( 'Filter by title or enter article ID' );?>"/>
                        <button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
                        <button onclick="document.getElementById('search').value='';this.form.getElementById('filter_sectionid').value='-1';this.form.getElementById('catid').value='0';this.form.getElementById('filter_authorid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
                    </td>
                    <td nowrap="nowrap">
                        <?php
                        //echo $lists['sectionid'];
                        //echo $lists['catid'];
                        //echo $lists['authorid'];
                        //echo $lists['state'];
                        ?>
                    </td>
                </tr>
            </table>

            <table class="adminlist" cellspacing="1">
            <thead>
                <tr>
                    <th width="5%" align="center">
                        <?php echo JText::_( 'Num' ); ?>
                    </th>
                    <th width="5%" align="center">
                        <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
                    </th>
                    <th width="15%" class="title">
                        <?php echo JText::_('Comment Title'); ?>
                    </th>
                    <th>
                        <?php echo JText::_('Comment Text'); ?>
                    </th>
                    <th>
                        <?php echo JText::_('Published'); ?>
                    </th>
                </tr>
            </thead>
            <tfoot>
            <tr>
                <td colspan="15">
                    <?php echo $page->getListFooter(); ?>
                </td>
            </tr>
            </tfoot>
            <tbody>
            <?php
            $k = 0;
            $nullDate = $db->getNullDate();
            for ($i=0, $n=count( $rows ); $i < $n; $i++)
            {
                $row = &$rows[$i];
                $img = ($row->published)? 'publish_g.png':'publish_r.png';

                $link     = 'index.php?option=com_customgallery&task=comment&cid[]='. $row->id;

                //$access     = JHTML::_('grid.access',   $row, $i, $row->state );
                $row->checked_out = 0;
                $checked     = JHTML::_('grid.checkedout',   $row, $i );
                ?>
                <tr class="<?php echo "row$k"; ?>">
                    <td align="center">
                        <?php echo $page->getRowOffset( $i ); ?>
                    </td>
                    <td align="center">
                        <?php echo $checked; ?>
                    </td>
                    <td>
                            <a href="<?php echo JRoute::_( $link ); ?>"><?php echo htmlspecialchars($row->title, ENT_QUOTES); ?></a>
                    </td>
                    <td>
                            <a href="<?php echo JRoute::_( $link ); ?>"><?php echo htmlspecialchars($row->details, ENT_QUOTES); ?></a>
                    </td>
                    <td align="center">
                            <span class="editlinktip hasTip" title="<?php echo JText::_( 'Publish Information' );?>::<?php echo $times; ?>"><a href="javascript:void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $row->published ? 'unpublish_comment' : 'publish_comment' ?>')">
                            <img src="images/<?php echo $img;?>" width="16" height="16" border="0" alt="<?php echo $alt; ?>" /></a></span>
                    </td>
                    
                </tr>
                <?php
                $k = 1 - $k;
            }
            ?>
            </tbody>
            </table>
            <?php //JHTML::_('content.legend'); ?>

        <input type="hidden" name="option" value="com_customgallery" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="entry_id" value="<?php echo $lists['entry_id']; ?>" />
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="redirect" value="<?php echo $redirect;?>" />
        <input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
        <input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    }
    
    function showComment( $row, &$lists ) {
    
    
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
    
        $title = (isset($row->name))?$row->name:JText::_('New comment');
        //JToolBarHelper::title( $title, 'generic.png' );
        JToolBarHelper::save('save_comment');
        JToolBarHelper::cancel('comments');
        $editor = &JFactory::getEditor();
        $option = JRequest::getCmd('option');
        ?>
        
        <form action="index.php" method="post" name="adminForm">

        <table cellspacing="0" cellpadding="2" border="0" width="100%">
            <tr>
                <td><?php echo JText::_('Published'); ?>:</td>
                <td><?php echo $lists['published']; ?></td>
            </tr>
            <tr>
                <td><?php echo JText::_('Name'); ?>:</td>
                <td><input type="text" name="name" value="<?php echo $row->username; ?>" /></td>
            </tr>
            <tr>
                <td><?php echo JText::_('IP Address'); ?>:</td>
                <td><?php echo $row->ip_address; ?></td>
            </tr>
            <tr>
                <td><?php echo JText::_('Title'); ?>:</td>
                <td><input type="text" name="title" value="<?php echo $row->title; ?>" maxlength="50" /></td>
            </tr>
            <tr>
                <td valign="top"><?php echo JText::_('Description'); ?>:</td>
                <td><?php echo $editor->display('details',$row->details,'100%','200','75','20'); ?></td>
            </tr>
        </table>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="entry_id" value="<?php echo $row->entry_id; ?>" />
        <input type="hidden" name="option" value="<?php echo $option; ?>" />
        <input type="hidden" name="id" value="<?php echo $row->id; ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
    
    }
    
    function showSettings( &$settings, &$lists, &$form ) {
    
    
    
    	//include our helper file to create the footer and buttons
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	//set our page header
	JToolBarHelper::title( JText::_( 'Ninja Custom Gallery' ), 'ninjahdr' );
		
//Include our stylesheet for our Ninja Component Styling
	$document =& JFactory::getDocument();
	$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin.css';
	$document->addStyleSheet($cssFile, 'text/css', null, array());

//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (ereg( "MSIE",  $ua)&& ereg( "6",  $ua)) {
		  
		$cssFile = JURI::base(true).'/components/com_customgallery/css/HTML_ninjahelper_admin_ie6.css';
		$document->addStyleSheet($cssFile, 'text/css', null, array());
		  
	}
    
    
    
    
        //add tooltips javascript
        $document = &JFactory::getDocument();
        $tips = "window.addEvent('domready', function(){ var JTooltips = new Tips($$('.hasTip'), { maxTitleChars: 50, fixed: false}); });";
        $document->addScriptDeclaration($tips);
        jimport('joomla.html.pane');
        //JToolBarHelper::title( 'Gallery Settings', 'generic.png' );
        JToolBarHelper::save('save_settings');
        JToolBarHelper::cancel('settings');
        $pane    =& JPane::getInstance('tabs');
        ?>
        <form action="index.php" method="post" name="adminForm">
        <table cellspacing="0" cellpadding="2" border="0" width="100%">
            <tr>
                <td>
                <?php
                $title = JText::_( 'General' );
                echo $pane->startPane("settings-pane");
                echo $pane->startPanel( $title, "general-page" );
                echo $form->render('params','general');

                $title = JText::_( 'Frontend' );
                echo $pane->endPanel();
                echo $pane->startPanel( $title, "frontend-page" );
                echo $form->render('params', 'frontend');
                
                $title = JText::_( 'Backend' );
                echo $pane->endPanel();
                echo $pane->startPanel( $title, "backend-page" );
                echo $form->render('params', 'backend');
                
                /*$title = JText::_( 'Meta Data' );
                echo $pane->endPanel();
                echo $pane->startPanel( $title, "metadata-page" );
                echo $form->render('params', 'metadata');*/
                
                echo $pane->endPanel();
                echo $pane->endPane();
                
                
                ?>
                </td>
            </tr>
        </table>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="option" value="com_customgallery" />
        <?php echo JHTML::_( 'form.token' ); ?>
        </form>
        <?php
        
        	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));
        
    }

}
?>
