<?php defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class CustomGalleriesController extends JController
{
    function dashboard() {
        
        // Manually Require dashboard controller
        $controller = 'dashboard';
        
        require_once (JPATH_COMPONENT.DS.'controllers'.DS.'dashboard.php');
                
        // Create the controller
        $classname  = 'CustomGalleriesControllerdashboard';
        $controller = new $classname( );

        // Perform the Request task
        $controller->execute( JRequest::getVar('task') );

        // Redirect if set by the controller
        $controller->redirect();
    }
    
    function galleries() {
        $mainframe  =& JFactory::getApplication();
        $database   =& JFactory::getDBO();
        $context    =  'com_customgallery.galleries';
        $limit      =  $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $limitstart =  $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');
        $limitstart =  $limit != 0 ? (floor($limitstart / $limit) * $limit) : 0;
        
        $query = "SELECT * FROM #__customgallery_galleries";
        $database->setQuery( $query );
        $rows = $database->loadObjectList();
        $total = count($rows);
        jimport('joomla.html.pagination');
        $pagination = new JPagination($total, $limitstart, $limit);
        $lists = array();
        $lists['search'] = JRequest::getVar('search','');
        
        CustomGalleryView::showGalleries( $rows, $lists, $pagination );
    }
    
    function gallery() {
        $database    = &JFactory::getDBO();
        $gallery_ids = JRequest::getVar('cid',null,'request','array');
        JArrayHelper::toInteger($gallery_ids, array(0));
        $gallery_id  = $gallery_ids[0];
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
        $row = &JTable::getInstance('customGallery','Table');
        $lists = array();
        
        if(isset($gallery_id)) {
            $row->load($gallery_id);
            // Load gallery entries.
            $query = "SELECT e.*,c.name AS category, COUNT(o.id) AS comment_count FROM #__customgallery_entries AS e"
            . " LEFT JOIN #__customgallery_categories AS c ON c.id = e.category_id"
            . " LEFT JOIN #__customgallery_comments AS o ON o.entry_id = e.id"
            . " WHERE e.gallery_id = '{$gallery_id}' GROUP BY e.id";
            $database->setQuery( $query );
            $lists['entries'] = $database->loadObjectList();
        } else {
            $lists['entries'] = null;
            $row->id = 0;
        }
        
        // Load categories
        $cat_options = array();
        $cat_options[] = JHTML::_('select.option','0',JText::_('None'),'value','text');
        $query = "SELECT id AS value, name AS text FROM #__customgallery_categories";
        $database->setQuery( $query );
        $cat_options = array_merge( $cat_options, $database->loadObjectList() );
        $lists['categories'] = JHTML::_('select.genericlist',  $cat_options, 'category_id', 'class="inputbox" size="1"', 'value', 'text', intval($row->category_id));
    
        CustomGalleryView::showGallery( $row, $lists );
    }
    
    function save_gallery() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe  =& JFactory::getApplication();

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
        $row = &JTable::getInstance('customGallery','Table');
        $gallery_id = JRequest::getInt('gallery_id',0);
        
        if($gallery_id) {
            $is_new = false;
            $_POST['id'] = $gallery_id;
        } else {
            $is_new = true;
        }
        
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->check()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if($is_new) $mainframe->redirect('index.php?option=com_customgallery&task=entry&cid[]=0&gallery_id='.$row->id, JText::_('ADD_NEW_ENTRY'));
        else $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$row->id, 'Gallery saved');
    
    }
    
    function remove_gallery() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe   =& JFactory::getApplication();
        $database    =& JFactory::getDBO();
        $gallery_ids =  JRequest::getVar('cid',null,'request','array');
        JArrayHelper::toInteger($gallery_ids, array(0));

        // Find all entries.
        $query = "SELECT id FROM #__customgallery_entries WHERE gallery_id IN (".implode(',',$gallery_ids).")";
        $database->setQuery( $query );
        $entry_ids = $database->loadResultArray();
        
        $dest_dir = JPATH_ROOT.DS.'media'.DS.'customgallery';
        if(count($gallery_ids)) {
            foreach ($gallery_ids as $g_id) {
                $dir_files = JFolder::files($dest_dir.DS.$g_id,'.',false,true);
                foreach((array)$dir_files as $dir_file) @unlink($dir_file);
            }
        }

        $eIds = implode(',',$entry_ids);

        $database->setQuery(
            'DELETE FROM #__customgallery_entries WHERE id IN ('.$eIds.')'
        );
        $database->query();
        
        $database->setQuery(
            'DELETE FROM #__customgallery_customdata WHERE entry_id IN ('.$eIds.')'
        );
        $database->query();
        
        $database->setQuery(
            'DELETE FROM #__customgallery_comments WHERE entry_id IN ('.$eIds.')'
        );
        $database->query();
        
        $database->setQuery(
            'DELETE FROM #__customgallery_ratings WHERE entry_id IN ('.$eIds.')'
        );
        $database->query();
        
        $database->setQuery(
            'DELETE FROM #__customgallery_galleries WHERE id IN ('.implode(',',$gallery_ids).')'
        );
        $database->query();
        
        $mainframe->redirect('index.php?option=com_customgallery&task=galleries', JText::_('Galleries removed'));
    }
    
    function make_thumb() {
        global $mainframe;

        $database   =& JFactory::getDBO();
        $gallery_id =  JRequest::getInt('gallery_id');
        $entry_id   =  JRequest::getInt('id');

        If( $entry_id && $gallery_id ) {
            $query = 'UPDATE #__customgallery_galleries SET entry_id = '.$entry_id.' WHERE id = '.$gallery_id;
            $database->setQuery( $query );
            $database->query();
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('Gallery thumb saved'));
    }
    
    function entry() {
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $database   =& JFactory::getDBO();
        $row        =& JTable::getInstance('customGalleryEntry','Table');
        $gallery    =& JTable::getInstance('customGallery','Table');
        $entry_ids  =  JRequest::getVar('cid',null,'request','array');
        $gallery_id =  JRequest::getInt('gallery_id');
        $entry_id   =  (int) $entry_ids[0];

        $gallery->load( $gallery_id );
        $row->load( $entry_id );

        if(!$row->id) {
            $row->gallery_id = $gallery_id;
            $row->category_id = $gallery->category_id;
        }
        
        // Load custom fields, values and options.
        $query = "SELECT * FROM #__customgallery_customfields";
        $database->setQuery( $query );
        $custom_fields = $database->loadObjectList();
        
        $query = "SELECT * FROM #__customgallery_customfieldoptions";
        $database->setQuery( $query );
        $custom_field_options = $database->loadObjectList();
        
        $query = "SELECT * FROM #__customgallery_customdata WHERE entry_id = $entry_id";
        $database->setQuery( $query );
        $custom_data = $database->loadObjectList('field_id');
        if(!isset($custom_data)) $custom_data = array();
        
        $lists = array();
        $lists['custom_fields'] = array();
        foreach( $custom_fields as $custom_field ) {
            if(!in_array($row->category_id, explode(',',$custom_field->categories))) continue;
            switch($custom_field->type) {
                // Text input.
                case 1:
                    $data_id = str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT);
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html'] = "<input type=\"text\" name=\"field_{$custom_field->id}_{$data_id}\" value=\"{$custom_data[$custom_field->id]->value}\" />";
                break;
                // Pull-down
                case 2:
                    $field_options = array();
                    $field_options[] = JHTML::_('select.option', '-1',JText::_('SELECT_OPTION'), 'value','text');
                    $option_array = array();
                    foreach( $custom_field_options as $cf ) {
                        if( $cf->field_id == $custom_field->id ) $option_array[] = $cf;
                    }
                    $field_options = array_merge( $field_options, $option_array );
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html'] = JHTML::_('select.genericlist', $field_options, 'field_'.$custom_field->id.'_'.str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT),'class="inputbox" size="1"','value','text',$custom_data[$custom_field->id]->value);
                break;
                
                case 3:
                    $field_options = array();
                    $field_options[] = JHTML::_('select.option', '-1',JText::_('SELECT_NONE'), 'value','text');
                    $option_array = array();
                    foreach( $custom_field_options as $cf ) {
                        if( $cf->field_id == $custom_field->id ) $option_array[] = $cf;
                    }
                    $field_options = array_merge( $field_options, $option_array );
                    $lists['custom_fields'][$custom_field->id]['label'] = $custom_field->name;
                    $lists['custom_fields'][$custom_field->id]['html'] = JHTML::_('select.genericlist', $field_options, 'field_'.$custom_field->id.'_'.str_pad($custom_data[$custom_field->id]->id,1,'0',STR_PAD_LEFT).'[]','class="inputbox" size="8" multiple="multiple"','value','text',explode(',',$custom_data[$custom_field->id]->value));
                break;
            }
        
        }
        
        $lists['media'] = '<input type="text" name="media_id" size="64" value="'.$row->media_id.'" />';
        $media_options = array();
        $media_options[] = JHTML::_('select.option','0',JText::_('Image File'),'value','text');
        $media_options[] = JHTML::_('select.option','1',JText::_('YouTube'),'value','text');
        $media_options[] = JHTML::_('select.option','2',JText::_('Google Video'),'value','text');
        $lists['media'] .= ' '.JText::_('Media Type').': ' . JHTML::_('select.genericlist',  $media_options, 'media_type', 'class="inputbox" size="1"', 'value', 'text', intval($row->media_type));
        
        // Load categories.
        /*$categories = array();
        $categories[] = JHTML::_('select.option','-1',JText::_('SELECT_CATEGORY'),'value','text');
        $query = "SELECT id AS value, name AS text FROM #__customgallery_categories";
        $database->setQuery( $query );
        $cat_options = $database->loadObjectList();
        $categories = array_merge($categories, $cat_options);
        $lists['category'] = JHTML::_('select.genericlist',  $categories, 'category_id', 'class="inputbox" size="1"', 'value', 'text', intval($row->category_id));*/
        
        // Load galleries.
        $galleries = array();
        $galleries[] = JHTML::_('select.option','-1',JText::_('SELECT_GALLERY'),'value','text');
        $query = "SELECT id AS value, name AS text FROM #__customgallery_galleries";
        $database->setQuery( $query );
        $gal_options = $database->loadObjectList();
        $galleries = array_merge($galleries, $gal_options);
        $lists['gallery'] = JHTML::_('select.genericlist',  $galleries, 'gallery_id', 'class="inputbox" size="1"', 'value', 'text', intval($row->gallery_id));
        
        CustomGalleryView::showEntry( $row, $lists );
    }
    
    function save_entry() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
        jimport('joomla.filesystem.file');

        $mainframe  =& JFactory::getApplication();
        $database   =& JFactory::getDBO();
        $row        =& JTable::getInstance('customGalleryEntry','Table');
        $gallery    =& JTable::getInstance('customGallery','Table');
        $entry_id   =  JRequest::getInt('id');
        $gallery_id =  JRequest::getInt('gallery_id');
        $file       =  JRequest::getVar( 'filename', '', 'files', 'array' );

        $row->load($entry_id);
        $gallery->load($gallery_id);

        $file['name'] = str_replace(' ','_',JFile::makeSafe($file['name']));
        
        if (!empty($file['name'])) {
            $dest_dir = JPATH_ROOT.DS.'media'.DS.'customgallery'.DS.$gallery_id;
            
            if(!is_dir($dest_dir)) {
                if(!mkdir($dest_dir,0755,true)) {
                    $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('FILE_NOT_SAVED_IMAGE_FOLDER'));
                }
            }
            $filepath = JPath::clean($dest_dir.DS.strtolower($file['name']));
            $thumb_filepath = JPath::clean($dest_dir.DS.strtolower('thumb_'.$file['name']));
            if (JFile::exists($filepath)) {
                $file['name'] = time().$file['name'];
                $filepath = JPath::clean($dest_dir.DS.strtolower($file['name']));
                $thumb_filepath = JPath::clean($dest_dir.DS.strtolower('thumb_'.$file['name']));
                /*JError::raiseNotice(100, JText::_('Error. File already exists'));
                $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('FILE_NOT_SAVED_IMAGE_EXISTS'));*/
            }
            if (JFile::exists($thumb_filepath)) {
                $file['name'] = time().$file['name'];
                $filepath = JPath::clean($dest_dir.DS.strtolower($file['name']));
                $thumb_filepath = JPath::clean($dest_dir.DS.strtolower('thumb_'.$file['name']));
                /*JError::raiseNotice(100, JText::_('Error. File already exists'));
                $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('FILE_NOT_SAVED_THUMB_EXISTS'));*/
            }
            if (!JFile::upload($file['tmp_name'], $filepath)) {
                JError::raiseWarning(100, JText::_('Error. Unable to upload file'));
                $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('FILE_NOT_SAVED_UPLOAD'));
            } else {
                // File successfuly saved.
                $row->filename = strtolower($file['name']);
                // Create thumbnail.
                include_once(JPATH_COMPONENT_ADMINISTRATOR . DS . 'helpers' . DS . 'resize.php');
                $thumb = new thumbnail($filepath);
                //$thumb->size_auto(100);
                $thumb->size_width(160);
                //$thumb->size_height(72);
                //if(file_exists($thumb_filepath)) unlink($thumb_filepath);
                $thumb->save($thumb_filepath);
            }
        }
        
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError( 500, $database->stderr() );
            return false;
        }
        // Check media_id for URL and use parse_url().
        
        // TODO: Check text field sizes.
        $row->category_id = $gallery->category_id;
        $row->create_date = isset($row->create_date)?$row->create_date:date("Y-m-d H:i:s");
        
        if (!$row->check()) {
            JError::raiseError( 500, $database->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $database->stderr() );
            return false;
        }
        $custom_data_query = array();
        foreach($_POST as $key => $value) {
            if(substr($key,0,5) == 'field') {
                list($t,$field_id,$data_id) = explode('_',$key,3);
                $field_id = intval($field_id);
                $data_id = intval($data_id);
                if(is_array($value)) $value = implode(',', $value);
                $custom_data_query[] = "($data_id,$row->id,$field_id,'$value')";
            }
        }
        $query = "REPLACE INTO #__customgallery_customdata (id,entry_id,field_id,value) VALUES ";
        $query .= implode(',', $custom_data_query);
        $database->setQuery( $query );
        $database->query();
        
        $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('Entry saved'));
    }
    
    function remove_entry() {

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $mainframe  =& JFactory::getApplication();
        $database   =& JFactory::getDBO();
        $row        =& JTable::getInstance('customGalleryEntry','Table');
        $entry_ids  = JRequest::getVar('cid',null,'request','array');
        $gallery_id = JRequest::getInt('gallery_id', 0);

        JArrayHelper::toInteger($entry_ids, array(0));

        // Remove files.
        $query = "SELECT filename FROM #__customgallery_entries WHERE id IN (".implode(',', $entry_ids).")";
        $database->setQuery( $query );
        $filenames = $database->loadResultArray();
        foreach( $filenames as $filename ) {
            $dest_dir = JPATH_ROOT.DS.'media'.DS.'customgallery'.DS.$gallery_id;
            $filepath = JPath::clean($dest_dir.DS.$filename);
            $thumb_filepath = JPath::clean($dest_dir.DS.'thumb_'.$filename);
            if(file_exists($filepath)) unlink($filepath);
            if(file_exists($thumb_filepath)) unlink($thumb_filepath);
        }
        $query = "DELETE FROM #__customgallery_entries WHERE id IN (".implode(',', $entry_ids).")";
        $database->setQuery( $query );
        $database->query();
        $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id, JText::_('Category saved'));
    }
    
    function change_entry() {
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $row       =& JTable::getInstance('customGalleryEntry','Table');
        $entry_ids =  JRequest::getVar('cid',null,'request','array');
        $entry_id  =  (int) $entry_ids[0];

        $row->load( $entry_id );
        $row->published = $row->published?0:1;

        if (!$row->check()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$row->gallery_id, JText::_('Publish status changed'));
    }
    
    function cancel_entry() {
        $mainframe  =& JFactory::getApplication();
        $gallery_id =  JRequest::getInt('gallery_id');
        if($gallery_id) $mainframe->redirect('index.php?option=com_customgallery&task=gallery&cid[]='.$gallery_id);
        else $mainframe->redirect('index.php?option=com_customgallery&task=galleries');
    }
    
    function categories() {
        jimport('joomla.html.pagination');

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $context    = 'customgallery.categories';
        $limit      = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $limitstart = $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');
        $limitstart = $limit != 0 ? (floor($limitstart / $limit) * $limit) : 0;

        $lists = array();
        $lists['search'] = JRequest::getVar('search','');
        $query = "SELECT * FROM #__customgallery_categories";
        $database->setQuery( $query );
        $categories = $database->loadObjectList();
        $total = count($categories);
        $pagination = new JPagination($total, $limitstart, $limit);
        
        CustomGalleryView::showCategories( $categories, $pagination, $lists );
    }
    
    function category() {
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
        $database    =& JFactory::getDBO();
        $row         =& JTable::getInstance('customGalleryCategory','Table');
        $cat_ids     =  JRequest::getVar('cid',null,'request','array');
        $category_id =  (int) $cat_ids[0];
        $row->load( $category_id );
        
        CustomGalleryView::showCategory( $row );
    }
    
    function save_category(){

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $row       =& JTable::getInstance('customGalleryCategory','Table');
        
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->check()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=categories', JText::_('Category saved'));
    }
    
    function remove_category() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $cat_ids   =  JRequest::getVar('cid',null,'request','array');

        JArrayHelper::toInteger($cat_ids, array(0));

        $query = "SELECT id FROM #__customgallery_entries WHERE category_id IN (".implode(',', $cat_ids).") LIMIT 1";
        $database->setQuery( $query );
        $rs = $database->loadResult();

        if(!$rs) {
            $query = "DELETE FROM #__customgallery_categories WHERE id IN (".implode(',',$cat_ids).")";
            $database->setQuery( $query );
            $database->query();
            $mainframe->redirect('index.php?option=com_customgallery&task=categories',JText::_('Categories deleted!'));
        } else {
            $mainframe->redirect('index.php?option=com_customgallery&task=categories',JText::_('CATEGORIES_ASSIGNED'));
        }
    }
    
    function fields() {
        jimport('joomla.html.pagination');

        $mainframe  =& JFactory::getApplication();
        $database   =& JFactory::getDBO();

        $context    = 'customgallery.fields';
        $limit      = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $limitstart = $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');
        $limitstart = ( $limit != 0 ? (floor($limitstart / $limit) * $limit) : 0 );
        
        $query = "SELECT * FROM #__customgallery_customfields ORDER BY ordering";
        $database->setQuery( $query );
        $fields = $database->loadObjectList();
        $field_options = array();
        $total = count($fields);
        if($total<1) $fields = array();
        
        foreach( (array)$fields as $field ) {
            $query = "SELECT * FROM #__customgallery_customfieldoptions WHERE field_id = {$field->id}";
            $database->setQuery( $query );
            $field_options[$field->id] = $database->loadObjectList();
        }
        
        $lists = array();
        $lists['field_types'][] = JText::_('NONE');
        $lists['field_types'][] = JText::_('TEXT');
        $lists['field_types'][] = JText::_('PULL_DOWN');
        $lists['field_types'][] = JText::_('LIST');
        
        // Load categories
        
        $pagination = new JPagination($total, $limitstart, $limit);
        
        CustomGalleryView::showFields( $fields, $field_options, $lists, $pagination );
    }
    
    function field() {
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $database  =& JFactory::getDBO();
        $row       =& JTable::getInstance('customGalleryField','Table');
        $field_ids =  JRequest::getVar('cid',null,'request','array');
        $field_id  =  (int) $field_ids[0];

        $row->load( $field_id );
        $lists = array();
    
        // Load custom options for this field.
        if( $row->type == 2 || $row->type == 3 ) {
            $query = "SELECT * FROM #__customgallery_customfieldoptions WHERE field_id = '{$row->id}' ORDER BY id";
            $database->setQuery( $query );
            $field_options = $database->loadObjectList();
            $opts = array();
            foreach( $field_options as $field_option ) {
                $opts[] = JHTML::_('select.option',$row->id.'|'.$field_option->value.'|'.$field_option->text,$field_option->value.'-'.$field_option->text,'value','text');
            }
            if($row->type == 2) {
                $lists['pdfield_options'] = JHTML::_('select.genericlist',  $opts, 'field_options[]', 'id="field_options" class="inputbox" size="8" multiple="multiple" onclick="editpdoption();"', 'value', 'text', 0 );
                $lists['listfield_options'] = JHTML::_('select.genericlist',  array(), 'listfield_options[]', 'id="listfield_options" class="inputbox" size="8" multiple="multiple"', 'value', 'text', 0 );
            } elseif ($row->type == 3) {
                $lists['listfield_options'] = JHTML::_('select.genericlist',  $opts, 'listfield_options[]', 'id="listfield_options" class="inputbox" size="8" multiple="multiple" onclick="editseloption();"','value', 'text', 0 );
                $lists['pdfield_options'] = JHTML::_('select.genericlist',  array(), 'field_options[]', 'id="field_options" class="inputbox" size="8" multiple="multiple"', 'value', 'text', 0 );
            }
        } else {
            $lists['pdfield_options'] = JHTML::_('select.genericlist',  array(), 'field_options[]', 'id="field_options" class="inputbox" size="8" multiple="multiple"', 'value', 'text', 0 );
            $lists['listfield_options'] = JHTML::_('select.genericlist',  array(), 'listfield_options[]', 'id="listfield_options" class="inputbox" size="8" multiple="multiple"', 'value', 'text', 0 );
        }
        
        $lists['txtfield_options'] = JText::_('NO_FIELD_TYPE_OPTIONS');
        
        $lists['field_types'][] = JText::_('NONE');
        $lists['field_types'][] = JText::_('TEXT');
        $lists['field_types'][] = JText::_('PULL_DOWN');
        $lists['field_types'][] = JText::_('LIST');
        
        $field_types = array();
        $field_types[] = JHTML::_('select.option','0',JText::_('Select type'),'value','text');
        $field_types[] = JHTML::_('select.option','1',JText::_('Text field'),'value','text');
        $field_types[] = JHTML::_('select.option','2',JText::_('Pulldown field'),'value','text');
        $field_types[] = JHTML::_('select.option','3',JText::_('Listbox field'),'value','text');
        $lists['field_type'] = JHTML::_('select.genericlist',  $field_types, 'type', 'class="inputbox" size="1"', 'value', 'text', intval($row->type));
        
        // Load categories.
        $field_cats = explode(',',$row->categories);
        $query = "SELECT id AS value, name AS text FROM #__customgallery_categories";
        $database->setQuery( $query );
        $cat_options = $database->loadObjectList();
        foreach( $cat_options as $cat_opt ) {
            $cat_list[] = JHTML::_('select.option',$cat_opt->value,$cat_opt->text,'value','text');
        }
        $lists['categories'] = JHTML::_('select.genericlist',  $cat_list, 'category_list[]', 'class="inputbox" size="6" multiple="multiple"', 'value', 'text', $row->categories);
        
        CustomGalleryView::showField( $row, $custom_fields, $lists );
    }
    
    function save_field() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $row       =& JTable::getInstance('customGalleryField','Table');

        $query = "SELECT MAX(ordering) FROM #__customgallery_customfields";
        $database->setQuery( $query );
        $new_ordering = $database->loadResult();
        $new_ordering = isset($new_ordering)?intval($new_ordering)+1:0;
        
        $pd_options   = JRequest::getVar('field_options',array(),'request','array');
        $list_options = JRequest::getVar('listfield_options',array(),'request','array');
        $field_type   = JRequest::getInt('type');
        $cat_options  = JRequest::getVar('category_list',array(),'request','array');

        JArrayHelper::toInteger($cat_options, array(0));
                
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        // If this is a new field, set its ordering to last.
        if(!isset($row->id) || empty($row->id)) $row->ordering = $new_ordering;
        // Set selected categories.
        if(count($cat_options)) $row->categories = implode(',',$cat_options);
        
        if (!$row->check()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        if (!$row->store()) {
            JError::raiseError( 500, $db->stderr() );
            return false;
        }
        
        // Remove existing field options, if any.
        $query = "DELETE FROM #__customgallery_customfieldoptions WHERE field_id = '{$row->id}'";
        $database->setQuery( $query );
        $database->query();
        $query_array = array();
        
        foreach($pd_options as $pd_option) {
            $opt_data = explode('|', $pd_option);
            $field_id = $row->id;
            $field_value = $opt_data[1];
            $field_text = $opt_data[2];
            $query_array[] = "(0, $field_id, '$field_text', '$field_value')";
        }
        
        foreach($list_options as $list_option) {
            $opt_data = explode('|', $list_option);
            $field_id = $row->id;
            $field_value = $opt_data[1];
            $field_text = $opt_data[2];
            $query_array[] = "(0, $field_id, '$field_text', '$field_value')";
        }
        
        if(count($query_array)) {
            $query = "INSERT INTO #__customgallery_customfieldoptions (id,field_id,text,value) VALUES ";
            $query .= implode(',', $query_array);
            $database->setQuery( $query );
            $database->query();
        }
        
        $mainframe->redirect('index.php?option=com_customgallery&task=fields',JText::_('Field saved'));
    }
    
    function remove_field() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database = &JFactory::getDBO();

        $field_ids = JRequest::getVar('cid',null,'request','array');

        $query = "DELETE FROM #__customgallery_customfields WHERE id IN (".implode(',', $field_ids).")";
        $database->setQuery( $query );
        $database->query();
        
        $query = "DELETE FROM #__customgallery_customfieldoptions WHERE field_id IN (".implode(',', $field_ids).")";
        $database->setQuery( $query );
        $database->query();
        
        $query = "DELETE FROM #__customgallery_customdata WHERE field_id IN (".implode(',', $field_ids).")";
        $database->setQuery( $query );
        $database->query();
        
        $mainframe->redirect('index.php?option=com_customgallery&task=fields',JText::_('FIELD_REMOVED'));
    }
    
    function fieldsaveorder() {
        JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');

        $database =& JFactory::getDBO();
        $row      =& JTable::getInstance('customGalleryField','Table');
        $fields   =  JRequest::getVar('cid',null,'request','array');
        $orders   =  JRequest::getVar('order',null,'request','array');

        JArrayHelper::toInteger($fields, array(0));
        JArrayHelper::toInteger($orders, array(0));

        $total = count($fields);
        for ($i = 0; $i < $total; $i ++) {
            $row->load( (int) $fields[$i] );
            if ($row->ordering != $orders[$i]) {
                $row->ordering = $orders[$i];
                if (!$row->store()) {
                    JError::raiseError( 500, $db->getErrorMsg() );
                    return false;
                }
            }
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=fields',JText::_('Field ordering saved'));
    }
    
    function fieldorderup() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();

        $cid    = JRequest::getVar( 'cid', array(), 'post', 'array' );

        if (isset( $cid[0] )) {
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
            $row = &JTable::getInstance('customGalleryField','Table');
            
            $row->load( (int) $cid[0] );
            $row->move(-1);
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=fields',JText::_('Field ordering saved'));
    }
    
    function fieldorderdown() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();

        $cid    = JRequest::getVar( 'cid', array(), 'post', 'array' );

        if (isset( $cid[0] )) {
            JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_customgallery'.DS.'tables');
            $row = &JTable::getInstance('customGalleryField','Table');
            
            $row->load( (int) $cid[0] );
            $row->move(1);
        }
        $mainframe->redirect('index.php?option=com_customgallery&task=fields',JText::_('Field ordering saved'));
    }
    
    function comments() {
        jimport('joomla.html.pagination');

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $context    = 'com_customgallery.comments';
        $limit      = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        $limitstart = $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');
        $limitstart = ( $limit != 0 ? (floor($limitstart / $limit) * $limit) : 0 );

        $lists = array();
        $lists['search'] = JRequest::getVar('search','');
        $lists['entry_id'] = JRequest::getInt('entry_id',0);
        
        $query = "SELECT * FROM #__customgallery_comments";
        $query .= $lists['entry_id']? " WHERE entry_id = '{$lists['entry_id']}'":"";
        $database->setQuery( $query );
        $rows = $database->loadObjectList();
        $total = count($rows);
        $pagination = new JPagination($total, $limitstart, $limit);
        
        CustomGalleryView::showComments( $rows, $lists, $pagination );
    }
    
    function comment() {
        $database    = &JFactory::getDBO();
        $comment_ids =  JRequest::getVar('cid',null,'request','array');
        $entry_id    =  JRequest::getInt('entry_id');

        $query = "SELECT * FROM #__customgallery_comments WHERE id = '".(int) $comment_ids[0]."' LIMIT 1";
        $database->setQuery( $query );
        $comment = $database->loadObject();
        
        if(!isset($comment)) {
            $comment = new stdClass();
            $comment->id = 0;
            $comment->entry_id = $entry_id;
            $comment->username = '';
            $comment->title = '';
            $comment->details = '';
            $comment->ip_address = $_SERVER['REMOTE_ADDR'];
        }
        
        
        $lists = array();
        
        $lists['published'] = JHTML::_('select.booleanlist', 'published', '', $comment->published);
        
        CustomGalleryView::showComment( $comment, $lists );
    }
    
    function save_comment() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $ip_address      = $_SERVER['REMOTE_ADDR'];
        $comment_id      = JRequest::getInt('id');
        $comment_name    = JRequest::getVar('name','');
        $comment_title   = JRequest::getVar('title','');
        $comment_details = JRequest::getVar('details','');
        $comment_entry   = JRequest::getInt('entry_id');
        $comment_pub     = JRequest::getInt('published');
        
        $query = $comment_id?"REPLACE INTO ":"INSERT INTO ";
        $query .= "#__customgallery_comments (id,entry_id,username,title,details,ip_address,published) VALUES ($comment_id,$comment_entry,'$comment_name','$comment_title','$comment_details','$ip_address',$comment_pub)";
        //$query .= $comment_id?" WHERE id = '{$comment_id}'":'';
        $database->setQuery( $query );
        $database->query();
        
        $mainframe->redirect('index.php?option=com_customgallery&task=comments&entry_id='.$comment_entry,JText::_('Comment saved'));
    }
    
    function remove_comment() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $comment_ids = JRequest::getVar('cid',null,'request','array');
        $entry_id    = JRequest::getInt('entry_id');

        JArrayHelper::toInteger($comment_ids, array(0));

        $query = "DELETE FROM #__customgallery_comments WHERE id IN (".implode(',',$comment_ids).")";
        $database->setQuery( $query );
        $database->query();
        $mainframe->redirect('index.php?option=com_customgallery&task=comments&entry_id='.$entry_id,JText::_('Comments deleted'));
    }
    
    function cancel_comments() {
        $mainframe =& JFactory::getApplication();
        $entry_id  =  JRequest::getInt('entry_id');
        $mainframe->redirect('index.php?option=com_customgallery&task=entry&cid[]='.$entry_id);
    }
    
    function publish_comment() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $comment_ids = JRequest::getVar('cid',null,'request','array');
        JArrayHelper::toInteger($comment_ids, array(0));

        $query = "UPDATE #__customgallery_comments SET published = '1' WHERE id IN (".implode(',',$comment_ids).")";
        $database->setQuery( $query );
        $database->query();
        $mainframe->redirect('index.php?option=com_customgallery&task=comments&entry_id='.$entry_id,JText::_('Comments published'));
    }
    
    function unpublish_comment() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database = &JFactory::getDBO();

        $comment_ids = JRequest::getVar('cid',null,'request','array');
        JArrayHelper::toInteger($comment_ids, array(0));

        $query = "UPDATE #__customgallery_comments SET published = '0' WHERE id IN (".implode(',',$comment_ids).")";
        $database->setQuery( $query );
        $database->query();
        $mainframe->redirect('index.php?option=com_customgallery&task=comments&entry_id='.$entry_id,JText::_('Comments unpublished'));
    }
    
    function settings() {

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();

        $query = "SELECT param_name,param_value FROM #__customgallery_settings";
        $database->setQuery( $query );
        $db_settings = $database->loadAssocList();
        $settings = array();
        foreach((array)$db_settings as $setting) {
            $settings[] = $setting['param_name'] . '=' . $setting['param_value'];
        }
        $settings = implode("\n", $settings);
        
        
        $lists = array();
        $form = new JParameter($settings, JPATH_COMPONENT.DS.'config.xml');
        
        CustomGalleryView::showSettings( $settings, $lists, $form );
    }
    
    function save_settings() {

        // Check for request forgeries
        JRequest::checkToken() or jexit( 'Invalid Token' );

        $mainframe =& JFactory::getApplication();
        $database  =& JFactory::getDBO();
        $params    =  JRequest::getVar('params',null,'request','array');

        // Clean out the settings table.
        $query = "TRUNCATE TABLE #__customgallery_settings";
        $database->setQuery( $query );
        $database->query();
        if(!in_array('24',$params['fe_upload_allow'])) $params['fe_upload_allow'][] = '24';
        if(!in_array('25',$params['fe_upload_allow'])) $params['fe_upload_allow'][] = '25';
        $query_list = array();
        foreach( $params as $key => $value ) {
            if(is_array($value)) $value = implode(',',$value);
            $query_list[] = '( 0, '.$database->quote($database->getEscaped($key)).
                               ', '.$database->quote($database->getEscaped($value)).')';
        }
        $query = "INSERT INTO #__customgallery_settings (id,param_name,param_value) VALUES ";
        $query .= implode(',',$query_list);
        $database->setQuery( $query );
        $database->query();
        
        $mainframe->redirect('index.php?option=com_customgallery&task=settings',JText::_('Settings saved'));
    }
    
    /**
     * Method to display the view
     *
     * @access    public
     */
    function display()
    {
        $mainframe =& JFactory::getApplication();
        $mainframe->redirect('index.php?option=com_customgallery&task=dashboard',JText::_('PAGE_NOT_FOUND'));
        parent::display();
    }

}
?>
