CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cname` text NOT NULL,
  `rep_id` bigint(20) NOT NULL,
  UNIQUE KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_config` (
  `id` int(11) NOT NULL,
  `hdreply` text NOT NULL,
  `hdurl` text NOT NULL,
  `notifyuser` int(11) NOT NULL,
  `enablekb` int(11) NOT NULL,
  `defaultpriority` bigint(20) NOT NULL,
  `defaultstatus` bigint(20) NOT NULL,
  `closestatus` bigint(20) NOT NULL,
  `allowanonymous` int(11) NOT NULL,
  `defaultlang` int(11) NOT NULL,
  `pagerpriority` int(11) NOT NULL,
  `userselect` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_departments` (
  `department_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `dname` text NOT NULL,
  UNIQUE KEY `department_id` (`department_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_emailmsg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` text NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_langstrings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_id` bigint(20) NOT NULL,
  `variable` text NOT NULL,
  `langtext` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=538 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_language` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `langname` text NOT NULL,
  `localized` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_notes` (
  `note_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` bigint(20) NOT NULL,
  `note` longtext NOT NULL,
  `adddate` datetime NOT NULL,
  `uid` text NOT NULL,
  `priv` int(11) NOT NULL,
  PRIMARY KEY (`note_id`),
  FULLTEXT KEY `note` (`note`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) NOT NULL,
  `name` text NOT NULL,
  `type` text NOT NULL,
  `size` int(11) NOT NULL,
  `content` MEDIUMBLOB NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_priority` (
  `priority_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `pname` text NOT NULL,
  UNIQUE KEY `priority_id` (`priority_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_problems` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uid` text NOT NULL,
  `uemail` text NOT NULL,
  `ulocation` text NOT NULL,
  `uphone` text NOT NULL,
  `rep` bigint(20) NOT NULL,
  `status` bigint(20) NOT NULL,
  `time_spent` bigint(20) NOT NULL,
  `category` bigint(20) NOT NULL,
  `close_date` datetime NOT NULL,
  `department` bigint(20) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `solution` text NOT NULL,
  `start_date` datetime NOT NULL,
  `priority` bigint(20) NOT NULL,
  `entered_by` bigint(20) NOT NULL,
  `kb` bigint(20) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `rep` (`rep`,`status`,`category`,`department`,`priority`),
  FULLTEXT KEY `solution` (`solution`),
  FULLTEXT KEY `description` (`description`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status_id` bigint(20) NOT NULL,
  `sname` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=25 ;

CREATE TABLE IF NOT EXISTS `#__huruhelpdesk_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `joomla_id` int(11) NOT NULL,
  `isuser` int(11) NOT NULL,
  `isrep` int(11) NOT NULL,
  `isadmin` int(11) NOT NULL,
  `phone` text NOT NULL,
  `pageraddress` text NOT NULL,
  `phonemobile` text NOT NULL,
  `phonehome` text NOT NULL,
  `location1` text NOT NULL,
  `location2` text NOT NULL,
  `department` bigint(20) NOT NULL,
  `language` bigint(20) NOT NULL,
  `viewreports` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


--
-- Dumping data for table `#__huruhelpdesk_config`
--

INSERT IGNORE INTO `#__huruhelpdesk_config` (`id`, `hdreply`, `hdurl`, `notifyuser`, `enablekb`, `defaultpriority`, `defaultstatus`, `closestatus`, `allowanonymous`, `defaultlang`, `pagerpriority`, `userselect`) VALUES
(1, 'helpdesk@domain.com', 'http://server.domain.com/', 1, 1, 3, 15, 24, 1, 1, 10, 1);

--
-- Dumping data for table `#__huruhelpdesk_emailmsg`
--

INSERT IGNORE INTO `#__huruhelpdesk_emailmsg` (`id`, `type`, `subject`, `body`) VALUES
(1, 'repclose', 'HELPDESK: Problem [problemid] Closed', 'The following problem has been closed.  You can view the problem at [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nUser: [uid]\r\nDate: [startdate]\r\nTitle: [title]\r\nPriority: [priority]\r\nCategory: [category]\r\n\r\nSOLUTION\r\n--------\r\n[solution]'),
(2, 'repnew', 'HELPDESK: Problem [problemid] Assigned', 'The following problem has been assigned to you.  You can update the problem at [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nDate: [startdate]\r\nTitle: [title]\r\nPriority: [priority]\r\nCategory: [category]\r\n\r\nUSER INFORMATION\r\n----------------\r\nUsername: [uid]\r\nEmail: [uemail]\r\nPhone: [phone]\r\nLocation: [location]\r\nDepartment: [department]\r\n\r\nDESCRIPTION\r\n-----------\r\n[description]'),
(3, 'reppager', 'HELPDESK: Problem [problemid] Assigned/Updated', 'Title:[title]\r\nUser:[uid]\r\nPriority:[priority]'),
(4, 'repupdate', 'HELPDESK: Problem [problemid] Updated', 'The following problem has been updated.  You can view the problem at [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nUser: [uid]\r\nDate: [startdate]\r\nTitle: [title]\r\n\r\nDESCRIPTION\r\n-----------\r\n[description]\r\n\r\nNOTES\r\n-----------\r\n[notes]'),
(5, 'userclose', 'HELPDESK: Problem [problemid] Closed', 'Your help desk problem has been closed.  You can view the solution below or at: [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nUser: [uid]\r\nDate: [startdate]\r\nTitle: [title]\r\n\r\nSOLUTION\r\n--------\r\n[solution]'),
(6, 'usernew', 'HELPDESK: Problem [problemid] Created', 'Thank you for submitting your problem to the help desk.  You can view or update the problem at: [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nUser: [uid]\r\nDate: [startdate]\r\nTitle: [title]\r\n\r\nDESCRIPTION\r\n-----------\r\n[description]'),
(7, 'userupdate', 'HELPDESK: Problem [problemid] Updated', 'Your help desk problem has been updated.  You can view the problem at: [url]\r\n\r\nPROBLEM DETAILS\r\n---------------\r\nID: [problemid]\r\nUser: [uid]\r\nDate: [startdate]\r\nTitle: [title]\r\n\r\nDESCRIPTION\r\n-----------\r\n[description]\r\n\r\nNOTES\r\n-----------\r\n[notes]');

--
-- Dumping data for table `#__huruhelpdesk_langstrings`
--

INSERT IGNORE INTO `#__huruhelpdesk_langstrings` (`id`, `lang_id`, `variable`, `langtext`) VALUES
(54, 1, 'Classification', 'Classification'),
(59, 1, 'Close', 'Close'),
(60, 1, 'CloseDate', 'Close Date'),
(72, 1, 'ContactInformation', 'Contact Information'),
(79, 1, 'DateSubmitted', 'Entered'),
(91, 1, 'Department', 'Department'),
(95, 1, 'Description', 'Description'),
(104, 1, 'EditInformation', 'Edit your contact information'),
(108, 1, 'EMail', 'E-Mail'),
(109, 1, 'EmailAddress', 'E-Mail Address'),
(120, 1, 'EndDate', 'End Date'),
(121, 1, 'EnterAdditionalNotes', 'Enter Additional Notes'),
(125, 1, 'EnteredBy', 'Entered By'),
(126, 1, 'EnterinKnowledgeBase', 'Enter in Knowledge Base'),
(135, 1, 'From', 'From'),
(142, 1, 'HideFromEndUser', 'Hide new note from end user'),
(144, 1, 'ID', 'ID'),
(146, 1, 'In', 'In'),
(148, 1, 'InOutBoard', 'View In/Out Board'),
(174, 1, 'Location', 'Location'),
(191, 1, 'minutes', 'minutes'),
(199, 1, 'NewProblem', 'New Problem'),
(207, 1, 'Noresultsfound', 'No matching problems found'),
(210, 1, 'Notes', 'Notes'),
(218, 1, 'OpenProblems', 'Open problems'),
(219, 1, 'OpenProblemsfor', 'Open problems for'),
(222, 1, 'Or', 'Or'),
(225, 1, 'Out', 'Out'),
(237, 1, 'Phone', 'Phone'),
(248, 1, 'Priority', 'Priority'),
(257, 1, 'ProblemID', 'View Problem #'),
(259, 1, 'ProblemInformation', 'Problem Information'),
(263, 1, 'Problems', 'Problems'),
(277, 1, 'ReopenProblem', 'Reopen'),
(278, 1, 'Rep', 'Rep'),
(282, 1, 'Reports', 'Reports'),
(286, 1, 'Required', 'Required'),
(292, 1, 'Save', 'Save'),
(294, 1, 'Search', 'Search'),
(296, 1, 'SearchFields', 'Search Fields'),
(297, 1, 'SearchProblems', 'Search problems'),
(298, 1, 'SearchResults', 'Search Results'),
(299, 1, 'SearchtheKnowledgeBase', 'Search the knowledgebase'),
(302, 1, 'SelectCategory', 'Select Category'),
(303, 1, 'SelectDepartment', 'Select Department'),
(304, 1, 'SelectUser', 'Select User'),
(31, 1, 'AssignedTo', 'Assigned To'),
(313, 1, 'Solution', 'Solution'),
(317, 1, 'StartDate', 'Start Date'),
(319, 1, 'Status', 'Status'),
(329, 1, 'Subject', 'Subject'),
(330, 1, 'Submit', 'Submit'),
(332, 1, 'SubmitNewProblem', 'Submit new problem'),
(335, 1, 'SupportRep', 'Support Rep'),
(352, 1, 'Time', 'Time'),
(353, 1, 'TimeSpent', 'Time Spent'),
(354, 1, 'Title', 'Title'),
(356, 1, 'Total', 'Total'),
(373, 1, 'User', 'User'),
(376, 1, 'UserName', 'User Name'),
(385, 1, 'View', 'View'),
(386, 1, 'ViewProblemList', 'View all open problems'),
(387, 1, 'Viewproblemsfor', 'View open problems assigned to'),
(394, 1, 'ViewAssignedProblems', 'View assigned problems'),
(395, 1, 'ViewSubmittedProblems', 'View submitted problems'),
(397, 1, 'ViewProblemsFromLast', 'View all problems from last'),
(398, 1, 'days', 'days'),
(399, 1, 'Activity', 'Activity'),
(400, 1, 'Home', 'Home'),
(401, 1, 'Refresh', 'Refresh'),
(402, 1, 'NoLimit', '(No limit)'),
(403, 1, 'Back', 'Back'),
(404, 1, 'ProblemNumber', 'Problem #'),
(405, 1, 'ProblemSaved', 'Problem saved'),
(406, 1, 'ErrorSavingProblem', 'Error saving record: Invalid or missing required fields.'),
(409, 1, 'DefaultRep', 'Default Rep'),
(410, 1, 'NotFound', 'No matching problem found'),
(411, 1, 'EnterVerification', 'Verification'),
(412, 1, 'Name', 'Full Name'),
(413, 1, 'Admin', 'Admin'),
(414, 1, 'ShowReps', 'Show Reps'),
(415, 1, 'ShowAll', 'Show All'),
(416, 1, 'RepsAdmins', 'Reps & Admins Only'),
(417, 1, 'AllUsers', 'All Huru Users'),
(418, 1, 'SearchCriteria', 'Search Criteria'),
(419, 1, 'Reset', 'Reset'),
(421, 1, 'To', 'To'),
(422, 1, 'SearchText', 'Search Text'),
(423, 1, 'Browse', 'Browse'),
(424, 1, 'Cancel', 'Cancel'),
(425, 1, 'NewSearch', 'New Search'),
(426, 1, 'Results', 'Results'),
(427, 1, 'ProblemsFound', 'problem(s) found'),
(428, 1, 'EnterSearch', 'Enter your search criteria & click the Search button'),
(429, 1, 'EnterReport', 'Enter your report criteria & click the View button'),
(430, 1, 'AvailableReports', 'Available Reports'),
(431, 1, 'DateRange', 'Date Range'),
(432, 1, 'AverageTime', 'Average Time'),
(433, 1, 'PercentProblemTotal', '% of Problems'),
(434, 1, 'PercentTimeTotal', '% of Time'),
(435, 1, 'min', 'min'),
(436, 1, 'Unknown', 'Unknown'),
(437, 1, 'ActivitySummary', 'MIS Activity Summary'),
(438, 1, 'Modified', 'Modified'),
(439, 1, 'through', 'through'),
(440, 1, 'MailProblemID', 'Problem Id Number'),
(441, 1, 'MailTitle', 'Problem Title/Subject'),
(442, 1, 'MailDescription', 'Problem Description'),
(443, 1, 'MailUID', 'Username of person who reported problem'),
(444, 1, 'MailUEmail', 'Email address of person who reported problem'),
(445, 1, 'MailPhone', 'Phone number of person who reported problem'),
(446, 1, 'MailLocation', 'Location of person who reported problem'),
(447, 1, 'MailDepartment', 'Department of person who reported problem'),
(448, 1, 'MailPriority', 'Priority of problem'),
(449, 1, 'MailCategory', 'Category of problem'),
(45, 1, 'Category', 'Category'),
(450, 1, 'MailStartDate', 'Date problem was reported/opened'),
(451, 1, 'MailURL', 'URL to problem'),
(452, 1, 'MailSolution', 'Problem solution'),
(453, 1, 'MailNotes', 'Notes about problem'),
(454, 1, 'ProblemsSubmittedBy', 'Problems submitted by'),
(456, 1, 'for', 'for'),
(457, 1, 'ForPrevious', 'for previous'),
(458, 1, 'All', 'All'),
(459, 1, 'OpenProblemsLC', 'open problems'),
(460, 1, 'Print', 'Print'),
(461, 1, 'UserProfile', 'User Profile'),
(462, 1, 'JoomlaUserInfo', 'Joomla! user information'),
(463, 1, 'HuruUserInfo', 'Helpdesk User Profile'),
(464, 1, 'HomePhone', 'Home Phone'),
(465, 1, 'MobilePhone', 'Mobile Phone'),
(466, 1, 'PagerAddress', 'Pager Address'),
(467, 1, 'Location1', 'Location 1'),
(468, 1, 'Location2', 'Location 2'),
(469, 1, 'Language', 'Language'),
(470, 1, 'ManageCategories', 'Manage Categories'),
(471, 1, 'EditCategory', 'Edit Category'),
(472, 1, 'CategoryName', 'Category Name'),
(473, 1, 'Default', 'Default'),
(474, 1, 'GeneralConfiguration', 'General Configuration'),
(475, 1, 'ReplyAddress', 'Reply Address'),
(476, 1, 'BaseURL', 'Helpdesk Base URL'),
(477, 1, 'NotifyUserOnCaseUpdate', 'Notify User on Case Update'),
(478, 1, 'AllowAnonymousCases', 'Allow Anonymous Cases'),
(479, 1, 'AllowUserSelectOnNewCases', 'Allow User Select on New Cases'),
(480, 1, 'KnowledgeBaseViewAuthority', 'Knowledgebase View Authority'),
(481, 1, 'Disable', 'Disable'),
(482, 1, 'RepsOnly', 'Reps Only'),
(483, 1, 'UsersAndReps', 'Users & Reps'),
(484, 1, 'Anyone', 'Anyone'),
(485, 1, 'DefaultPriority', 'Default Priority'),
(486, 1, 'PagerPriority', 'Pager Priority'),
(487, 1, 'DefaultStatus', 'Default Status'),
(488, 1, 'ClosedStatus', 'Closed Status'),
(489, 1, 'DefaultLanguage', 'Default Language'),
(490, 1, 'EmailMessages', 'Email Messages'),
(491, 1, 'Users', 'Users'),
(492, 1, 'Departments', 'Departments'),
(493, 1, 'Categories', 'Categories'),
(494, 1, 'Priorities', 'Priorities'),
(495, 1, 'Statuses', 'Statuses'),
(496, 1, 'Languages', 'Languages'),
(497, 1, 'About', 'About'),
(498, 1, 'Administration', 'Administration'),
(499, 1, 'ManageDepartments', 'Manage Departments'),
(500, 1, 'DepartmentName', 'Department Name'),
(501, 1, 'EditDepartment', 'Edit Department'),
(502, 1, 'ManageEmailMessages', 'Manage Email Messages'),
(503, 1, 'Type', 'Type'),
(504, 1, 'Body', 'Body'),
(505, 1, 'Edit...', 'Edit...'),
(506, 1, 'EditEmailMessage', 'Edit Email Message'),
(507, 1, 'AvailableSubstitutions', 'Available Substitutions'),
(508, 1, 'ManageLanguages', 'Manage Languages'),
(509, 1, 'LanguageName', 'Language Name'),
(510, 1, 'Localized', 'Localized'),
(511, 1, 'EditLanguage', 'Edit Language'),
(512, 1, 'LanguageStrings', 'Language Strings'),
(513, 1, 'ManagePriorities', 'Manage Priorities'),
(514, 1, 'PriorityName', 'Priority Name'),
(515, 1, 'EditPriority', 'Edit Priority'),
(516, 1, 'ManageStatuses', 'Manage Statuses'),
(517, 1, 'Rank', 'Rank'),
(518, 1, 'StatusName', 'Status Name'),
(519, 1, 'EditStatus', 'Edit Status'),
(520, 1, 'ManageLanguageStrings', 'Manage Language Strings'),
(521, 1, 'LanguageID', 'Language ID'),
(522, 1, 'Variable', 'Variable'),
(523, 1, 'Text', 'Text'),
(524, 1, 'EditString', 'Edit String'),
(525, 1, 'ManageUsers', 'Manage Users'),
(526, 1, 'HuruID', 'Huru ID'),
(527, 1, 'JoomlaID', 'Joomla! ID'),
(528, 1, 'SyncJoomlaUsers', 'Sync Joomla! Users'),
(529, 1, 'SyncJoomlaUsersConfirm', 'This will synchronize the Huru users table with the Joomla! users table - importing accounts into Huru as necessary.  No Joomla! user accounts will be altered.'),
(530, 1, 'EditUser', 'Edit User'),
(531, 1, 'IsUser', 'User'),
(532, 1, 'IsRep', 'Rep'),
(533, 1, 'IsAdmin', 'Administrator'),
(534, 1, 'ViewReports', 'View Reports'),
(535, 1, 'UserSuperAdminNote', '(Note: This setting is ignored for Joomla! Super Administrators - who are always Huru Helpdesk Admins)'),
(536, 1, 'DefaultAssignment', 'Category Default'),
(537, 1, 'PageTitle','Huru Helpdesk'),
(538, 1, 'SelectOverride','Overrides contact info above'),
(539, 1, 'CannotDeleteClosedStatus','Cannot delete status set as Closed Status in General Confguration'),
(540, 1, 'Go','Go'),
(541, 1, 'ProblemDeleted','Problem deleted'),
(542, 1, 'ProblemNotDeleted','Error deleting problem'),
(543, 1, 'DeleteProblem','Delete Problem #'),
(544, 1, 'Delete','Delete'),
(545, 1, 'ProblemCreated','Problem created'),
(546, 1, 'AttachFileToNote','Attach file to note'),
(547, 1, 'Attachment','Attachment'),
(548, 1, 'AttachmentFileNoteFound','Attachment file not found'),
(549, 1, 'DefaultFileAttachmentNote','File attached'),
(550, 1, 'ErrorSavingAttachment','Error saving attachment'),
(551, 1, 'NotImplemented','Not implemented'),
(552, 1, 'FileTypeNotAllowed', 'File type not allowed'),
(553, 1, 'FileTooLarge', 'File too large'),
(554, 1, 'UnknownError', 'Unknown error'),
(555, 1, 'NotificationSenderName', 'Notification Sender Name'),
(556, 1, 'AllowFileAttachments', 'Allow File Attachments to Cases'),
(557, 1, 'AllowedAttachmentExtensions', 'Allowed Attachment Extensions'),
(558, 1, 'ExtensionExample', 'Comma separated list of allowed file extensions (with leading periods) [e.g: .jpg,.png,.txt]'),
(559, 1, 'MaximumAttachmentSize', 'Maximum Attachment Size'),
(560, 1, 'Bytes', 'bytes'),
(561, 1, 'AttachmentSizeWarning', 'Huru maximum is 16MB.  PHP may be configured for less.  Check your php.ini file'),
(562, 1, 'AttachmentDownloadPermissions', 'Allow attachment download'),
(563, 1, 'AttachmentDeleted', 'Attachment deleted'),
(564, 1, 'AttachmentNotDeleted', 'Error deleting attachment'),
(565, 1, 'MaximumAttachmentAge', 'Auto-purge old attachments after'),
(566, 1, 'SetToZero', 'Set to 0 to disable auto-purge'),
(567, 1, 'MailFullname', 'Full name of user who entered case (from Joomla account)'),
(568, 1, 'NotifyAdminOnNewCase','Email address to notify for all new cases'),
(569, 1, 'LeaveBlank', 'Leave blank to disable'),
(570, 1, 'Notifications', 'Notifications'),
(571, 1, 'Permissions', 'Permissions'),
(572, 1, 'Defaults', 'Defaults'),
(573, 1, 'FileAttachments', 'File Attachments'),
(574, 1, 'DisplayedFields', 'Displayed Fields'),
(575, 1, 'DefaultDepartment', 'Default Department'),
(576, 1, 'DefaultCategory', 'Default Category'),
(577, 1, 'Show', 'Show'),
(578, 1, 'Set', 'Set'),
(579, 1, 'IfNotSetable', 'If not visible/setable by everyone, a default for this field must be set above'),
(580, 1, 'Updated', 'Updated'); 
--
-- Dumping data for table `#__huruhelpdesk_language`
--

INSERT IGNORE INTO `#__huruhelpdesk_language` (`id`, `langname`, `localized`) VALUES
(1, 'English', 'English');

--
-- Dumping data for table `#__huruhelpdesk_priority`
--

INSERT IGNORE INTO `#__huruhelpdesk_priority` (`priority_id`, `pname`) VALUES
(6, ' 6 - VERY HIGH '),
(5, ' 5 - HIGH '),
(4, ' 4 - ELEVATED '),
(3, ' 3 - NORMAL '),
(2, ' 2 - LOW '),
(1, '1 - VERY LOW'),
(10, ' 10 - EMERGENCY - PAGE '),
(9, ' 9 - EMERGENCY - NO PAGE ');

--
-- Dumping data for table `#__huruhelpdesk_status`
--

INSERT IGNORE INTO `#__huruhelpdesk_status` (`id`, `status_id`, `sname`) VALUES
(22, 65, 'TESTING'),
(21, 63, 'WAITING'),
(20, 60, 'HOLD'),
(19, 55, 'ESCALATED'),
(18, 50, 'IN PROGRESS'),
(17, 20, 'OPEN'),
(16, 10, 'RECEIVED'),
(15, 1, 'NEW'),
(24, 100, 'CLOSED');

