<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

		JToolBarHelper::title( JText::_( 'Testimonials' ), 'ninjahdr' );
		JToolBarHelper::publishList();
		JToolBarHelper::unpublishList();
		JToolBarHelper::editList();
		JToolBarHelper::deleteList(JText::_('Are you sure you want to delete these testimonials'));
		JToolBarHelper::addNew();
		
	//Include our stylesheet for our Ninja Component Styling
	$document = JFactory::getDocument();
	$document->addStyleSheet(JURI::root().'/media/com_ninjamonials/css/admin.css', 'text/css', null, array());

	//add ie6 css if needed
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('/MSIE/',  $ua) && preg_match( '/6/',  $ua)) {		
		$document->addStyleSheet(JURI::root().'/media/com_ninjamonials/css/admin_ie6.css', 'text/css', null, array());		  
	}

?>
<form action="index.php" method="post" name="adminForm">
<table>
	<tr>
		<td align="left">
		<?php echo JText::_('Search'); ?>: 
		<input type="text" name="search" value="<?php echo $this->search ?>" id="search" />
		<button type="submit"><?php echo JText::_('Go'); ?></button>
		</td>
<?php if ($this->enable_categories) { ?>
		<td align="left">
		<?php echo JText::_('Category'); ?>: 
		<?php echo $this->lists['catlist'] ?>
		</td>
<?php } ?>
	</tr>
</table>
<table class="adminlist">
  <thead>
    <tr>
      <th width="20">
        <input type="checkbox" name="toggle" 
             value="" onclick="checkAll(<?php echo 
             count( $this->rows ); ?>);" />
      </th>
      <th class="title"><?php echo JText::_('Summary/Testimonial'); ?></th>
      <th width="10%"><?php echo JText::_('Author'); ?></th>
      <th width="10%"><?php echo JText::_('Website'); ?></th>
<?php if ($this->enable_categories) { ?>		
      <th width="15%"><?php echo JText::_('Category'); ?></th>	
<?php } ?>	  
      <th width="5%" nowrap="nowrap"><?php echo JText::_('Published'); ?></th>
    </tr>
  </thead>

  <?php
  jimport('joomla.filter.output');
  $k = 0;
  for ($i=0, $n=count( $this->rows ); $i < $n; $i++) 
  {
    $row = &$this->rows[$i];
    $checked = JHTML::_('grid.id', $i, $row->id );
    $published = JHTML::_('grid.published', $row, $i );
    
    $link = JFilterOutput::ampReplace( 'index.php?option=' . $option . '&controller=testimonials&task=edit&cid[]='. $row->id );
    
//If we have some text in the testimonial field, clean up any newline characters 
//that got escaped for security when we saved the data
	if ($row->testimonial){
			
		$inBRs = array ('<br />','<br/>','<br>','\r', '\n');
		$outBRs = array ('','','','',"\n");
		$row->testimonial = str_replace ($inBRs,$outBRs, $row->testimonial);
	}
	
    ?>
    <tr class="<?php echo "row$k"; ?>">
      <td>
        <?php echo $checked; ?>
      </td>
      <td>
      	<?php if(JRequest::getVar('object')):?>
        <a style="cursor:pointer" onclick="window.parent.jSelectArticle('<?php echo $row->id?>', '<?php echo $row->summary ? $row->summary : $row->testimonial; ?>', '<?php echo JRequest::getCmd('object')?>');"><?php echo $row->summary ? $row->summary : $row->testimonial; ?></a>
        <?php else:?>
        <a href="<?php echo $link; ?>"><?php echo $row->summary ? $row->summary : $row->testimonial; ?></a>
        <?php endif;?>
      </td>
      <td>
        <?php echo $row->author_name; ?>
      </td>
      <td>
        <?php echo $row->website_url; ?>
      </td>
<?php if ($this->enable_categories) { ?>		
      <td>
        <?php echo $row->cat_name ? $row->cat_name : JText::_('None'); ?>
      </td>
<?php } ?>
      <td align="center">
        <?php echo $published;?>
      </td>
    </tr>
    <?php
    $k = 1 - $k;
  }
  ?>
 <tfoot>
	<tr>
		<td colspan="6"><?php echo $this->pagination->getListFooter(); ?></td>
	</tr>
</tfoot>
 
</table>
<?php echo JHTML::_( 'form.token' ); ?>
<input type="hidden" name="option" value="<?php echo $option;?>" />
<input type="hidden" name="controller" value="testimonials" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
</form>

<?php
	//include our helper file to create the footer
	require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'HTML_ninjahelper_admin.php');
	
	HTML_ninjahelper_admin::showfooter(JText::_('Component Real Name'),JText::_('Component Footer Buttons'));

?>
