<?php 
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class NinjamonialsViewSingle extends JView
{
	function display($tpl = null)
	{
		$row = JTable::getInstance('Ninjamonials', 'Table');
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		$id = $cid[0];
		
		$row->load($id);
		
	//If we have some text in the testimonial field, clean up any newline characters 
	//that got escaped for security when we saved the data
		if ($row->testimonial){
			
			$inBRs = array ('<br />','<br/>','<br>','\r', '\n');
			$outBRs = array ('','','','',"\n");
			$row->testimonial = str_replace ($inBRs,$outBRs, $row->testimonial);
		}
		
		$this->assignRef('row', $row);
		
	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
			
		$this->assignRef('params', $paramsObj);
		

	//Get the category list for this row
		$db = JFactory::getDBO();
		
		$db->setQuery( "SELECT id as catid, name FROM #__nmls_categories
						ORDER BY name");
		$catsRows = $db->loadObjectList();
				
		$cats_list= '<select name="category_id" id="category_id">
					 <option value="0">'.JText::_('None').'</option>';
	
		foreach ($catsRows as &$catsRow) {
			
		//if this item was already selected then highlight it
			if ($catsRow->catid == $row->category_id){				
				$selected = ' selected="selected" ';				
			} else {
				$selected = '';
			}
			
			$cats_list.= '<option '.$selected.'value="'.$catsRow->catid.'">'.$catsRow->name.'</option>';
		}
		
		$cats_list.= '</select>';
	
		$this->assignRef('cats_list', $cats_list);
		
	//update the table and set viewed to yes if it currently no.
	//viewed is used to tell the admins if there are new testimonials or not 
		if (!$row->viewed && $id > 0)
		{
			
			$row->viewed = '1';
			
			if (!$row->store()) 
			{
				JError::raiseError(500, $row->getError() );
			}
						
		}
		
	//check the filenames that they exist and if so prepare the variables
	//TODO - if they don't exist, or there are no file names specified, disable the delete checkboxes		
	
	//TODO - put in a list builder for being able to select the video, audio and avatar files
		
		
	//setup the yes/no list for our published status	
		$this->assignRef('published', JHTML::_('select.booleanlist', 'published', 'class="inputbox"', $row->published));
		
	//setup our tooltips	
		$tooltipText = JText::_('The userid of a valid Joomla user on this site');
		$tooltipTitle = JText::_('Author Userid');
		$this->assignRef('author_id_tt',JHTML::tooltip($tooltipText, $tooltipTitle, 'tooltip.png', '', '', false));
		
		$tooltipText = JText::_('A summary of the testimonial text');
		$tooltipTitle = JText::_('Summary');
		$this->assignRef('summary_tt',JHTML::tooltip($tooltipText, $tooltipTitle, 'tooltip.png', '', '', false));
		
		$tooltipText = JText::_('The main testimonial text');
		$tooltipTitle = JText::_('Testimonial');
		$this->assignRef('testimonial_tt',JHTML::tooltip($tooltipText, $tooltipTitle, 'tooltip.png', '', '', false));
		
		$tooltipText = JText::_('The date to begin publishing this testimonial');
		$tooltipTitle = JText::_('Publish Start');
		$this->assignRef('publish_up_tt',JHTML::tooltip($tooltipText, $tooltipTitle, 'tooltip.png', '', '', false));
		
		$tooltipText = JText::_('The date to finish publishing this testimonial');
		$tooltipTitle = JText::_('Publish Finish');
		$this->assignRef('publish_down_tt',JHTML::tooltip($tooltipText, $tooltipTitle, 'tooltip.png', '', '', false));
		
		parent::display($tpl);
	}
}

?>
