<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

class NJSiteStylerControllerFlirInstances extends JController
{
	
	function save()
	{
		
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;

		$row =& JTable::getInstance('flirinstance', 'Table');

		if (!$row->bind(JRequest::get('post'))) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		//make sure we change our array of custom components and content into 
		//a comma seperated list the DB can handle.
		$row->custom_comp = implode(',', $row->custom_comp);
		$row->custom_ctnt = implode(',', $row->custom_ctnt);

		if (!$row->store()) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		if ($this->getTask() == 'apply') {
			$this->setRedirect('index.php?option=' . $option . '&controller=flirinstances&task=edit&cid[]=' . $row->id, JText::_('Changes Applied'));
		} else {
			$this->setRedirect('index.php?option=' . $option .'&controller=firrinstances&task=display', JText::_('Instance Saved'));
		}
	}
			
	function display()
	{
		$view = JRequest::getVar('view');
		
		if (!$view) {
			JRequest::setVar('view', 'all');
		}
		
		parent::display();
	}
	
//Edit(add included)
	function edit()
	{
		JRequest::setVar('view', 'single');

		$this->display();
	}
	
	function publish()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
		$cid = JRequest::getVar('cid', array());
		
		$row =& JTable::getInstance('flirinstance', 'Table');
		
		$publish = 1;
	
		if ($this->getTask() == 'unpublish') {
			$publish = 0;
		}
		
		if(!$row->publish($cid, $publish))
		{
			JError::raiseError(500, $row->getError() );
		}
		
		$msg = '';
		
		if (count($cid) > 1) {
			$msg = JText::_('Instances');
		} else {
			$msg = JText::_('Instance');				
		}
		
		
		if ($this->getTask() == 'unpublish') {
			$msg .= ' '.JText::_('Unpublished');
		} else {
			$msg .= ' '.JText::_('Published');
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=flirinstances&task=display', $msg);
		
	}
	
	function remove()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
		$cid = JRequest::getVar('cid', array(0));
		
		$row =& JTable::getInstance('flirinstance', 'Table');
		
		foreach ($cid as $id) {
			$id = (int) $id;
			
			if (!$row->delete($id)) {
				JError::raiseError(500, $row->getError() );
			}
		}
		
		$msg = '';
		
		if (count($cid) > 1) {
			$msg = JText::_('Instances');
		} else {
			$msg = JText::_('Instance');				
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=flirinstances&task=display', $msg.' '.JText::_('Deleted'));
	}
	
}

?>
