<?php
/*
 * This component updates Joomla from its official website to the latest version.
	It was developed by Rahman Haghparast as a part of Realtyna software section. 
	Email me for any questions and give me your ideas to make this component better. 
	Special thanks to Vincent Blavet (http://www.phpconcept.net) for his pclzip class 
	Apache mod_curl should be enabled for this component to run properly.
	As in version 1.1 the component will work without mod_curl too.
	As in version 1.2 an icon is added to joomla control panel and checks the latest version automatically when the admin goes to the cpanel section of joomla. 
	As in version 1.3 the component will update using the complete stable package or just the patch files. Thanks to Michel de Joode for his idea and his support for this feature. 
	As in version 1.4 the component will replace all files even if they have been changed by users. It will also show the error information upon facing any kind of errors.
	As in version 2.0 you can add your own update URL to the component and use them later.
 * 
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.controller');

class NJSiteStylerControllerJoomlaUpdaterEdit extends JController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
	}

	/**
	 * display the edit form
	 * @return void
	 */
	function edit()
	{
		JRequest::setVar( 'view', 'joomlaupdateredit' );

		parent::display();
	}

	/**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	function save()
	{
		JRequest::checkToken() || jexit('Invalid token.');

		$model = $this->getModel('joomlaupdateredit');

		if ($model->store($post)) {
			$msg = JText::_( 'URL Saved!' );
		} else {
			$msg = JText::_( 'Error Saving URL' );
		}

		// Check the table in so it can be edited.... we are done with it anyway
		$link = 'index.php?option=com_joomlaupdater';
		$this->setRedirect($link, $msg);
	}

	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		JRequest::checkToken() || jexit('Invalid token.');

		$model = $this->getModel('joomlaupdateredit');
		if(!$model->delete()) {
			$msg = JText::_( 'Error: One or More URLs Could not be Deleted' );
		} else {
			$msg = JText::_( 'URL(s) Deleted' );
		}

		$this->setRedirect( 'index.php?option=com_joomlaupdater', $msg );
	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_joomlaupdater', $msg );
	}

	function updatejoomlacomplete()
	{
		JRequest::checkToken() || jexit('Invalid token.');

		$model = $this->getModel('joomlaupdateredit');
		$txt = $model->UpdateJoomlaComplete();
		$msg = JText::_( $txt );
		$link = 'index.php?option=com_joomlaupdater';
		$this->setRedirect($link, $msg);
	}
	
	function updatejoomlapatch()
	{
		$model = $this->getModel('joomlaupdateredit');
		$txt = $model->UpdateJoomlaPatch();
		$msg = JText::_( $txt );
		$link = 'index.php?option=com_joomlaupdater';
		$this->setRedirect($link, $msg);
	}
	
}
?>
