<?php defined( '_JEXEC' ) or die('Restricted access');

# $Id: rulesinstances.php 1814 2009-11-23 18:55:22Z uwalter Exp $

jimport('joomla.application.component.controller');

class NJSiteStylerControllerRulesInstances extends JController
{
	function save()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		$row	=& JTable::getInstance('rulesinstance', 'Table');
		$option =  JRequest::getCmd('option');


		if (! $row->bind(JRequest::get('post'))) 
		{
			JError::raiseError(500, $row->getError() );
		}

		
		//make sure we change our array of custom components and content into 
		//a comma seperated list the DB can handle.
		$row->custom_ctnt		= implode(',', $row->custom_ctnt);
		$row->custom_comp		= implode(',', $row->custom_comp);
		$row->custom_groups		= implode(',', $row->custom_groups);
		$row->custom_browsers	= implode(',', $row->custom_browsers);
		$row->custom_users		= implode(',', $row->custom_users);

		if (! $row->store()) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		if ($this->getTask() == 'apply')
		{
			$this->setRedirect('index.php?option='.$option.'&controller=rulesinstances&task=edit&cid[]=' . $row->id, JText::_('Changes Applied'));
		}
		else
		{
			$this->setRedirect('index.php?option='.$option.'&controller=rulesinstances&task=display',  JText::_('Instance Saved'));
		}
	}
			
	function display()
	{
		$view = JRequest::getVar('view');
		
		if (! $view)
		{
			JRequest::setVar('view', 'rulesall');
		}
		
		parent::display();
	}
	
	function edit()
	{
		//Edit(add included)

		JRequest::setVar('view', 'rulessingle');

		$this->display();
	}
	
	function publish()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		$row	=& JTable::getInstance('rulesinstance', 'Table');
		$option	=  JRequest::getCmd('option');
		$cid	=  JRequest::getVar('cid', array());
		
		
		$publish = 1;
	
		if ($this->getTask() == 'unpublish')
		{
			$publish = 0;
		}
		
		if(! $row->publish($cid, $publish))
		{
			JError::raiseError(500, $row->getError() );
		}
		
		$msg = '';
		
		if (count($cid) > 1)
		{
			$msg = JText::_('Instances');
		}
		else
		{
			$msg = JText::_('Instance');				
		}
		
		
		if ($this->getTask() == 'unpublish')
		{
			$msg .= ' '.JText::_('Unpublished');
		}
		else
		{
			$msg .= ' '.JText::_('Published');
		}
		
		$this->setRedirect('index.php?option='.$option.'&controller=rulesinstances&task=display', $msg);
	}
	
	function remove()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		$row	=& JTable::getInstance('rulesinstance', 'Table');
		$option	=  JRequest::getCmd('option');
		$cid	=  JRequest::getVar('cid', array());
		
		foreach ($cid as $id)
		{
			if (! $row->delete((int) $id))
			{
				JError::raiseError(500, $row->getError());
			}
		}
		
		$msg = '';
		
		if (count($cid) > 1)
		{
			$msg = JText::_('Instances');
		}
		else
		{
			$msg = JText::_('Instance');				
		}
		
		$this->setRedirect('index.php?option='.$option.'&controller=rulesinstances&task=display', $msg.' '.JText::_('Deleted'));
	}
}
