<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

// load the component language file
$language = &JFactory::getLanguage();
$language->load('com_ninjasitestyler');

//$nPaths = $this->_paths;
$status = new JObject();
$status->plugins = array();

	/***********************************************************************************************
 * ---------------------------------------------------------------------------------------------
 * PLUGIN INSTALLATION SECTION
 * ---------------------------------------------------------------------------------------------
 ***********************************************************************************************/


$plugins = &$this->manifest->getElementByPath('plugins');
if (is_a($plugins, 'JSimpleXMLElement') && count($plugins->children())) {

	foreach ($plugins->children() as $plugin)
	{
		$pname		= $plugin->attributes('plugin');
		$pgroup		= $plugin->attributes('group');

		// Set the installation path
		if (!empty($pname) && !empty($pgroup)) {
			$this->parent->setPath('extension_root', JPATH_ROOT.DS.'plugins'.DS.$pgroup);
		} else {
			$this->parent->abort(JText::_('NSS_PLUGIN').' '.JText::_('NSS_INSTALL').': '.JText::_('NSS_INSTALL_PLUGIN_FILE_MISSING'));
			return false;
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Filesystem Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */

		// If the plugin directory does not exist, lets create it
		$created = false;
		if (!file_exists($this->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($this->parent->getPath('extension_root'))) {
				$this->parent->abort(JText::_('NSS_PLUGIN').' '.JText::_('NSS_INSTALL').': '.JText::sprintf('NSS_INSTALL_PLUGIN_PATH_CREATE_FAILURE', $this->parent->getPath('extension_root')));
				return false;
			}
		}

		/*
		 * If we created the plugin directory and will want to remove it if we
		 * have to roll back the installation, lets add it to the installation
		 * step stack
		 */
		if ($created) {
			$this->parent->pushStep(array ('type' => 'folder', 'path' => $this->parent->getPath('extension_root')));
		}

		// Copy all necessary files
		$element = &$plugin->getElementByPath('files');
		if ($this->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		// Copy all necessary files
		$element = &$plugin->getElementByPath('languages');
		if ($this->parent->parseLanguages($element, 1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		// Copy media files
		$element = &$plugin->getElementByPath('media');
		if ($this->parent->parseMedia($element, 1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Database Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */
		$db = &JFactory::getDBO();

		// Check to see if a plugin by the same name is already installed
		$query = 'SELECT `id`' .
				' FROM `#__plugins`' .
				' WHERE folder = '.$db->Quote($pgroup) .
				' AND element = '.$db->Quote($pname);
		$db->setQuery($query);
		if (!$db->Query()) {
			// Install failed, roll back changes
			$this->parent->abort(JText::_('NSS_PLUGIN').' '.JText::_('NSS_INSTALL').': '.$db->stderr(true));
			return false;
		}
		$id = $db->loadResult();

		// Was there a plugin already installed with the same name?
		if ($id) {

			if (!$this->parent->getOverwrite())
			{
				// Install failed, roll back changes
				$this->parent->abort(JText::_('NSS_PLUGIN').' '.JText::_('NSS_INSTALL').': '.JText::sprintf('NSS_INSTALL_PLUGIN_ALREADY_EXISTS', $pname));
				return false;
			}

		} else {
			$row =& JTable::getInstance('plugin');
			$row->name = JText::_(ucfirst($pgroup)).' - '.JText::_(ucfirst($pname));
			$row->ordering = 0;
			$row->folder = $pgroup;
			$row->iscore = 0;
			$row->access = 0;
			$row->client_id = 0;
			$row->element = $pname;
			$row->published = 1;
			$row->params = '';

			if (!$row->store()) {
				// Install failed, roll back changes
				$this->parent->abort(JText::_('NSS_PLUGIN').' '.JText::_('NSS_INSTALL').': '.$db->stderr(true));
				return false;
			}
		}

		$status->plugins[] = array('name'=>$pname,'group'=>$pgroup);
	}
}



function com_install()
{


/***********************************************************************************************
 * ---------------------------------------------------------------------------------------------
 * TABLE STRUCTURE UPDATE SECTION
 * ---------------------------------------------------------------------------------------------
 ***********************************************************************************************/


$db = &JFactory::getDBO();
	
//Do updates of table structure if we need to
//This is mainly for people doing an upgrade
$db->setQuery("SHOW FULL COLUMNS FROM #__scriptsinstance where field = 'file_url'");

$results = $db->loadObjectList();

if (!count($results))
{
	$db->setQuery("	ALTER TABLE `#__scriptsinstance`
					ADD COLUMN `file_url` VARCHAR(255);");
	$db->query();
	    
}

}

?>
