<?php defined('_JEXEC') or die();

# $Id: joomlaupdater.php 1608 2009-10-26 03:00:07 uwalter Exp $

jimport('joomla.application.component.model');

class NJSiteStylerModelJoomlaUpdater extends JModel
{
	var $version    = '1.0';

	var $_domain    = 'http://joomlacode.org'; 
    var $_links     = false;
	var $_latest	= JVERSION;


	function NewVersionAvailable()
	{
        # Reserved for later use.

		return '';
	}
	
	function _getPage($url)
	{
		if (function_exists('curl_version') && !ini_get('safe_mode') && !ini_get('open_basedir'))
		{
			$ch = curl_init($url);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_ENCODING, "");
			curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux x86_64; de; rv:1.9.0.15) Gecko/2009102814 Ubuntu/8.04 (hardy) Firefox/3.0.15");
			curl_setopt($ch, CURLOPT_AUTOREFERER, true);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 120);
			curl_setopt($ch, CURLOPT_TIMEOUT, 120);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
	
			$content =
				curl_exec(  $ch );
				curl_close( $ch );
		}
		else
		{
			$content = @file_get_contents($url);
		}

		return $content;
	}
	
	function _getFileExtension()
	{
		/**
		 * Here we determine whether bzip2, gzip or zip is available.
		 * bzip2 has the best compression rate, hence we do
		 * faster download.
		 */

		return extension_loaded('bz2') ? 'tar.bz2' : extension_loaded('zlib') ? 'tar.gz' : 'zip';
	}

	
	function _getLinks()
	{
		$uri		= '/gf/project/joomla/frs/'; 
        $matches	= array();
        $page		= '';


		if (! $this->_links)
		{
			# First run? OK, then we initialize our links array.

			$this->_links = array();
		}


		# Get the files listing page for the determination of the latest version.

		$page = $this->_getPage($this->_domain.$uri);


		# But we need to get onto the 'FrsReleaseBrowse' page, because the files listing
		# could be paginated and then it is possible to miss particular packets.

		preg_match_all('@<a\s+[^>]*?href="('.$uri.'\?action=FrsReleaseBrowse.+?)"\s*[^>]*?><img[^>]*?>&nbsp;Joomla(.+?)</a>@si', $page, $matches);

		foreach ($matches[2] as $key => $value)
		{
			# No 1.6 and no ReleaseCandidates!

			if (preg_match('/^(?:1\.6|1\.5\.\d+RC)$/', $value)) continue;

			if ($value > JVERSION)
			{
				$this->_latest = $value;

				$uri = str_replace('&amp;', '&', $matches[1][$key]);
			}
		}


		# Now get the files list pages for the latest version.

		$page = $this->_getPage($this->_domain.$uri);


		# Parse page and get download links.

		preg_match_all('@<a\s+[^>]*?href="(/gf/download/.+?)"\s*[^>]*?>@si', $page, $matches);

	
		# And finally push all links together.

		foreach ($matches[1] as $key => $value)
		{
			array_push($this->_links, $value);
		}
	}

	
	function getPackage($type = 'full')
	{
        # Fetch the joomlacode.org project page and parse
        # download links, if not already done.

        if (! $this->_links) $this->_getLinks();


		if(count($this->_links))
		{
            # When the package links were sucessfully extracted ...

			foreach($this->_links as $key => $val)
			{
                # ... we search for the needed package.

				if (stripos($val, $type) !== FALSE && stripos($val, $this->_getFileExtension()) !== FALSE)
				{
                    if ($type == 'patch' && strpos($val, JVERSION.'_to') !== FALSE)
                    {
                        # We need a patch package? OK, then check for the appropriate version.

					    return $this->_domain.$val;
                    }

                    if ($type == 'full' && strpos($val, '_to_') === FALSE)
                    {
                        # No, we need a full install.

					    return $this->_domain.$val;
                    }
				}
		    }

			# We were not able to get any suitable package link!

			return FALSE;
		}
	}
	
	function getLatestVersion()
	{
		$version = $this->getPackage();

		if ($version)
		{
			return $this->_latest;
		}
		else
		{
			return FALSE;
		}
	}

	
    function _buildQuery()
    {
        return ' SELECT * FROM #__nssjoomlaupdater ';
    }

	function GetURLFromDB()
	{
        // Lets load the data if it doesn't already exist

        if (empty($this->_data))
        {
            $this->_data = $this->_getList($this->_buildQuery());
        }
 
        return $this->_data;
	}

}
?> 
