<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
class NJSiteStylerModelJoomlaUpdaterEdit extends JModel
{
	/**
	* Constructor that retrieves the ID from the request
	*
	* @access	public
	* @return	void
	*/
	function __construct()
	{
		parent::__construct();

		$cIds = JRequest::getVar('cid',  0, '', 'array');

		// Set id and wipe data

		$this->_data	= false;
		$this->_id		= (int) $array[0];
	}


	/**
	* Method to get a url
	* @return object	MySQL data (alternative download links)
	*/
	function &getData()
	{
		if (! $this->_data)
		{
			$this->_db->setQuery('SELECT * FROM #__nssjoomlaupdater  WHERE id = '.$this->_id);

			$this->_data = $this->_db->loadObject();
		}

		if (! $this->_data)
		{
			$this->_data		= new stdClass();
			$this->_data->id	= 0;
			$this->_data->url	= null;
		}
		return $this->_data;
	}

	/**
	* Method to store a record
	*
	* @access	public
	* @return	boolean	True on success
	*/
	function store()
	{
		$row =& $this->getTable();

		$data = JRequest::get( 'post' );

		// Bind the form fields to the url table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the url record is valid
		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		
		// Store the web link table to the database
		if (!$row->store()) {
			$this->setError( $row->getErrorMsg() );
			return false;
		}

		return true;
	}

/**
 * Method to delete record(s)
 *
 * @access	public
 * @return	boolean	True on success
 */
	function delete()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );

		$row =& $this->getTable();

		if (count( $cids ))
		{
			foreach($cids as $cid) {
				if (!$row->delete( $cid )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
			}						
		}
		return true;
	}

	function UpdateJoomlaCustom()
	{
		$this->_data	= false;
		$this->_id		= JRequest::getInt('cid');

		$customPatches =& $this->getData();

		return $this->display($customPatches->url);
	}

	function UpdateJoomlaPatch()
	{
		$data = JRequest::get('post');

		return $this->display($data['JoomlaPatch']);
	}
	
	function getPackage($url)
	{
		$FileName = substr($url,strrpos($url,"/") + 1);
		
		$path = JPATH_COMPONENT_ADMINISTRATOR.DS.'addcodetmp';


		if (is_writable($path))
		{
			echo JText::_('DOWNLOADING'), ' .... ';

			$fp = fopen($path.DS.$FileName, "wb");

			if (function_exists('curl_version') && !(ini_get('safe_mode')) &&!(ini_get('open_basedir')))
			{
				$ch = curl_init($url);
		
				curl_setopt($ch, CURLOPT_FILE, $fp);
				curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);	
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		
				if (curl_exec($ch) === false)
				{
					echo JText::_('CURL error: '), curl_error($ch);
				}
				else
				{
					echo JText::_( 'Operation completed without any curl function errors');
				}
				curl_close($ch);
			}
			else
			{
				if ($contents = @file_get_contents( $url ))
				{
					echo JText::_('Operation completed without any file_get_contents mode errors');
				}
				else
				{
					echo JText::_('There was a problem fetching the Joomla zip file');
				}
				fwrite($fp, $contents);
			}
			fclose($fp);
		}
		else
		{
			echo JText::_('DIRECTORY_NOT_WRITABLE');
		}

		print '<br />';

		return $FileName;
	}
	

	/**
	 * Joomla! 1.5.x native file and package handling.
	 *
	 * Here we extract the downloaded package due to resident compression mechanism.
	 * Afterwards compressed backup files are created and the neew files moved
	 * to their appropriate location.
	 */
	function upgrade($package = false)
	{
		if ($package)
		{
			jimport('joomla.filesystem.archive');

			$path	= JPATH_COMPONENT_ADMINISTRATOR.DS.'addcodetmp';
			$dir	= preg_replace('/^(.+?)(?:\.(?:zip|tar\.gz|tar\.bz2))$/', '$1', $package);
			$html	= JText::_('The extracted files were:').'</br>';
			$return = '';

			echo
				JText::_('STATUS'), ": ",
				JText::_('JOOMLA_UPGRADE_IN_PROGRESS'), "<br/>\n";

			if (JArchive::extract($path.DS.$package, $path.DS.$dir))
			{
				# If we were able to successfully extract the archive, ...

				$bak = '.nss-'.JVERSION;

				echo
					JText::_('SUCCESSFULLY_EXTRACTED'), "<br/>\n",
					JText::_('COPYING_FILES'), " ... <br/>\n";

				foreach (JFolder::files($path.DS.$dir, '', true, true) as $file)
				{
					# ... we iterate through the package's folder structure, ...

					$oldfile = preg_replace('|^'.$path.DS.$dir.'(.*)$|', '$1', $file);

					$html .=  "[+]  ". $oldfile. "<br/>\n";
					echo      "[+]  ", $oldfile, "<br/>\n";

					if (file_exists(JPATH_SITE.$oldfile))
					{
						# ... back up the original files, respectively latest upgrade files ...

						JArchive::create(JPATH_SITE.$oldfile.$bak, JPATH_SITE.$oldfile, $this->_getFileExtension(), '', '', true, true);
					}

					# ... copy the extracted files ...

					JFile::copy($file, JPATH_SITE.$oldfile);
				}

				# ... and delete the empty folder structure. (But we keep the compressed package)

				JFolder::delete($path.DS.$dir);

				$fp =
					fopen($path.DS.$package.'.html','w');
					fwrite($fp, $html);
					fclose($fp);

				return
					JText::_('Joomla was successfully updated').
					JText::_('Click').' <a href=\'/administrator/components/com_ninjasitestyler/addcodetmp/'.$package.'.html\' target=\_blank\><font color=\'red\'>'.
					JText::_('here').'</font></a>  '.
					JText::_('to see the extracted files list.');
			}
			else
			{
				return JText::_('ERROR_EXTRACTING_PACKAGE');
			}
		}
		else
		{
			return JText::_('ERROR_NO_PACKAGE_PASSED');
		}
	}

	function display($url = false)
	{
		echo '<h2>',
			JText::_('UPGRADE_DETAILS'), "</h2>\n",
			JText::_( 'USING_URL' ), ": ", $url, "<br/><br/>\n",
			JText::_( 'RESULTS' ), ":<br/>\n";

		if ($url)
		{
			return $this->upgrade($this->getPackage($url));
		}	
		else
		{
			return JText::_('URL_NOT_FOUND');
		}
	}

	function _getFileExtension()
	{
		/**
		 * Here we determine whether bzip2, gzip or zip is available.
		 * bzip2 has the best compression rate.
		 */

		return extension_loaded('bz2') ? 'bz2' : extension_loaded('zlib') ? 'gz' : 'zip';
	}
}
