<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

class NjsifrControllerSifrFiles extends JController
{
		
	function display ()
	{
		
		$view = JRequest::getVar('view');
		
		JRequest::setVar('view', 'uploadsifrfonts');
		
		parent::display();
	}
	
	function remove ()
	{
		
		global $option;
		
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		//our sifr fonts directory
		$uploadsDirectory = JPATH_COMPONENT_ADMINISTRATOR.DS.'fonts';
		
		//get the names of the files to be deleted
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		
		//loop through our file list
		for ($i=0, $n=count($cid); $i < $n; $i++) 
		{
		
			if (!unlink($uploadsDirectory.DS.basename($cid[$i])))
				$this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'Error deleting file: '.$cid[$i].'. Operation aborted');	
		
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'Files Deleted');
	}
	
	function saveuploadsifrfonts() 
	{
		
		//check token
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
		// first let's set some variables
		
		// make a note of the directory that will recieve the uploaded file
		$uploadsDirectory = JPATH_COMPONENT_ADMINISTRATOR.DS.'fonts';
		
		// fieldname used within the file <input> of the HTML form
		$fieldname = 'file';
		
		// Now let's deal with the upload
		
		// check the upload form was actually submitted else print the form
		if (!isset($_POST['submit'])){
		    $this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'Please Submit Form');
		    $this->redirect();
		}
		// possible PHP upload errors
		$errors = array(1 => 'php.ini max file size exceeded',
		                2 => 'html form max file size exceeded',
		                3 => 'File upload was only partial',
		                4 => 'No file was attached'); 
		
		// check for PHP's built-in uploading errors
		if (!($_FILES[$fieldname]['error'] == 0)){
		    $this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', $errors[$_FILES[$fieldname]['error']]);
		    $this->redirect();
		}
		
		// check that the file we are working on really was the subject of an HTTP upload
		$tmp_file_path = $_FILES[$fieldname]['tmp_name'];
		if (!(@is_uploaded_file($tmp_file_path))){
		    $this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'not an HTTP upload');
		    $this->redirect();
		}
		
		// Do some filename cleaning.
		//first get our helper file with some functions in it
		require_once(JPATH_COMPONENT_ADMINISTRATOR.DS.'helpers'.DS.'file_helpers.php');
        $tmp_file_name = cleanFileName( $_FILES[$fieldname]['name'] );
            
		// validation... since we only need sifr font files for Super sIFR we should run a check  
		$file_ext      = substr($tmp_file_name, strripos($tmp_file_name, '.'));		
		if ($file_ext != '.swf'){
			$this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'Only .swf flash files allowed');
		    $this->redirect();
		}
		
		//check that we don't already have a file with the same name
		if (file_exists($uploadsDirectory.DS.$tmp_file_name)){
			$this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'File '.$tmp_file_name.' already exists');
		    $this->redirect();
		}
		
		//is the dir writable??
		if ( !is_writable( $uploadsDirectory ) ) {
			$this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'Upload permission error!');
		    $this->redirect();
		}
        		
		// now let's move the file to its final location and allocate the new filename to it
		$target_path = $uploadsDirectory.DS.basename($tmp_file_name); 

		if(move_uploaded_file($_FILES[$fieldname]['tmp_name'], $target_path)) {
		    $this->setRedirect('index.php?option=' . $option .'&controller=sifrfiles&task=display', 'File '.$tmp_file_name.' has been uploaded successfully');
		} else{
		    $this->setRedirect('index.php?option=' . $option .'&&controller=sifrfiles&task=display', 'There was an error uploading the file '.$tmp_file_name.' , please try again!');
		}		
		    
	}	
}


?>
