<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

class NjsifrControllerSifrInstances extends JController
{
	function add()
	{
		JRequest::setVar('view', 'single');

		$this->display();
		
	}

	function save()
	{
		
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;

		$row =& JTable::getInstance('Njsifr', 'Table');

		if (!$row->bind(JRequest::get('post'))) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		//make sure we change our array of custom components and content into 
		//a comma seperated list the DB can handle.
		if ($row->custom_comp) {
      $row->custom_comp = implode(',', $row->custom_comp);
    }
		if ($row->custom_ctnt) {
      $row->custom_ctnt = implode(',', $row->custom_ctnt);
    }
		if (!$row->store()) 
		{
			JError::raiseError(500, $row->getError() );
		}
		
		if ($this->getTask() == 'apply') {
			$this->setRedirect('index.php?option=' . $option . '&controller=sifrinstances&task=edit&cid[]=' . $row->id, 'Changes Applied');
		} else {
			$this->setRedirect('index.php?option=' . $option .'&controller=sifrinstances&task=display', 'sIFR Instance Saved');
		}
	}
			
	function display()
	{
		$view = JRequest::getVar('view');
		
		if (!$view) {
			JRequest::setVar('view', 'all');
		}
		
		parent::display();
	}
	
	function edit()
	{
		JRequest::setVar('view', 'single');

		$this->display();
	}
	
	function adjustsifr()
	{
		
		$row =& JTable::getInstance('Njsifr', 'Table');
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		global $option;
		
		switch ($this->getTask()) {
			case 'yesmodhdng':
				$useStatus = 1;
				$msg = 'Module Headings Enabled';
				break;
				
			case 'nomodhdng':
				$useStatus = 0;
				$msg = 'Module Headings Disabled';
				break;
				
			case 'yescomphdng':
				$useStatus = 1;
				$msg = 'Component Headings Enabled';
				break;
				
			case 'nocomphdng':
				$useStatus = 0;
				$msg = 'Component Headings Disabled';
				break;
				
			case 'yesctnthdng':
				$useStatus = 1;
				$msg = 'Content Headings Enabled';
				break;
				
			case 'noctnthdng':
				$useStatus = 0;
				$msg = 'Content Headings Disabled';
				break;
				
			case 'yesds':
				$useStatus = 1;
				$msg = 'Drop Shadow Heading Enabled';
				break;
				
			case 'nods':
				$useStatus = 0;
				$msg = 'Drop Shadow Heading Disabled';
				break;
		}
		
		
		
		for ($i=0, $n=count( $cid ); $i < $n; $i++) 
		{
	
			$row->load($cid[$i]);
			
			switch ($this->getTask()) {
			case 'yesmodhdng':
			case 'nomodhdng':
				$row->mod_hdng_selector = $useStatus;
				break;
				
			case 'yescomphdng':
			case 'nocomphdng':
				$row->comp_hdng_selector = $useStatus;
				break;
				
			case 'yesctnthdng':
			case 'noctnthdng':
				$row->ctnt_hdng_selector = $useStatus;
				break;
				
			case 'yesds':
			case 'nods':
				$row->use_ds = $useStatus;
				break;
			}
			
			if (!$row->store()) 
			{
				JError::raiseError(500, $row->getError() );
			}
		
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=sifrinstances&task=display', 'sIFR Instance '.$msg);
	}
	
	function publish()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
		$cid = JRequest::getVar('cid', array());
		
		$row =& JTable::getInstance('Njsifr', 'Table');
		
		$publish = 1;
	
		if ($this->getTask() == 'unpublish') {
			$publish = 0;
		}
		
		if(!$row->publish($cid, $publish))
		{
			JError::raiseError(500, $row->getError() );
		}
		
		$s = '';
		
		if (count($cid) > 1) {
			$s = 's';
		}
		
		$msg = 'sIFR Instance' . $s;

		if ($this->getTask() == 'unpublish') {
			$msg .= ' unpublished';
		} else {
			$msg .= ' published';
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=sifrinstances&task=display', $msg);
		
	}
	
	function remove()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		global $option;
		
		$cid = JRequest::getVar('cid', array(0));
		
		$row =& JTable::getInstance('Njsifr', 'Table');
		
		foreach ($cid as $id) {
			$id = (int) $id;
			
			if (!$row->delete($id)) {
				JError::raiseError(500, $row->getError() );
			}
		}
		
		$s = '';
		
		if (count($cid) > 1) {
			$s = 's';
		}
		
		$this->setRedirect('index.php?option=' . $option .'&controller=sifrinstances&task=display', 'sIFR Instance' . $s . ' deleted.');
	}
	
}

?>
