<?php
/**
 * @version		2.0.9 alpharegistration $
 * @package		alpharegistration
 * @copyright	Copyright © 2009 - Bernard Gilly - All rights reserved.
 * @license		GNU/GPL
 * @author		Bernard Gilly
 * @author mail	contact@alphaplug.com
 * @website		www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class AlpharegistrationController extends JController
{

	function display()
	{
		parent::display();
	}

	/**
	 * Prepares the registration form
	 * @return void
	 */
	function register($post='')
	{
		$user 	=& JFactory::getUser();		
		
		JPlugin::loadLanguage( 'com_user' );	
				
		$usersConfig = &JComponentHelper::getParams( 'com_users' );
		if (!$usersConfig->get( 'allowUserRegistration' )) {
			JError::raiseError( 403, JText::_( 'Access Forbidden' ));
			return;
		}
		
		if ( $user->get('guest')) {
			JRequest::setVar('view', 'register');	
			JRequest::setVar('post', $post );
			$arg_params = &JComponentHelper::getParams( 'com_alpharegistration' );
			if ( $arg_params->get( 'displayreferralcodeAUP' ) ) {			
				@session_start('alphauserpoints');
				if ( @$_SESSION['referrerid']!='' ) 
				{
					JRequest::setVar('referrerid', @$_SESSION['referrerid'] );
				} else JRequest::setVar('referrerid', '' );
			}	
		} else {
			$this->setRedirect('index.php?option=com_user&task=edit',JText::_('You are already registered.'));
		}		
		
		
		parent::display();
	}

	/**
	 * Save user registration and notify users and admins if required
	 * @return void
	 */
	function register_save()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		
		JPlugin::loadLanguage( 'com_user' );
		jimport( 'joomla.mail.helper' );
		
		$usersConfig = &JComponentHelper::getParams( 'com_users' );
		
		$arg_params = &JComponentHelper::getParams( 'com_alpharegistration' );
		
		$db	   =& JFactory::getDBO();		
		$nullDate	= $db->getNullDate();
		$date =& JFactory::getDate();
		$now  = $date->toMySQL();
		$ip = $this->getClientIP();
		
		// Purge automatically the users table
		if ( $arg_params->def( 'purge_table_users', 0 ) )
		{
			$piordate = time();
			$piordate = $piordate - (86400*$arg_params->get( 'purge_table_users' ));	
			$olddate =& JFactory::getDate($piordate);
			$priornow = $olddate->toMySQL();		
		}
		
		$view  = $this->getView  ( 'register','html' );
		
		// reCaptcha	
		if ( $arg_params->def( 'userecaptcha', 1 ) ) {
			require_once (JPATH_COMPONENT.DS.'assets'.DS.'recaptcha'.DS.'recaptchalib.php');	
			$privatekey = $arg_params->get( 'privkey' );
			
			// the response from reCAPTCHA
			$resp = null;
			// the error code from reCAPTCHA, if any
			$error = null;
			
			// was there a reCAPTCHA response?
			$recaptcha_response_field = JRequest::getVar('recaptcha_response_field', '', 'post', 'string');			
			if ( $recaptcha_response_field !='' ) {
					$resp = recaptcha_check_answer ($privatekey,
													$_SERVER["REMOTE_ADDR"],
													$_POST["recaptcha_challenge_field"],
													$recaptcha_response_field);
			
					if (!$resp->is_valid) {
						// set the error code so that we can display it
						$error = $resp->error;
						JError::raiseWarning(0, JText::_($error) );
						$this->register(JRequest::get('post'));
						return false;
					}
			} else {
					JError::raiseWarning(0, JText::_('ARG_YOU_MUST_ENTER_THE_VERIFICATION_CODE') );
					$this->register(JRequest::get('post'));
					return false;			
			} 
		}		
		
		// check again all fields
		$username = JRequest::getVar('username', '', 'post', 'string');
		$vusername = strlen($username);		
		if ( $vusername<4 )  {
			JError::raiseWarning('', JText::_('ARG_USERNAME_4_CHARS'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		$name = JRequest::getVar('name', '', 'post', 'string');
		$vname = strlen($name);
		if ( $vname<4 )  {
			JError::raiseWarning('', JText::_('ARG_NAME_4_CHARS'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		$email = JRequest::getVar('email', '', 'post', 'string');
		
		if ( !JMailHelper::isEmailAddress($email) ){
			JError::raiseWarning('', JText::_('ARG_ENTER_A_VALID_EMAIL'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		if ($arg_params->get('emailfilter') && $arg_params->get('emaildomainslist')!='')
		{
			// check if email domain is in reject list
			$pos = strrpos($email, '@');
			if ( $pos ) 
			{
				$domain = substr($email,$pos+1);
				//JError::raiseWarning( 0, $domain );
				$domainslisttext = str_replace(" ", "", $arg_params->get('emaildomainslist'));
				$domainslist = explode( ",", $domainslisttext);			
				$emailreject = in_array( $domain, $domainslist );
				if ( $emailreject )
				{
					JError::raiseWarning('', JText::_('ARG_THIS_EMAIL_DOMAIN_IS_NOT_AVAILABLE'));
					$this->register(JRequest::get('post'));
					return false;
				}
			}
		}

		// BOTSCOUT.COM
		if ($arg_params->get('useBotScout'))
		{			
			if ($this->isBotScoutListed( $email, $ip, $arg_params ) === true )
			{
					JError::raiseWarning('', JText::_('ARG_MESSAGE_BLOCKED_BY_BOTSCOUT'));
					$this->register(JRequest::get('post'));
					return false;
			}			
		}
		
		$password = JRequest::getVar('password', '', 'post', 'string');
		$vpassword = strlen($password);
		if ( $vpassword<4 )  {
			JError::raiseWarning('', JText::_('ARG_PASSWORD_4_CHARS'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		$badpasswordslist = array ("pass","password","sex","god","123456","123","liverpool","letmein","qwerty","monkey","azerty","merde","bite","couille","salope","connard","123123","123123123","123456789","test");
		
		if ( in_array( strtolower($password), $badpasswordslist ) ) {
			JError::raiseWarning('', JText::_('ARG_PLEASE_USE_A_STRONGER_PASSWORD'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		$password2 = JRequest::getVar('password2', '', 'post', 'string');
		if ( $password!= $password2 )  {
			JError::raiseWarning('', JText::_('ARG_CONFIRM_PASSWORD'));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		// Birthdate (AlphaUserPoints component)
		$birthdate = '';
		if ( $arg_params->def( 'displaybirthdateAUP', 0 )  ) {			
			$birthdate = JRequest::getVar('birthdate', '0000-00-00', 'post', 'date');
			// If required...
			if ( $arg_params->get( 'displaybirthdateAUP')==2 && $birthdate=='' ) {
				JError::raiseWarning('', JText::_('ARG_YOU_MUST_ENTER_A_BIRTHDATE'));
				$this->register(JRequest::get('post'));
				return false;
			}
			// if minimum age...
			if ( $arg_params->def( 'minimum_age', 0 ) && $birthdate!='0000-00-00') {
				//if ( $this->minimum_age($birthdate) < $arg_params->get( 'minimum_age' ) ) {
				if ( $this->date_diff($birthdate,$now) < $arg_params->get( 'minimum_age' ) ) {				
					JError::raiseWarning('', JText::_( 'ARG_MINIMUM_AGE' ) . ': ' . $arg_params->get( 'minimum_age' ) );
					$this->register(JRequest::get('post'));
					return false;				
				}			
			}			
		}
		
		// Gender (AlphaUserPoints component)
		$gender = '';
		if ( $arg_params->def( 'displaygenderAUP', 0 )  ) {			
			$gender = JRequest::getVar('gender', 1, 'post', 'int');
		}		
		
		// Check terms of use		
		if ( $arg_params->def( 'displaytermsofuse', 1 )  ) {
			$terms = JRequest::getVar('terms', '', 'post', 'string');
			if ( !$terms ) {
				JError::raiseWarning('', JText::_('ARG_YOU_ACCEPT_TERMS'));
				$this->register(JRequest::get('post'));
				return false;
			}		
		}
		
		// Check if referral code (AlphaUserPoints component)		
		if ( $arg_params->def( 'displayreferralcodeAUP', 0 ) ) {		
			$referralexist = '';		
			$referrer = JRequest::getVar('referraluser', '', 'post', 'string');
			$referrer = trim($referrer);			
			if ( $referrer ) {
				$query = "SELECT id FROM #__alpha_userpoints WHERE `referreid`='".$referrer."' LIMIT 1";
				$db->setQuery( $query );
				$referralexist = $db->loadResult();
			}			
			if ( $referrer && !$referralexist ) {
				JError::raiseWarning('', JText::_('ARG_THIS_REFERRAL_CODE_NOT_EXIST'));
				$this->register(JRequest::get('post'));
				return false;	
			}
			// If required...	
			if ( $arg_params->get( 'displayreferralcodeAUP')==2 && !$referrer ) {
				JError::raiseWarning('', JText::_('ARG_YOU_MUST_ENTER_A_REFERRAL_USER_CODE'));
				$this->register(JRequest::get('post'));
				return false;
			}
			if ( $referralexist ) {			
				if ( file_exists(JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php') ) {
					// Start session for AlphaUserPoints plugins system
					@session_start('alphauserpoints');
					$_SESSION['referrerid'] = $referrer;
					// Check if exist an old referrerid with cookies
					if ( isset($_COOKIE['referrerid']) ) {
						setcookie('referrerid','',time()-3600);
						unset($_COOKIE['referrerid']);
					}
				}	
			}			
		} else {		
			@session_start('alphauserpoints');
			$_SESSION['referrerid'] = '';
			if ( isset($_COOKIE['referrerid']) ) {
				setcookie('referrerid','',time()-3600);
				unset($_COOKIE['referrerid']);
			}		
		}
		
		// Check if coupon code (AlphaUserPoints component)
		$couponcode = '';
		$couponexist = '';
		$couponcodelink = '';	
		if ( $arg_params->def( 'displaycouponcodeAUP', 0 )  ) {			
			$couponcode = JRequest::getVar('couponcode', '', 'post', 'string');
			$couponcode = trim($couponcode);
			if ( $couponcode ) {
				$query = "SELECT * FROM #__alpha_userpoints_coupons WHERE `couponcode`='$couponcode' AND (`expires`>='$now' OR `expires`='0000-00-00 00:00:00')";
				$db->setQuery( $query );
				$couponexist = $db->loadObjectList();
			}
			if ( $couponcode && !$couponexist ) {
				JError::raiseWarning('', JText::_('ARG_THIS_COUPON_CODE_IS_NOT_AVAILABLE'));
				$this->register(JRequest::get('post'));
				return false;
			}
			// If required...		
			if ( $arg_params->get( 'displaycouponcodeAUP')==2 && !$couponcode ) {
				JError::raiseWarning('', JText::_('ARG_YOU_MUST_ENTER_A_COUPON_CODE'));
				$this->register(JRequest::get('post'));
				return false;
			}
			
		}		
		
		// Get required system objects
		$user 		= clone(JFactory::getUser());
		$pathway 	=& $mainframe->getPathway();
		$config		=& JFactory::getConfig();
		$authorize	=& JFactory::getACL();
		$document   =& JFactory::getDocument();
		$lang       = $document->getLanguage();

		// If user registration is not allowed, show 403 not authorized.		
		if ($usersConfig->get('allowUserRegistration') == '0') {
			JError::raiseError( 403, JText::_( 'Access Forbidden' ));
			return;
		}

		// Initialize new usertype setting
		$newUsertype = $usersConfig->get( 'new_usertype' );
		if (!$newUsertype) {
			$newUsertype = 'Registered';
		}

		// Bind the post array to the user object
		if (!$user->bind( JRequest::get('post'), 'usertype' )) {
			JError::raiseError( 500, $user->getError());
		}

		// Set some initial user values
		$user->set('id', 0);
		//$user->set('usertype', '');
		$user->set('usertype', $newUsertype);		
		$user->set('gid', $authorize->get_group_id( '', $newUsertype, 'ARO' ));

		$date =& JFactory::getDate();
		$user->set('registerDate', $date->toMySQL());

		// If user activation is turned on, we need to set the activation information
		$useractivation = $usersConfig->get( 'useractivation' );
		if ($useractivation == '1')
		{
			jimport('joomla.user.helper');
			$user->set('activation', JUtility::getHash( JUserHelper::genRandomPassword()) );
			$user->set('block', '1');
			
			// Used by AlphaUSerPoints
			if ( $couponcode && $couponexist ) {
				$couponcodelink = '&couponcode='.$couponcode.'&usr='.$username;
			}
			
		}

		// If there was an error with registration, set the message and display form
		if ( !$user->save() )
		{
			JError::raiseWarning('', JText::_( $user->getError()));
			$this->register(JRequest::get('post'));
			return false;
		}
		
		// If coupon code for AlphaUserPoints is enabled and if user activation is disabled
		if ( $couponcode && $couponexist && $useractivation=='0' )
		{	
		 	$this->getCouponCodePoints( $user->id, $couponcode, $couponexist );
		}
		
		// if birthdate
		if ($birthdate) {
			$this->saveBirthdate( $user->id, $birthdate );
		}
		
		// if gender
		if ( $gender ) {
			$this->saveGender( $user->id, $gender );
		}

		// Send registration confirmation mail
		$password = JRequest::getString('password', '', 'post', JREQUEST_ALLOWRAW);
		$password = preg_replace('/[\x00-\x1F\x7F]/', '', $password); //Disallow control chars in the email
		
		AlpharegistrationController::_sendMail($user, $password, $couponcodelink);
		
		// Purge automatically the users table
		if ( $arg_params->def( 'purge_table_users', 0 ) )
		{
			$query = "DELETE FROM #__users WHERE registerDate <='".$priornow."' AND lastvisitDate='0000-00-00 00:00:00' AND block='1'";
			$db->setQuery( $query );
			$db->query();	
		}
		
		// language specific image folder or default english image files
		$folderstep2 = 'components/com_alpharegistration/assets/images';
		$filenamestep2 = 'stepbystep2.png';
		// importend for the file exists
		$fileroute2 =(JPATH_COMPONENT.DS.'assets'.DS.'images'.DS.''.$lang.''.DS.''.$filenamestep2.'');

		// Everything went fine, set relevant message depending upon user activation state and display message
		if ( $useractivation == 1 ) {
			$message = new stdClass();
			$message->title = JText::_( 'ARG_CONFIRM_YOUR_EMAIL' );
			$message->text = JText::_( 'ARG_CONFIRM_YOUR_EMAIL_TEXT' );
			$message->showLoginForm = '0';
			
			if ( $arg_params->get('displayheaderstep') ) {
				// now choice the Image file
				if (file_exists($fileroute2)) {
					$message->headerIMG = "<img src=\"$folderstep2/$lang/$filenamestep2\" alt=\"\" />";
				} else {
					$message->headerIMG = "<img src=\"$folderstep2/en-gb/$filenamestep2\" alt=\"\" />";
					if ( $arg_params->get( 'enabledMessagesLang' ) ) {
						echo "<dl id=\"system-message\"><dt class=\"error\"></dt><dd class=\"error message fade\"><ul><li><strong>ERROR:</strong><br/>The Language Secific Image $fileroute2 does not exist.<br/>Now we use the English Picture as Standard<br />Info: active Language: $lang<br />Please make a own picture in a Sub Folder in com_alpharegistration/assets/images called $lang and name the file: $filenamestep2</li></ul></dd></dl>";
					}
				}
			} else $message->headerIMG = "";
			
			// include now for the step2 page the header modulespositions
			include_once (JPATH_COMPONENT.DS.'assets'.DS.'modules'.DS.'headermodule2.php');
				
			$view->assign('message', $message);
			$view->display('message');
			
			// include now for the step2 page the footer modulespositions
			include_once (JPATH_COMPONENT.DS.'assets'.DS.'modules'.DS.'footermodule2.php');
			
		} else {
			$message = JText::_( 'REG_COMPLETE' );
			$this->setRedirect('index.php', $message);
		}
		
	}

	function activate()
	{
		global $mainframe;

		// Initialize some variables
		$db			=& JFactory::getDBO();
		$user 		=& JFactory::getUser();
		$document   =& JFactory::getDocument();
		$lang       = $document->getLanguage();
		$pathway 	=& $mainframe->getPathWay();

		$usersConfig = &JComponentHelper::getParams( 'com_users' );
		$userActivation			= $usersConfig->get('useractivation');
		$allowUserRegistration	= $usersConfig->get('allowUserRegistration');
		
		$arg_params = &JComponentHelper::getParams( 'com_alpharegistration' );
		
		JPlugin::loadLanguage( 'com_user' );
		
		$nullDate	= $db->getNullDate();
		$date =& JFactory::getDate();
		$now  = $date->toMySQL();

		// Check to see if they're logged in, because they don't need activating!
		if ($user->get('id')) {
			// They're already logged in, so redirect them to the home page
			$mainframe->redirect( 'index.php' );
		}

		if ($allowUserRegistration == '0' || $userActivation == '0') {
			JError::raiseError( 403, JText::_( 'Access Forbidden' ));
			return;
		}

		// create the view
		require_once (JPATH_COMPONENT.DS.'views'.DS.'register'.DS.'view.html.php');
		$view = new AlpharegistrationViewRegister();

		$message = new stdClass();

		// Do we even have an activation string?
		$activation = JRequest::getVar('activation', '', '', 'alnum' );
		$activation = $db->getEscaped( $activation );

		if (empty( $activation ))
		{
			// Page Title
			$document->setTitle( JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' ) );
			// Breadcrumb
			$pathway->addItem( JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' ));

			$message->title = JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' );
			$message->text = JText::_( 'REG_ACTIVATE_NOT_FOUND' );
			$view->assign('message', $message);
			$view->display('message');
			return;
		}
		
		// Lets activate this user
		jimport('joomla.user.helper');
		if (JUserHelper::activateUser($activation))
		{
			// Page Title
			$document->setTitle( JText::_( 'REG_ACTIVATE_COMPLETE_TITLE' ) );
			// Breadcrumb
			$pathway->addItem( JText::_( 'REG_ACTIVATE_COMPLETE_TITLE' ));
			
			$message->title = JText::_( 'ARG_ACTIVATION_COMPLETE' );
			
			// include now for the step3 page the header modulespositions
			include_once (JPATH_COMPONENT.DS.'assets'.DS.'modules'.DS.'headermodule3.php');

			$message->text = JText::_( 'ARG_ACTIVATION_COMPLETE_TEXT' );			
			
			// language specific image folder or default english image files
			$folderstep3 = 'components/com_alpharegistration/assets/images';
			$filenamestep3 = 'stepbystep3.png';
			// importend for the file exists
			$fileroute3 =(JPATH_COMPONENT.DS.'assets'.DS.'images'.DS.''.$lang.''.DS.''.$filenamestep3.'');
			// now choice the image
			if ( $arg_params->get('displayheaderstep') ) {
				if (file_exists($fileroute3)) {
					$message->headerIMG = "<img src=\"$folderstep3/$lang/$filenamestep3\" alt=\"\" />";
				} else {
					$message->headerIMG = "<img src=\"$folderstep3/en-gb/$filenamestep3\" alt=\"\" />";
					if ( $arg_params->get( 'enabledMessagesLang' ) ) {
						echo "<dl id=\"system-message\"><dt class=\"error\"></dt><dd class=\"error message fade\"><ul><li><strong>ERROR:</strong><br/>The Language Secific Image $fileroute3 does not exist.<br/>Now we use the English Picture as Standard<br />Info: active Language: $lang<br />Please make a own picture in a Sub Folder in com_alpharegistration/assets/images called $lang and name the file: $filenamestep3</li></ul></dd></dl>";
					}
				}
			} else $message->headerIMG = "";
						
			if  ( $arg_params->get('showLoginFormOnLastStep') ) {				
				$message->showLoginForm = true;
			} else $message->showLoginForm = false;
			
			$returnurl = ($arg_params->get('returnurl'))? base64_encode($arg_params->get('returnurl')) : '';
			$message->returnurl = $returnurl;
			$message->usesecure = $arg_params->def('usesecure', 0);			
			
			$couponcode = JRequest::getVar('couponcode', '', 'post', 'string' );
			if ( $couponcode )
			{
				$query = "SELECT * FROM #__alpha_userpoints_coupons WHERE `couponcode`='$couponcode' AND (`expires`>='$now' OR `expires`='0000-00-00 00:00:00')";
				$db->setQuery( $query );
				$couponexist = $db->loadObjectList();
				$username = JRequest::getVar('usr', '', 'post', 'string' );
				$userid = JUserHelper::getUserId($username); 
				if ( $couponexist ) $this->getCouponCodePoints( $userid, $couponcode, $couponexist );
			}
			
		}
		else
		{
			// Page Title
			$document->setTitle( JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' ) );
			// Breadcrumb
			$pathway->addItem( JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' ));

			$message->title = JText::_( 'REG_ACTIVATE_NOT_FOUND_TITLE' );
			
			// include now for the step3 page the header modulespositions
			include_once (JPATH_COMPONENT.DS.'assets'.DS.'modules'.DS.'headermodule3.php');

			$message->text = JText::_( 'REG_ACTIVATE_NOT_FOUND' );
			$message->headerIMG = "";
		}

		$view->assign('message', $message);
		$view->display('message');
		
		// include now for the step3 page the footer modulespositions
		include_once (JPATH_COMPONENT.DS.'assets'.DS.'modules'.DS.'footermodule3.php');

	}

	function _sendMail(&$user, $password, $couponcodelink='')
	{
		global $mainframe;

		$db		=& JFactory::getDBO();

		$name 		= $user->get('name');
		$email 		= $user->get('email');
		$username 	= $user->get('username');

		$usersConfig 	= &JComponentHelper::getParams( 'com_users' );
		$sitename 		= $mainframe->getCfg( 'sitename' );
		$useractivation = $usersConfig->get( 'useractivation' );
		$mailfrom 		= $mainframe->getCfg( 'mailfrom' );
		$fromname 		= $mainframe->getCfg( 'fromname' );
		$siteURL		= JURI::base();

		$subject 	= sprintf ( JText::_( 'Account details for' ), $name, $sitename);
		$subject 	= html_entity_decode($subject, ENT_QUOTES);

		if ( $useractivation == 1 ){
			$message = sprintf ( JText::_( 'SEND_MSG_ACTIVATE' ), $name, $sitename, $siteURL."index.php?option=com_alpharegistration&task=activate&activation=".$user->get('activation').$couponcodelink, $siteURL, $username, $password);
		} else {
			$message = sprintf ( JText::_( 'SEND_MSG' ), $name, $sitename, $siteURL);
		}

		$message = html_entity_decode($message, ENT_QUOTES);

		//get all super administrator
		$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE LOWER( usertype ) = "super administrator"';
		$db->setQuery( $query );
		$rows = $db->loadObjectList();

		// Send email to user
		if ( ! $mailfrom  || ! $fromname ) {
			$fromname = $rows[0]->name;
			$mailfrom = $rows[0]->email;
		}

		JUtility::sendMail($mailfrom, $fromname, $email, $subject, $message);

		// Send notification to all administrators
		$subject2 = sprintf ( JText::_( 'Account details for' ), $name, $sitename);
		$subject2 = html_entity_decode($subject2, ENT_QUOTES);

		// get superadministrators id
		foreach ( $rows as $row )
		{
			if ($row->sendEmail)
			{
				$message2 = sprintf ( JText::_( 'SEND_MSG_ADMIN' ), $row->name, $sitename, $name, $email, $username);
				$message2 = html_entity_decode($message2, ENT_QUOTES);
				JUtility::sendMail($mailfrom, $fromname, $row->email, $subject2, $message2);
			}
		}
	}
	
	function getCouponCodePoints( $userid, $couponcode, $couponexist )
	{
		global $mainframe;
		
		$db		=& JFactory::getDBO();				
	
		$resultCouponExist = 0;
		
		$referrerid = AlphaUserPointsHelper::getAnyUserReferreID($userid);

		// check if public or private coupon
		if ( !$couponexist[0]->public )
		{
			// private -> usable once per one user
			$query = "SELECT count(*) FROM #__alpha_userpoints_details WHERE `keyreference`='$couponcode'";
			$db->setQuery( $query );
			$resultCouponExist = $db->loadResult();
			if ( !$resultCouponExist )
			{
				// insert points
				AlphaUserPointsHelper::newpoints( 'sysplgaup_couponpointscodes', $referrerid, $couponexist[0]->couponcode, $couponexist[0]->description, $couponexist[0]->points, false, 1 );
			} 
			else
			{
				$mainframe->enqueueMessage(JText::_('ARG_THIS_COUPON_WAS_ALREADY_USED'));
			}
		} 
		elseif ( $couponexist[0]->public )
		{
			// public -> usable once per all users
			$keyreference = $couponcode . "##" . $userid;
			$query = "SELECT count(*) FROM #__alpha_userpoints_details WHERE `keyreference`='$keyreference'";
			$db->setQuery( $query );
			$resultCouponExist = $db->loadResult();
			if ( !$resultCouponExist )
			{
				// insert points						
				AlphaUserPointsHelper::newpoints( 'sysplgaup_couponpointscodes', $referrerid, $keyreference, $couponexist[0]->description, $couponexist[0]->points, false, 1 );
			} 
			else 
			{
				$mainframe->enqueueMessage(JText::_('ARG_THIS_COUPON_WAS_ALREADY_USED'));
			}
		} 	
	}
	
	function saveBirthdate( $userid, $birthdate )
	{
		global $mainframe;
		
		$db =& JFactory::getDBO();
		$user = & JFactory::getUser();	
		
		$curdate = date( "Y-m-d" );
		
		if ( $birthdate >= $curdate ) {			
			return;
		}		
	
		$query = "UPDATE #__alpha_userpoints" .
		"\n SET birthdate='$birthdate'" .
		"\n WHERE userid='" . $userid . "'"
		;
		$db->setQuery( $query );
		$db->query();		
	}
	
	function saveGender( $userid, $gender )
	{
		global $mainframe;
		
		$db =& JFactory::getDBO();
		$user = & JFactory::getUser();	
	
		$query = "UPDATE #__alpha_userpoints" .
		"\n SET gender=$gender" .
		"\n WHERE userid='" . $userid . "'"
		;
		$db->setQuery( $query );
		$db->query();	
	}
		
    function date_diff( $date1, $date2, $mode='31557600' ) 
	{			
		//	31557600 = 86400 seconds by day * 365.25
		$p1=explode(" ",date("d m Y H i s",strtotime($date1)));
		$p2=explode(" ",date("d m Y H i s",strtotime($date2)));		
		return (round((mktime($p2[3],$p2[4],$p2[5],$p2[1],$p2[0],$p2[2]) - mktime($p1[3],$p1[4],$p1[5],$p1[1],$p1[0],$p1[2]))/$mode));
    }
	
	function isBotScoutListed( $email, $ip, $arg_params ) {
	
		$apikey = $arg_params->get('botscoutapikey','');
		$email = urlencode($email);
		$querystr = "http://botscout.com/test/?multi&mail=$email&ip=$ip";
		if ($apikey) $querystr .= "&key=$apikey";

		if(function_exists('file_get_contents')) {
			$data = file_get_contents($querystr);
		} else {
			$ch = curl_init($querystr);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$data = curl_exec($ch);
			curl_close($ch);
		}
		$botdata = explode('|', $data);

		// Error (!) or not listed (N) --> return false
		//if ( substr($data, 0, 1) == '!' || substr($data, 0,1) == 'N' ) return false;

		// IP address or email address listed on botscout --> return true
		if ( @$botdata[3] > 0 || @$botdata[5] > 0) {
			return true;
		}
		
		return false;
	}
	
	function getClientIP() {
		//if ($_SERVER["HTTP_X_FORWARDED_FOR"]) return $_SERVER["HTTP_X_FORWARDED_FOR"];
		//if ($_ENV["HTTP_CLIENT_IP"]) return $_ENV["HTTP_CLIENT_IP"];
		if ($_SERVER["REMOTE_ADDR"]) return $_SERVER["REMOTE_ADDR"];
		return '0.0.0.0';
	}


}
?>