<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * @package AlphaUserPoints
 */
class alphauserpointsControllerInvite extends alphauserpointsController
{
	/**
	 * Custom Constructor
	 */
 	function __construct()	{
		parent::__construct( );
	}
	
	function display() 
	{
		global $mainframe;
		
		// active user
		$user = & JFactory::getUser();
				
		if ( $user->id ) {		
			$user_name = $user->name;			
		} else $user_name = "";	
		
		$model      = &$this->getModel ( 'alphauserpoints' );
		$view       = $this->getView  ( 'invite','html' );		
		
		$referrerid = $model->_getReferreid();
		
		$params = $model->_getParamsAUP();
		
		if ( $referrerid )	
		{
			$referrer_link = getLinkToInvite( $referrerid, $params->get('systemregistration')  );
		} else $referrer_link = '';
		
		$view->assign('params', $params );
		$view->assign('user_name', $user_name );
		$view->assign('referreid', $referrerid );	
		$view->assign('referrer_link', $referrer_link );		
		
		// Display
		$view->_display();
	
	}
	
	function sendinvite () 
	{
		global $mainframe;
				
		// active user
		$user = & JFactory::getUser();		
		
		$db	=& JFactory::getDBO();

		jimport( 'joomla.mail.helper' );
		
		$model      = &$this->getModel ( 'alphauserpoints' );
		$view       = $this->getView  ( 'invite','html' );		

		$SiteName 	= $mainframe->getCfg('sitename');
		$MailFrom 	= $mainframe->getCfg('mailfrom');
		$FromName 	= $mainframe->getCfg('fromname');

		$uri        =& JURI::getInstance();
		$base    	= $uri->toString( array('scheme', 'host', 'port'));		
		
		$params = $model->_getParamsAUP();
		
		$referrerid = $model->_getReferreid();
		
		if ( $referrerid )	
		{
			$link = getLinkToInvite( $referrerid, $params->get('systemregistration') );
		} else $link = '';		
		
		if ( $params->get( 'userecaptcha' ) ) {				
			require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'assets'.DS.'recaptcha'.DS.'recaptchalib.php');	
			$privatekey = $params->get( 'privkey' );
			
			// the response from reCAPTCHA
			$resp = null;
			// the error code from reCAPTCHA, if any
			$error = null;
			
			// was there a reCAPTCHA response?
			$recaptcha_response_field = JRequest::getVar('recaptcha_response_field', '', 'post', 'string');
			
			//if ($_POST["recaptcha_response_field"]) {
			if ( $recaptcha_response_field ) {
					$resp = recaptcha_check_answer ($privatekey,
													$_SERVER["REMOTE_ADDR"],
													$_POST["recaptcha_challenge_field"],
													//$_POST["recaptcha_response_field"]);
													$recaptcha_response_field);
			
					if (!$resp->is_valid) {
						// set the error code so that we can display it
						$error = $resp->error;
						JError::raiseWarning(0, $error );
						return $this->display ();
					}
			} else {
					JError::raiseWarning(0, 'Captcha' );
					return $this->display ();
			}

		}

		// An array of e-mail headers we do not want to allow as input
		$headers = array (	'Content-Type:',
							'MIME-Version:',
							'Content-Transfer-Encoding:',
							'bcc:',
							'cc:');

		// An array of the input fields to scan for injected headers
		$fields = array ('mailto',
						 'sender',
						 'from',
						 'subject',
						 );

		/*
		 * Here is the meat and potatoes of the header injection test.  We
		 * iterate over the array of form input and check for header strings.
		 * If we fine one, send an unauthorized header and die.
		 */
		foreach ($fields as $field)
		{
			foreach ($headers as $header)
			{
				if (strpos(@$_POST[$field], $header) !== false)
				{
					JError::raiseError(403, '');
				}
			}
		}

		/*
		 * Free up memory
		 */
		unset ($headers, $fields);
		
		$imported_emails	= $_POST['importedemails'];
		$other_emails		= JRequest::getString('other_recipients', '', 'post');
		$sender 			= JRequest::getString('sender', '', 'post');
		$custommessage		= JRequest::getString('custommessage', '', 'post');
		
		$subject		 	= JText::_( 'AUP_YOUAREINVITEDTOREGISTERON' ) . " " . $SiteName;
		
		// Check for a valid to address
		$errorMail	= false;		
				
		// build list emails
		if($imported_emails=='' && $other_emails!='') {
			$emails = $other_emails;
		} elseif($other_emails=='' && $imported_emails!='') {
			$emails = $imported_emails;
		} elseif ( $imported_emails!='' && $other_emails!='') {
			$emails = $imported_emails . "," . $other_emails;
		} else {
			$emails = "";
			$errorMail	=  JText::_( 'AUP_EMAIL_INVALID' );
			JError::raiseWarning(0, $errorMail );
		}
	
		$emails = @explode( ',', $emails );

		// Check for a valid from address
		if ( ! $MailFrom || ! JMailHelper::isEmailAddress($MailFrom) )
		{
			$errorMail	= JText::sprintf('AUP_EMAIL_INVALID', $MailFrom);
			JError::raiseWarning(0, $errorMail );
		}

		if ( $errorMail ) return $this->display ();

		// Build the message to send
		$msg	= JText :: _('AUP_EMAIL_MSG_INVITE');
		$body	= sprintf( $msg, $SiteName, $sender, $link) . " \n" . $custommessage;

		// Clean the email data
		$subject = JMailHelper::cleanSubject($subject);
		$body	 = JMailHelper::cleanBody($body);
				
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
		
		// Limit
		$max 		= $params->get( 'maxemailperinvite'   );
		$maxperday  = $params->get( 'maxinvitesperday'    );
		$delay 		= intval($params->get( 'delaybetweeninvites' ));
		
		$counter 	= 0;
		
		$rule_ID = $model->_getRuleID ( 'sysplgaup_invite' );
		
		$numpoints4invite = AlphaUserPointsHelper::getPointsRule( 'sysplgaup_invite' );
		$totalpointsearned= 0;
		
		$currentmaxperday = $model->_checkCurrentMaxPerDay( $rule_ID, $user->id, $referrerid, $_SERVER["REMOTE_ADDR"] );
		
		$checkdelay = 1;
		if ( $delay ) {
			$checkdelay = $model->_checkLastInviteForDelay( $rule_ID, $user->id, $referrerid, $_SERVER["REMOTE_ADDR"], $delay );
		}
		
		if ( !$checkdelay ) {
			$errorTime = JText :: _('AUP_DELAY_BETWEEN_INVITES_INVALID');
			JError::raiseWarning(0, $errorTime );
			return $this->display ();
		} 
				
		if ( $currentmaxperday < $maxperday ) {
			foreach ($emails as $email) {
				$aEmails[0] = $model->_extractEmailsFromString($email);
				$email= $aEmails[0][0];
				if ( JMailHelper::isEmailAddress($email) ) {
					$mailer =& JFactory::getMailer();
					$mailer->setSender( array( $MailFrom, $FromName ) );
					$mailer->setSubject( $subject);
					$mailer->setBody($body);
					$mailer->addRecipient( $email );					
					if ( $mailer->Send() === true ) {
						if ( $user->id ) {				
							if ( AlphaUserPointsHelper::checkRuleEnabled('sysplgaup_invite') ) {						
								// insert email for tracking
								$email2 = str_replace("@" ," [at] ", $email); // change @ because can be display on frontend in latest activity
								AlphaUserPointsHelper::userpoints( 'sysplgaup_invite', '', 0, $email, $email2  );
								$totalpointsearned = $totalpointsearned + $numpoints4invite;
							}
						} else {
							// guest user : Insert IP and email for future tracking
							AlphaUserPointsHelper::insertUserPoints( 'GUEST', 1, '', $rule_ID, 0, $_SERVER["REMOTE_ADDR"].' - '.$email, $email );
						}
						$counter++;
						$currentmaxperday++;
					}
					if ( $counter==$max || $currentmaxperday==$maxperday )	break;
				}
			}
			if ( $totalpointsearned ) $mainframe->enqueueMessage( sprintf ( JText::_('AUP_CONGRATULATION'), $totalpointsearned ));			
		} else {
			$maxperdaylimit = JText :: _('AUP_MAXINVITESPERDAY') . " " . $maxperday ;
			JError::raiseWarning(0, $maxperdaylimit );
			return $this->display ();						
		}	
		
		$view->assign('params', $params );
			
		// Display
		$view->_display_sent( $counter );
	}

}
?>