<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

/**
 * HTML View class for AlphaUserPoints Invite
 *
 * @package	AlphaUserPoints
 */
class alphauserpointsViewInvite extends JView
{

	function _display($tpl = null) {		
		global $mainframe;
		
		$document	= & JFactory::getDocument();
		$lang       = $document->getLanguage();	
		
		$displ = "view";
		$points = 0;
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');		
		$result = AlphaUserPointsHelper::checkRuleEnabled('sysplgaup_invite');
		if ( $result ) $points = $result[0]->points;		
	
		JHTML::_('behavior.formvalidation');
		
		// reCaptcha script
		if ( $this->params->get( 'userecaptcha', 1 ) ) {	
			if ( $this->params->get( 'recaptchaajax ', 0 ) ) {			
				$document->addScript( "http://api.recaptcha.net/js/recaptcha_ajax.js" );			
				$paramsReCaptcha = "
					window.onload = function () {
					Recaptcha.create('". $this->params->get( 'pubkey' )."',
					'recaptcha_div', {
					 theme: '". $this->params->get( 'themerecaptcha', 'red' )."',
					 callback: Recaptcha.focus_response_field
					});
					}"
				;
			} else {			
				$paramsReCaptcha = "
				var RecaptchaOptions = {
				   theme : '". $this->params->get( 'themerecaptcha', 'red' )."',
				   lang  : '". substr($lang, 0, 2)."'
				};
				";						
			}
			$document->addScriptDeclaration($paramsReCaptcha, '');
		}
			
		$this->assignRef( 'params', $this->params );
		$this->assignRef( 'referreid', $this->referreid );		
		$this->assignRef( 'points', $points );		
		$this->assignRef( 'displ', $displ );
		$this->assignRef( 'referrer_link', $this->referrer_link );		
		
		parent::display($tpl);
		
	}		
	
	
	function _display_sent( $counter = 0, $tpl = null ) {		
		global $mainframe;
		
		$displ = "sent";
		$message = "";

		switch ( $counter ) {		
			case '0':
				$message = JText :: _('AUP_NO_EMAIL_HAS_BEEN_SENT');				
				break;				
			case '1':
				$message = JText :: _('AUP_EMAIL_SENT');				
				break;			
			default:
				$message = JText :: _('AUP_EMAILS_SENT');
				$message = sprintf( $message, $counter);
				break;				
		}
		
		$this->assignRef( 'displ', $displ );	
		$this->assignRef( 'params', $this->params );	
		$this->assignRef( 'message', $message );
		
		parent::display($tpl);
		
	}
	
}
?>