<?php 
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view');

class NinjamonialsViewAdd extends JView
{
	function display($tpl = null)
	{
		
	//Get our component parameters
		$paramsObj = JComponentHelper::getParams( 'com_ninjamonials' );
		$this->assignRef('paramsObj', $paramsObj);
		
		$Itemid = JRequest::getCmd( 'Itemid', '');
		$this->assignRef('Itemid', $Itemid);
		
	//initialise the user object so we can check it for the autofill of username
		$user = JFactory::getUser();
		
	//get the document so we can load stylesheets and javascript to it if needed
		$document = JFactory::getDocument();
		
	//We need to make sure this is loaded for our plugin calls later	
		JPluginHelper::importPlugin( 'ninjamonials' );
		$dispatcher = JDispatcher::getInstance();
		$this->assignRef('dispatcher', $dispatcher);
		
	//used to add the link at the bottom of the page
		$showAllLink = JRoute::_(JFilterOutput::ampReplace( 'index.php?option=com_ninjamonials&controller=testimonials&task=display&Itemid='.$Itemid));
		$this->assignRef('showAllLink', $showAllLink);
		
	//put our component parameters into references for our template
		$this->assignRef('use_captcha', $paramsObj->get('use_captcha'));
		$this->assignRef('recaptcha_pub_key', $paramsObj->get('recaptcha_pub_key'));
		$this->assignRef('use_text', $paramsObj->get('use_text'));
		$this->assignRef('use_summary', $paramsObj->get('use_summary'));
		$this->assignRef('use_website', $paramsObj->get('use_website'));
		$this->assignRef('link_website', $paramsObj->get('link_website'));		
		$this->assignRef('use_title', $paramsObj->get('use_title'));
		$this->assignRef('use_location', $paramsObj->get('use_location'));
		$this->assignRef('use_email', $paramsObj->get('use_email'));
		$this->assignRef('use_avatar', $paramsObj->get('use_avatar'));
		$this->assignRef('use_audio', $paramsObj->get('use_audio'));
		$this->assignRef('use_video', $paramsObj->get('use_video'));
		$this->assignRef('show_all', $paramsObj->get('show_all'));
		$this->assignRef('enable_bbcode', $paramsObj->get('enable_bbcode'));
		$this->assignRef('enable_emoticons', $paramsObj->get('enable_emoticons'));		
		$this->assignRef('form_description', $paramsObj->get('form_description'));
		
		$this->assignRef('show_page_title',$paramsObj->get('show_page_title', 1)); 
		$this->assignRef('page_title',$paramsObj->get('page_title'));
		$this->assignRef('pageclass_sfx',$paramsObj->get('pageclass_sfx'));
		
	//Prepare Category Information
	//we want to know if categories are enabled
		$this->assignRef('enable_categories', $paramsObj->get('enable_categories'));
		
		$catDispStyle =  $paramsObj->get('cat_display_style');
		$this->assignRef('cat_display_style',$catDispStyle);
		
		$catToDisp = $paramsObj->get('cat_to_display');
	
	//Get the category list
		$db = JFactory::getDBO();
		
		$db->setQuery( "SELECT id as catid, name FROM #__nmls_categories
						ORDER BY name");
		$catsRows = $db->loadObjectList();
	
	//check if we were sent a category.
		$category = JRequest::getVar('category_id', null);
		
	//only use the $catToDisp value to set the list default if we using style 2 or 3
	//otherwise use the url category_id or nothing if it isn't set.
		if ($category === null && ($catDispStyle == 2 || $catDispStyle == 3))
		{
			$category = $catToDisp;
		}
		
		$this->assignRef('default_cat', $category);
		
		$cats_list= '<select name="category_id" id="category_id">
					 <option value="0">'.JText::_('None').'</option>';
	
		foreach ($catsRows as &$catsRow) {
			
		//if this item was already selected then highlight it
			if ($catsRow->catid == $category){				
				$selected = ' selected="selected" ';				
			} else {
				$selected = '';
			}
			
			$cats_list.= '<option '.$selected.'value="'.$catsRow->catid.'">'.$catsRow->name.'</option>';
		}
		
		$cats_list.= '</select>';
	
		$this->assignRef('cats_list', $cats_list);
		
		
	//If our Autofill User Real Names parameter is set to yes, and our user actually has a name
	//store the name for use on the form (users can update the name if they wish)
		if ($paramsObj->get('auto_fill') && $user->name )
		{
			$author_name = $user->name;			
		} else {
      $author_name  = '';
    }
		
	//If the user is logged in and has an id record it 
		if ($user->id)
		{		
			$this->assignRef('author_id', $user->id);
		}
				
		//Process whatever scripts we need		
		//set the base location from which our css and js files will branch
			$mediadir = JURI::base(true).'/media/com_ninjamonials';
			$this->assignRef('mediadir', $mediadir);
			
		//load the chosen css file if requested
			if ($paramsObj->get('load_css',''))
			{
				$cssFile = $mediadir.'/css/'.$paramsObj->get('which_css').'/'.$paramsObj->get('which_css').'.css';
				$document->addStyleSheet($cssFile, 'text/css', null, array());
			}
			
			
		//load the recaptcha helper if captcha is requested
			if ($paramsObj->get('use_captcha')) {
				require_once(JPATH_COMPONENT.DS.'helpers'.DS.'recaptchalib.php');
				$document->addScriptDeclaration(" var RecaptchaOptions = {theme : 'clean' }; ");
			}
			
		//This is for our tooltipe, but they only work with moo but our bbcode editor uses JQ, so we can't have the tips loading on the same page as the bbcode editor. This needs to change asap
			if (!$this->enable_bbcode){ 
				$tips = "window.addEvent('domready', function(){ var JTooltips = new Tips($$('.hasTip'), { maxTitleChars: 50, fixed: false}); });";
				$document->addScriptDeclaration($tips);
			}
			
			/*if I want to add tooltips to this later use the code below
			$tips = "window.addEvent('domready', function(){ var JTooltips = new Tips($$('.hasTip'), { maxTitleChars: 50, fixed: false}); });";
			$document->addScriptDeclaration($tips);
			
			<span class="editlinktip"><label id="paramsuse_avatar-lbl" for="paramsuse_avatar" class="hasTip" title="Collect Author Avatars?::Do you want to collect an avatar image from users?">Collect Author Avatars?</label></span>
			*/
			
			if ($this->use_text && ($this->enable_bbcode)){ 
			//Show our bbcode buttons if enabled and we are doing a full text box.
				$document->addStylesheet($mediadir.'/js/markitup/skins/simple/style.css');
				$document->addStylesheet($mediadir.'/js/markitup/sets/bbcode/style.css');
		
				$document->addScript($mediadir.'/js/jquery-1.3.1.min.js');
				$document->addScript($mediadir.'/js/markitup/jquery.markitup.pack.js');
				$document->addScript($mediadir.'/js/markitup/sets/bbcode/set.js');
				
				$init = '	$j = jQuery.noConflict();
				
							$j(document).ready(function(){
							
								$j("#testimonial").markItUp(mySettings);
						';
						
				//This allows for disabling emoticons
				//Note that emoticon use requires bbcode to be enabled also.
				if ($this->enable_emoticons) {
					$init .= ' 
								$j("#nj-emoticons a").click(function() {
							        emoticon = $j(this).attr("title");
							        $j.markItUp( { replaceWith:emoticon } );
									return false;
							    });
							';
				}
				
				$init .= '});';			
						
				$document->addScriptDeclaration($init);
			
			}
		
    $row = new stdClass;
    $mainframe = JFactory::getApplication();
    // store the current field data so we can post it back to the page if needed  (e.g. file or recaptcha error)
    $row->testimonial = $mainframe->getUserState( "com_ninjamonials.testimonial" );
    $row->summary = $mainframe->getUserState( "com_ninjamonials.summary");
    $row->author_name = $mainframe->getUserState( "com_ninjamonials.author_name", $author_name );
    $row->author_title = $mainframe->getUserState( "com_ninjamonials.author_title" );
    $row->author_location = $mainframe->getUserState( "com_ninjamonials.author_location");
    $row->author_email = $mainframe->getUserState( "com_ninjamonials.author_email");
    $row->website_text = $mainframe->getUserState( "com_ninjamonials.website_text");
    $row->website_url = $mainframe->getUserState( "com_ninjamonials.website_url");
    
    $this->assignRef('row', $row);
				
		parent::display($tpl);
	}
}

?>
