<?php
/**
* @version		$Id: mod_alphauserpoints_monthly_stats.php 2009-02-08 v1.0.1 $
* @package		AlphaUserPoints for Joomla
* @copyright	Copyright (C) 2008-2009. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class modAlphaUserPointsMonthlyStatsHelper {

	function getList($searchdate, &$params) {
		global $mainframe;

		$db			      =& JFactory::getDBO();
		
		// exclude specific users of this list
		$excludeuser = array();		
		$excludeusers = "";
		$query = "SELECT exclude_items FROM #__alpha_userpoints_rules WHERE `plugin_function`='sysplgaup_excludeusers' AND `published`='1'";
		$db->setQuery( $query );
		$result  = $db->loadResult();		
		if ( $result ) {		
			$excludeuser = explode( ",", $result);
			for ($i=0, $n=count($excludeuser); $i < $n; $i++) {		
				$excludeusers .= " AND aup.referreid!='" . trim($excludeuser[$i]) . "'";
			}			
		}
				
		$count		      = intval($params->get('count', 5));
		$showheader		  = intval($params->get('showheader', 1));
		$showleaderboard  = intval($params->get('showdate', 1));
		$usrname		  = trim($params->get('usrname', 'name'));
	
		$query = "SELECT a.referreid, SUM(a.points) AS sumpoints, u.$usrname AS usrname, aup.userid AS userID"
			   . " FROM #__alpha_userpoints_details AS a, #__alpha_userpoints AS aup, #__users AS u"
			   . " WHERE aup.referreid=a.referreid AND aup.userid=u.id AND a.approved='1' AND a.status='1' AND a.points>=1"
			   . $excludeusers
			   . " AND a.insert_date LIKE '$searchdate%'"
			   . " GROUP BY a.referreid "
			   . " ORDER BY sumpoints DESC"
			   ;
			   

		$db->setQuery($query, 0, $count);
		$rows = $db->loadObjectList();
	
		return $rows;
	
	}
	
	function getCurrentMonthList($selectmonth, &$params) {
		$curr_month = date("m");
		$current_year = date("Y");
		
		$month = array (1=>JText::_('JANUARY'), JText::_('FEBRUARY'), JText::_('MARCH'), JText::_('APRIL'), JText::_('MAY'), JText::_('JUNE'), JText::_('JULY'), JText::_('AUGUST'), JText::_('SEPTEMBER'), JText::_('OCTOBER'), JText::_('NOVEMBER'), JText::_('DECEMBER'));
		$select = "<select name=\"mod_aup_ms_month\" id=\"mod_aup_ms_month\" class=\"inputbox".$params->get( 'pageclass_sfx' )."\" size=\"1\" onchange=\"document.forms['frmModAUPMS'].submit();\">\n";
		
		if ( $curr_month==1 ) {		
			$previousmonth = 12;
			$previousyear = $current_year - 1;		
		} else {		
			$previousmonth = $curr_month - 1;
			$previousyear = $current_year;
		}
		
		$select .= "\t<option value=\"".$curr_month."\"";
		if ($curr_month == $selectmonth) {
			$select .= " selected>".JText::_('MODAUP_MS_CURRENT_MONTH');
		} else {
			$select .= ">".JText::_('MODAUP_MS_CURRENT_MONTH');
		}
		$select .= "</option>\n";
		$select .= "\t<option value=\"".$previousmonth."\"";
		if ($previousmonth == $selectmonth) {
			$select .= " selected>".$month[$previousmonth];
		} else {
			$select .= ">".$month[$previousmonth];
		}
		$select .= "</option>\n";
		/*
		foreach ($month as $key => $val) {
			$select .= "\t<option val=\"".$key."\"";
			if ($key == $curr_month) {
				$select .= " selected>".$val."\n";
			} else {
				$select .= ">".$val."\n";
			}
		}
		*/
		$select .= "</select>";
		$select .= "<input type=\"hidden\" name=\"mod_aup_ms_current_year\" value=\"$current_year\"/>";
		$select .= "<input type=\"hidden\" name=\"mod_aup_ms_previousyear\" value=\"$previousyear\"/>";
		
		return $select;
	}
}
?>