<?php
/**
 * @version		$Id: mod_ninja_3d_carousel.php 1445 2009-09-17 14:34:40Z stian $
 * @category	Ninja 3D Carousel
 * @copyright	Copyright (C) 2007 - 2009 NinjaForge. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://ninjaforge.com
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

//Prepare module identificator
$id = $module->name.$module->id;

//Get the images
$i = 0;
$rel = $params->get('shadowbox') ? 'shadowbox' : null;
foreach (explode("\n", $module->params) as $param)
{
	if (strpos($param, 'src') !== 0) continue;
	if ($src = $params->get('src'.$i, null)) $srcs[$i] = $src;
	$links[$i] = $params->get('href'.$i, '#');
	$titles[$i] = current(explode('::', $params->get('title'.$i, null)));
	$rels[$i] = $params->get('rel'.$i) ? $params->get('rel'.$i) : $rel;
	$tips[$i] = $params->get('tooltip') ? 'class="hasTip" title="' . $params->get('title'.$i, null) . '"' : null;
	$i++;
}

//Get styles
$style = array();
if ($w = $params->get('width', '100%')) 	$style[] = 'width:' . $w . ';';
if ($h = $params->get('height', 400)) 	$style[] = 'height:' . $h . 'px;';
$styles = implode('', $style);

//Prepare JFile
jimport('joomla.filesystem.file');

//Prepare header script
$scripts['center'] 		= (object) array(
	'x' => (int) $params->get('centerx', 300), 
	'y' => (int) $params->get('centery', 190)
);
$scripts['radius']		= (object) array(
	'x' => (int) $params->get('radiusx', 190),
	'y' => (int) $params->get('radiusy', 40)
);
$scripts['selector']	= (string)	$id;
$scripts['rpm']  		= (int)	$params->get('rpm', 3);

$script = new JObject;
$script->setProperties($scripts);

$script = json_encode($script->getProperties());

//Prepare url to script
$mediaurl = (object) array('script' => JURI::root().'media/'.$module->module.'/js/', 'style' => JURI::root().'media/'.$module->module.'/css/');

JFactory::getDocument()->addScriptDeclaration('window.addEvent(\'domready\', function(){ new N3DCarousel('.$script.'); });');

//Render module
require JModuleHelper::getLayoutPath($module->module, 'default');