<?php
/**
 * @version		$Id$
 * @package		NinjaShadowPanel
 * @copyright	Copyright (C) 2009 NinjaForge. All rights reserved.
 * @license 	GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://ninjaforge.com
 * @author Richie Mortimer & Uwe Walter
 */

 // Ensure this file is being included by a parent file. 
defined ( '_JEXEC' ) or die( 'No Direct Access' );

class ModNinjaShadowPanelHelperDefault
{
  
  /****
* Write a script to the header
****/
  public function addStyleSheet ($file) {    
    $document =& JFactory::getDocument();
		$document->addStyleSheet($file);
  }
  
/****
* Write a script to the header
****/
  public function addStyleDeclaration ($style) {   
    $document =& JFactory::getDocument();
    $document->addStyleDeclaration($style);
  }
  
/****
* Write a script to the header
****/
  public function addScript ($file) {
    $document =& JFactory::getDocument();
    $document->addScript($file);
  }
  
/****
* Write a script to the header
****/
  public function addScriptDeclaration ($script) {
  		$document =& JFactory::getDocument();
  		$document->addScriptDeclaration($script);
  }

/****
* Return base url
****/
  public function getLiveSite(){
    return JURI::root();
  }
  
/****
* Return base path
****/
  public function getAbsolutePath(){
    return JPATH_SITE;
  }

/****
* Return base path for a module
****/
  public function getModulePath($moduleName){
    return JPATH_SITE.DS.'modules'.DS.$moduleName.DS.$moduleName;
  }
  
/****
* Retrieve the details of a specific module from their id 
****/
	public function getModDets( $id ) {
			//We need the databaseloaded to do our query
			$database   	= &JFactory::getDBO();
			$where			= self::getAccess();
		
			$query    = "SELECT *" 
						. "\n FROM #__modules AS m"
						. "\n where m.id = '" . $id . "' "
						. "\n AND m.client_id != 1 "
						. $where  ;

            $database->setQuery( $query );
            $modDets  = $database->loadObjectList();
		 
		 if ($modDets)
			return $modDets[0];
	
	}//getModDets public function
	
/**** 
* Render a particular module inside another module (or component etc.) 
****/
	public function getModBody( $module ) {
		//echo ''; //for some reason
		//our custom modules in J1.0, mambo and mia don't have a mod_ prefix
		//they should also be the only modules with content so we can double check these
		if ($module->content || $module->module == 'mod_custom'){
		
			echo($module->content);
		
		} else { //its not a custom module
				
			//create a new $params object so we get the right information to our module
			$params = new JParameter( $module->params );
			
			//Strip any slashes from our name so we can find the html file for it 
			$module->module      = str_replace( '/', '', $module->module );
			$module->module      = str_replace( '\\', '', $module->module );
			
			$lang = & JFactory :: getLanguage();
			$lang->load($module->module, JPATH_ADMINISTRATOR);
			
			//set the path to our module's primary file
			$path      = JPATH_SITE. DS .'modules'.DS.$module->module.DS.$module->module.'.php';
			 
			//Once we have the path load the module   
				if ( file_exists( $path ) ) {
					require $path;
				}
		}
	
	}//getModBody public function
	
	
/**** 
* Get the sufix for the contained modules 
****/
	public function getModSuffix( $module ) {
				//create a new $params object so we get the right information to our module
			$params = new JParameter( $module->params );
			
			return $params->get( 'moduleclass_sfx');
				
	}
	
/**** 
* Include mootools if requested 
****/
	public function includeMootools( $inc_mootools, $mooFileLoc ) {
		$document =& JFactory::getDocument();

		//Include mootools if requested 
		//Because Joomla 1.5 runs all etensions in what is effectively their own process before outputting them to the buffer, 
		//we can't read the buffer to see if mootools is already loaded. Instead, consider 'auto' in J1.5 to be the same as yes.         
		if ( $inc_mootools == 1 || $inc_mootools == 2 )
			$document->addScript($mooFileLoc);
	}
	
/**
* Get user data
*
* @param int user id
*/
  public function getUser($uid = null){
    $user = &JFactory::getUser();
    return $user;
  }

/**
* Get a user's group data
*
* @param int user id
*/
  	public function getGroup($user){
		
		//We need to access the $acl global variable to check permissions
		$user = &JFactory::getUser();
		
		//$user contains user information, $acl contains account level information
		$myRealGid = $user->gid;
		// For standard Joomla groups
		// $myRealGid = 18 - Registered
		//		19 - Author
		//		20 - Editor
		//		21 - Publisher
		//		23 - Manager
		//		24 - Administrator
		//		25 - Super Administrator   
		
		return $myRealGid;
	}
	
	/**
	 * get the access level of the user
	 *
	 * @author 		Richie Mortimer <richie@ninjaforge.com>
	 * @return 		returns users access level
	 */
	 public function getAccess(){
	 
	 	$user 		= &JFactory::getUser();
	 	$group 		= self::getGroup($user);
	 	$where		= '';
	 	
	 	if (!$group)
	 		$where = 'AND m.access = 0';
	 	elseif ($group == 18)
	 		$where = 'AND m.access <= 1';
	 		
	 	return $where;
	 	
	 }
    
} //class declaration