<?php
/**
 * @version		$Id$
 * @package		NinjaShadowPanel
 * @copyright	Copyright (C) 2009 NinjaForge. All rights reserved.
 * @license 	GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://ninjaforge.com
 * @author Richie Mortimer & Uwe Walter
 */

 // Ensure this file is being included by a parent file. 
defined ( '_JEXEC' ) or die( 'No Direct Access' );

class ModNinjaShadowPanelViewDefault
{

	function display($params, $module) {
		
    //where is our module located,used for file references later
    $module_base  = ModNinjaShadowPanelHelperDefault::getLiveSite(). 'modules'.DS.'mod_ninja_shadow_panel';
		
		//grab the parameterss
		$inc_css	= $params->get( 'inc_css','1' );
		$forceValid = $params->get( 'forceValid','0' );
		$modIDs		= $params->get( 'modIDs' );
		$bgcolor	= $params->get( 'bgcolor' );
		$spheight	= $params->get( 'spheight' ); 
		$spwidth	= $params->get( 'spwidth' );
		$sptitle	= $params->get( 'sptitle' );
		$splink		= $params->get( 'splink' );
		
		//Explode the modIDs variable so we can count how many ids we have.
		$modIDArray = explode( ",", $modIDs );
		
		//Count the number of array elements - the number of modules to display
		$IDCount = count( $modIDArray );
		
		// Get this module's id to use as a unique identifier.
		// This allows us to have multiple instances on the one page.
		// We also use it to reset the module parameters later
		$thisID = $module->id;
		
if ($inc_css){
	//link in the CSS if it hasnt been already
	ModNinjaShadowPanelHelperDefault::addStyleSheet(JURI::root().DS.'media'.DS.'mod_ninja_shadow_panel'.DS.'css'.DS.'default.css');
	//and include the css we need thats based on user params
	ModNinjaShadowPanelHelperDefault::addStyleDeclaration('
	#shadowbox_body_inner {
		background-color: '.$bgcolor.' !important;
	}');
}
                       
?>	
<div>	 		
<a href="#shadow<?php echo $thisID;?>" title="<?php echo Jtext::_($sptitle);?>" class="option shadow<?php echo $thisID;?>" rel="shadowbox;width=<?php echo $spwidth;?>;height=<?php echo $spheight;?>;options={enableKeys:false}"><span id="spspan"><?php echo Jtext::_($splink); ?></span></a>
<div class="sphidden" id="shadow<?php echo $thisID;?>">
	<div class="spinner" id="spbody-<?php echo $thisID;?>">
	<?php 
		// Loop through the list of items
        // We say less than the count (and not less than equal to) and start at 0 because that is how php handles arrays, the first element has an index of 0
        for ( $i=0; $i < $IDCount; $i++ ) {
			$module = ModNinjaShadowPanelHelperDefault::getModDets( $modIDArray[$i] );
				if ( $module ) { ?>	
				<div><div><?php	ModNinjaShadowPanelHelperDefault::getModBody( $module); ?></div></div>
				<? }
				} //for ($i=0; $i<$IDCount; $i++) ?>
	</div>
	</div>
</div>
<?php
}
}