<?php

defined('_JEXEC') or die('Restricted access');

class modNinjaMonialsHelper
{
	function getTestimonials(&$params)
	{
		$rotate = $params->get('rotate', 1);
		
	//choose which sub function to call based on if it's static or random testimonials
		if ($rotate){
			$rows = modNinjaMonialsHelper::ninjamonialsProcessDBRandom($params);
		} else {
			$rows = modNinjaMonialsHelper::ninjamonialsProcessDBFixed($params);
		}
		
		return $rows;
		
	}
	
/* @ninjamonialsProcessDBRandom
* Generate a random list of testimonials. 
* @$params - the module parameters                
*/
  	function ninjamonialsProcessDBRandom($params){
  	
  		$testimCount = $params->get('testimCount', 1);
		$db =& JFactory::getDBO();  
  
  		$query = 'SELECT * FROM #__ninjamonials WHERE published = 1';
		
		if ($params->get('catIDs', null)){
			$query .= ' AND category_id in ('.$params->get('catIDs').')';
		}
  
  		$db->setQuery($query);
  		$rows = $db->loadObjectList();
  		$count = count($rows);
  		
      //if we ask for more testimonials than are in the DB then only attempt to 
      //show the actual number of db records available
      if ($count <  $params->get('testimCount'))
          $displayCount = $count;
      else
          $displayCount = $params->get('testimCount');
          
      //initialise an array to store the list of testimonials already used
      $usedArray = array();
      $returnRows = array();
      
      
      for ($i=0; $i<$displayCount; $i++){
      
        //Generate a random number between 0 and the number of testimonials
        //in $rows
      		$currID = rand(0,$count-1);
      
        //if the random number generated hasn't already been used 
          if ( !in_array($currID,$usedArray)) { 
          
              $usedArray[] = $currID;
          	  $returnRows[] = $rows[$currID];
          	  
          } else {
          //if we already used this testimonial then loop again and get a new testimonial
            $i = $i -1;
          }
  		}//for loop
  		
  		return $returnRows;
  	}
  
/* @ninjamonialsProcessDBFixed
* Generate a specific list of testimonials from the parameters entered. 
* @$params - the module parameters                
*/
  	function ninjamonialsProcessDBFixed($params){
  		$db =& JFactory::getDBO();  
  
  		$query = 'SELECT * FROM #__ninjamonials
  				WHERE published = 1
  				AND id IN ('.$params->get('fixedID').')';
    
  		$db->setQuery($query);
  		$rows = $db->loadObjectList();  
  		
  		return $rows;
      
  	}
	
	function renderReadMore(&$id)
	{
		$link = JRoute::_('index.php?option=com_ninjamonials&controller=testimonials&task=display&tmid='.$id);
		require(JModuleHelper::getLayoutPath('mod_ninjamonials', '_readmore'));
	}
}
?>