<?php
/* 
* Ninja Ezee Accordion
* By Daniel Chapman
* http://www.ninjoomla.com 
* Copyright (C) 2008 Daniel Chapman www.ninjoomla.com - Code so sharp, it hurts.
* email: support@ninjoomla.com
* date: June 2008
* Release: 2.0
* Code License : http://www.gnu.org/copyleft/gpl.html GNU/GPL 
*/
###################################################################
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  0211
###################################################################



// Ensure this file is being included by a parent file. 
defined ( '_NFEXEC' ) or die( 'Direct Access to this location is not allowed.' );

class mod_ninja_access_mod_HTML {

	function showModuleHTML($params) {
		
		// Get parameters we need for the view
		// Individual parameters were chosen instead of a list to allow multiple 
		// levels of user access
		$modIDs = $params->get( 'modIDs' );
		$module_tag = $params->get( 'module_tag' );	
		$div_count = $params->get( 'div_count' );
		
		//Explode the modIDs variable so we can count how many ids we have.
		$modIDArray = explode( ",", $modIDs );
		
		//Count the number of array elements - the number of modules to display
		$IDCount = count( $modIDArray );

		for ( $i=0; $i < $IDCount; $i++ ) {
		
			$module = nf_helper_funcs::getModDets( $modIDArray[$i] );
		
			//only grab the module if it exists
			if ( $module ) {
			
				//Lets put a div, a module class, and an optional suffix around these 
				//to allow for a small measure of styling options
				echo '<div class="'.$module_tag.nf_helper_funcs::getModSuffix($module).'">';
				  
				//if requested, put 3 more divs around the modules for styling
				if ($div_count)
					  echo '<div><div><div>';
				  
				if ($module->showtitle) {
					  echo '<h3>'.$module->title.'</h3>';
				}
				
				nf_helper_funcs::getModBody( $module );
								  
				//close the open divs
				echo '</div>';
				  
				//if reuqested close the 3 extra styling divs
				if ($div_count)
					  echo '</div></div></div>';
          	}//if ( count( $module ) > 0 ) 

		
		
		}//for loop

 	}//showModuleHTML1Div function

 	
} //class declaration                
        ?>
