<?php defined('_JEXEC') || die('[Ninjimage] Direct access to this location is not allowed.');
/**
 * @version		$Id: mod_ninjimage.php, 1 2008/12/25 15:15:06 +0100 uwalter Exp $
 * @package		NinjaForge.Ninjimage 
 * @subpackage	Joomla.Modules 
 * @copyright	Copyright (C) 2008 ninjaforge.com - Get on the Cutting Edge.
 * @licence		GNU/GPL http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * @developer	Uwe Walter
 * @email		uwe@ninjforge.com
 * @homepage	http://ninjaforge.com 
 * @tabstop		4
 * #############################################################################
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * #############################################################################
 * $LastModified: 2008-12-28 11:45:50 +0100 uwalter $
 */

// Load the module helper.
require_once dirname(__FILE__).DS.'helper.php';

// Get default and advanced parameters.
$param = array(

	// Default parameters
	'mid'		=> $module->id,
	'mname'		=> $module->module,
	'type'		=> $params->get('type'),

	// Styling Parameters
	'usecss'	=> $params->get('usecss'),
	'useid'		=> $params->get('useid'),
	'usediv'	=> $params->get('usediv'),

	/**
	 * Ninjimage DIV Container
	 *
	 * We don't need the CSS parameters here, since we load them at the
	 * CSS scripts. So we can save a little memory here. ;-)
	 */

	// Custom Header parameters
	'hdr'		=> $params->get('hdr'),
	'hdrtxt'	=> $params->get('hdrtxt'),
	// 'hdrcol' is also CSS related.

	// JavaScript parameters
	'core'		=> $params->get('core'),
	'js'		=> $params->get('js')
);

// Shall we use a custom DIV id?
if ($param['useid'] == 'pleaseReadTooltip' || $param['useid'] == '')
	$param['useid']	= FALSE;

if ($param['type'] == 'mod') {
	// Module Parameters
	$param['id']	= $params->get('mod_id');
	$html			= modNinjimageHelper::getModule($param);
}
else {
	// Basic Image Parameters
	$param['alt']		= $params->get('img_alt');
	$param['title']		= $params->get('img_title');
	$param['iwidth']	= $params->get('img_width');
	$param['iheight']	= $params->get('img_height');
	$param['path']		= $params->get('img_path');
	$param['file']		= $params->get('img_file');
	$param['usepng']	= $params->get('img_usepng');
	$param['useurl']	= $params->get('img_useurl');
	$param['location']	= $params->get('img_location');
	$param['target']	= $params->get('img_target');

	// Get Draggable Image Parameters, if needed
	if ($param['type'] == 'drg') {
		$html = modNinjimageHelper::getDraggable($param);
	}
	else {
		$html = modNinjimageHelper::getImage($param);
	}
}

// Print HTML output.
require JModuleHelper::getLayoutPath('mod_ninjimage');
