<?php
/**
 * @Name         Theme Joomla Power Slide Diplay Module
 * @URL          http://powerslide.themejoomla.com
 * @version      $Id: resizer.php 3 skashi $
 * @package      Joomla (1.5.x)
 * @subpackage   Power Slide Diplay Module
 * @copyright    Copyright (C) 2008-2020 Theme Joomla. All rights reserved. E & OE
 */

define( '_VALID_MOS', 1 );
define( '_JEXEC', 1 );
$max_height = 1000;
$max_width = 2000;
if (isset($_GET["imgfile"])) {
	$image                      = stripslashes( $_GET["imgfile"] );
	$full_image                 = stripslashes( $_GET["full_image"] );
	$stretch_resized_image      = stripslashes( $_GET["stretch_image"] );
  $stretch_thumbnail_image    = stripslashes( $_GET["stretch_thumbnail_image"] );
	if (isset($_GET["max_width"])) { if($_GET["max_width"] < 2000) $max_width = $_GET["max_width"]; }
	if (isset($_GET["max_height"])) { if($_GET["max_height"] < 1000) $max_height = $_GET["max_height"]; }
  /*
   * Main image resizing to the gallery dimensions
   */
  if( $full_image == 1 ) {
    $image_type  = 'resized';
    $stretch_image = $stretch_resized_image == 1? true: false;
  } else { /* Thumbnails processing */
    $image_type  = 'thumbnail';
    $stretch_image = $stretch_thumbnail_image == 1? true: false;
  }
	if (strrchr($image, '/')) {
		$filename = substr(strrchr($image, '/'), 1); // remove folder references
	} else {
		$filename = $image;
	}
  /*get the image dimensions */
	$size             = getimagesize($image);
	$width            = $size[0];
	$height           = $size[1];
	$cache_path       = 'cache/';
  if( $stretch_image ) {
    $new_height   = $max_height;
		$new_width    = $max_width;
  } else if( $max_height < $height && $height >= $width ){
	  $new_height   = $max_height;
		$new_width    = round($max_height*$width/$height);
	} else if( $max_width < $width && $height <= $width ) {
	  $new_width    = $max_width;
		$new_height   = round($max_width*$height/$width);
	} else {
    $new_width    = $width;
		$new_height   = $height;
  }
  $tn_width       = $new_width;
	$tn_height      = $new_height;

	/*
   * Caching additions by Trent Davies
	 * First check cache.
	 * Cache must be world-readable - chmod(755)
	 */
	$resized = $cache_path.$image_type.'-'.$tn_width.'x'.$tn_height.'-'.$filename;
	$imageModified = @filemtime($image);
	$thumbModified = @filemtime($resized);

	//header("Content-type: image/jpeg");

	/*
   * If thumbnail is newer than image then output cached thumbnail and exit.
   */
	if($imageModified<$thumbModified) {
		header("Last-Modified: ".gmdate("D, d M Y H:i:s",$thumbModified)." GMT");
		readfile($resized);
		exit;
	}

	/* Read image */
	$ext = strtolower(substr(strrchr($image, '.'), 1)); // get the file extension
	switch ($ext) {
		case 'jpg':     // jpg
			$src = imagecreatefromjpeg($image) or notfound();
			break;
		case 'JPG':     // jpg
			$src = imagecreatefromJPEG($image) or notfound();
			break;
		case 'png':     // png
			$src = imagecreatefrompng($image) or notfound();
			break;
		case 'gif':     // gif
			$src = imagecreatefromgif($image) or notfound();
			break;
		default:
			notfound();
	}

	/* set up canvas */
	$dst = imagecreatetruecolor($tn_width,$tn_height);

	/* copy resized image to new canvas */
	imagecopyresampled ($dst, $src, 0, 0, 0, 0, $tn_width, $tn_height, $width, $height);

	/* send the header and new image */
	imagejpeg($dst, null, 90);
	imagejpeg($dst, $resized, 90); // write the thumbnail to cache as well...

	/* clear out the resources */
	imagedestroy($src);
	imagedestroy($dst);
}

?>