<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @Name         Theme Joomla Power Slide Diplay Module
 * @URL          http://powerslide.themejoomla.com
 * @version      $Id: default.php 3 skashi $
 * @package      Joomla (1.5.x)
 * @subpackage   Power Slide Diplay Module
 * @copyright    Copyright (C) 2008-2020 Theme Joomla. All rights reserved. E & OE
 */


/*
 * Function to return the javascript image array string for the image gallery for a single gallery without using recursive image searching
 */
function imageArrayGallery( $images, $transition_effect, $use_thumb_generator, $image_thumbnail_folder_path, $image_folder_path, $thumbnail_method,
  $image_gallery_method, $image_link_option, $thumbnail_method_txt, $fit_image_to_gallery_dimensions, $full_image_params, $thumbnail_string_base ) {
  $ia_string   = "";
  $uri         =& JURI::getInstance();
  $uri_root    = $uri->root();
  $g           = 0;
  foreach ( $images as $image ) {
    $link_display               = "";
    $link_title_display         = "";
    $lb_link_display            = "";
    $lb_link_title_display      = "";
    $description                = "";
    if( $image_gallery_method == 1 ) { /* Use XML File */
      $image_path               = $image_folder_path.$image->filename;
      $title                    = addcslashes($image->title, "'");
      $description_text         = str_replace("\n", "<br/>", addcslashes($image->description, "'") );
      $description              = "description: '$description_text',";
      $link                     = JRoute::_( $image->link );
      if( $link <> "" ) {
        $link_display           = "link: '$link',";
        $link_title_display     = "linkTitle: '$title',";
      }
      if( $image_link_option == 1 ) {
        $lb_link_display        = "lbLink: '$image_path',";
        $lb_link_title_display  = "lbLinkTitle: '$title',";
      }
    } else if( $image_gallery_method == 2 ) { /* Use Folder path */
      $image_path               = $image->folder.$image->filename;
      $name                     = addcslashes($image->filename, "'");
      $name_array               = explode('.', $name);
      $title                    = ucfirst( $name_array[0] );
      if( $image_link_option == 1 ) {
        $lb_link_display        = "lbLink: '$image_path',";
        $lb_link_title_display  = "lbLinkTitle: '$title',";
      }
    }
    $image_thumb_path       = $thumbnail_method_txt.$image_path;
    if( $thumbnail_method == 2 and $fit_image_to_gallery_dimensions <> 1 ) {
      $image_path = $image_path;
    } else {
      $image_path = $image_thumb_path;
    }
    if( $fit_image_to_gallery_dimensions == 1 ) {
      $image_string = JRoute::_( $uri_root."modules/mod_powerslide/resizer.php?imgfile=$image_path&full_image=1$full_image_params" );
    } else $image_string = JRoute::_( $image_path );
    $thumbnail_string = $use_thumb_generator == '1' ?
      JRoute::_( "$thumbnail_string_base&imgfile=$image_thumb_path" ):
      JRoute::_( $thumbnail_string_base.$image->filename );
    $ia_string.=
    "{
      number: $g,
      title: '$title',
      $description
      $link_display
      $link_title_display
      $lb_link_display
      $lb_link_title_display
      transition: '$transition_effect',
      image: '$image_string',
      useThumbGenerator: false,
      thumbnail: '$thumbnail_string'
    },";
    $g++;
  }
  return substr($ia_string, 0, -1);
}
/*
 * Set the thumbnail method text
 */
$uri                  =& JURI::getInstance();
$uri_root             = $uri->root();
$thumbnail_method_txt = $thumbnail_method == 1? $uri_root: '../../';
/* Start the head tag */
$head = "<!-- Power Slide Display $ps_version by Theme Joomla -->";
/* Start the head tag */
$head .= '<script type="text/javascript">try{ jQuery.noConflict(); } catch( Exception ) {}</script>';
/* Main Power Slide CSS File */
if (file_exists('templates/'.$mainframe->getTemplate().'/css/powerslide.css')) {
  $head .= '<link rel="stylesheet" href="'.JRoute::_( 'templates/'.$mainframe->getTemplate().'/css/powerslide.css' ).'" type="text/css" media="screen" />';
} else {
  $head .= '<link rel="stylesheet" href="'.JRoute::_( 'modules/mod_powerslide/css/powerslide.css' ).'" type="text/css" media="screen" />';
}
/* Variable CSS injections */
$bigger_thumb_height = (string)($thumb_height + 3)."px";
$gallery_selector_height = $thumb_height > 80? (string)($thumb_height + 5)."px": "80px";
$carousel_height = $thumb_height > 80? (string)($thumb_height + 40)."px": "115px";
$carousel_container_height = $thumb_height > 80? (string)($thumb_height + 60)."px": "135px";
$head .= "
<style type=\"text/css\">
#myGallery, #flickrGallery { width: $gallery_width; height: $gallery_height; z-index:5 }
.jdGallery .slideElement { background-color: $bg_color; }
.jdGallery .loadingElement { background-color: $bg_color; }
.jdGallery .slideInfoZone { height: $slide_info_height; }
.jdGallery .slideInfoZone h2 { color: $title_color; }
.jdGallery .slideInfoZone div { color: $description_color; }
.jdGallery .carousel { height: $carousel_height; }
.jdGallery div.carouselContainer { height: $carousel_container_height; }
.jdGallery .carousel .carouselWrapper, .jdExtCarousel .carouselWrapper { height: $bigger_thumb_height; }
.jdGallery a.carouselBtn { color: $link_color; }
.jdGallery a.gallerySelectorBtn { color: $link_color; }
.jdGallery .gallerySelector { background-color: $bg_color }
.jdGallery .gallerySelector .gallerySelectorInner div.galleryButton h3 { color: $link_color }
.jdGallery .gallerySelector .gallerySelectorInner div.galleryButton { height: $gallery_selector_height;
.lbLoading { background: $bg_color url(../images/core/loading-bar-black.gif) no-repeat center; }
.read_more { font-size: 12px; font-weight: normal; color: $link_color }
</style>";
/* Browser CSS File */
if (file_exists('templates/'.$mainframe->getTemplate().'/css/browser.css')) {
  $head .= '
  <!--[if IE]>
  <link rel="stylesheet" href="'.JRoute::_( 'templates/'.$mainframe->getTemplate().'/css/browser.css' ).'" type="text/css" media="screen" />
  <![endif]-->';
} else {
  $head .= '
  <!--[if IE]>
  <link rel="stylesheet" href="'.JRoute::_( 'modules/mod_powerslide/css/browser.css' ).'" type="text/css" media="screen" />
  <![endif]-->';
}
/* Printing out module code starts here */
if ( $use_mootools == '1' ) $head .= '<script src="modules/mod_powerslide/js/mootools.js" type="text/javascript"></script>';
$head .= '
<script src="'.JRoute::_( 'modules/mod_powerslide/js/tj.slimbox.js' ).'" type="text/javascript"></script>
<script src="'.JRoute::_( 'modules/mod_powerslide/js/tj.gallery.js' ).'" type="text/javascript"></script>
<script src="'.JRoute::_( 'modules/mod_powerslide/js/tj.gallery.transitions.js' ).'" type="text/javascript"></script>';
/*
 * Set the full and thumbnail image settings from the module parameters
 */
$full_image_params     = "&max_height=$gallery_height&max_width=$gallery_width&stretch_image=$stretch_image";
$thumbnail_string_base = $use_thumb_generator == '1' ?
  $uri_root."modules/mod_powerslide/resizer.php?max_height=$thumb_height&max_width=$thumb_width&stretch_thumbnail_image=$stretch_thumbnail_image":
  $image_thumbnail_folder_path;
/*
 * Setup images inside javascript array for pre-loaded images
 */
$head .= '<script type="text/javascript">
            var imageArray = new Array(';
$head .= imageArrayGallery( $images, $transition_effect, $use_thumb_generator, $image_thumbnail_folder_path, $image_folder_path, $thumbnail_method,
         $image_gallery_method, $image_link_option, $thumbnail_method_txt, $fit_image_to_gallery_dimensions, $full_image_params, $thumbnail_string_base );

$head .= ');';
/*
 * Initialise the gallery with its default settings
 */
$head .= 'function startGallery() {';
$head .= 'var myGallery = new gallery($(\'myGallery\'), {';
$head .= 'embedLinks: true,';
$head .= "thumbWidth: '$thumb_width',";
$head .= "thumbHeight: '$thumb_height',";
$head .= $autoplay == '1' ? 'timed: true,': 'timed: false,';
$head .= 'slideInfoZoneSlide: false,';
$head .= $show_controls == '1' ? 'showArrows: true,': 'showArrows: false,';
$head .= $show_carousel == '1' ? 'showCarousel: true,': 'showCarousel: false,';
$head .= $show_readmore == '1' ? 'showReadMore: true,': 'showReadMore: false,';
$head .= $delay != '' ? 'delay: '.$delay.',': 'delay: 5000,';
$head .= $carousel_text != '' ? "textShowCarousel: '".$carousel_text."',": "textShowCarousel: 'Show / Hide',";
$head .= "useThumbGenerator: true,";
$head .= $show_title == '1' ? 'showInfopane: true,': 'showInfopane: false,';
$head .= $new_target_window == '1'? "newTargetWindow: true,": "newTargetWindow: false,";
$head .= "imageLinkOption: $image_link_option,";
$head .= "manualData: imageArray";
$head .= '});';
if( $image_link_option == 1 ) {
  $head .= 'Lightbox.init( { myGallery: myGallery } );';
}
$head .= '
  }
  window.addEvent(\'load\', startGallery);
  </script>';
/* Finally add to the head tag */
$mainframe->addCustomHeadTag( $head );
/*
 * Set the <div> containers for our image gallery
 */
echo '<div class="content'.$params->get('moduleclass_sfx').'">';
echo '<div id="myGallery"></div>';
echo "</div>";
  ?>
<div class="clr"></div>