<?php
/**
 * JIncludes is a Joomla! plugin allowing administrators to define code snippets and include/execute them inside a content item.
 *
 * @author       Andrea Azzini
 * @package      JIncludes
 * @version      $Id: JIncludes.php 21 2009-11-05 11:09:59Z endi $
 * @copyright    Copyright (C) 2009 Andrea Azzini
 * @license		 GNU GPL v.3 or later, see http://www.gnu.org/licenses/
 * @link         http://joomlacode.org/gf/project/jincludes
 *
 * This is a derivative work of the Joomla! Open Source CMS, see http://www.joomla.org/
 * Joomla! is licensed under the terms of the GNU GPL v.2 license.
 */
 
// This code is explained in more detail in the project's Wiki. See http://joomlacode.org/gf/project/jincludes/wiki/

defined('_JEXEC') or die( "Direct access is not allowed." );

class plgContentJIncludes extends JPlugin {
	
	function plgContentJIncludes( &$subject ) {
		parent::__construct( $subject );
		$this->_plugin =& JPluginHelper::getPlugin( 'content', 'JIncludes' );
		$this->_params = new JParameter( $this->_plugin->params );
		$this->block_types = array('phpblock_ext', 'phpblock');
		$this->num_snippets = (int) $this->_params->get('num_snippets','30');
		if ($this->num_snippets == 0) {$this->num_snippets = 30;}
		$this->show_errors = ( $this->_params->get('show_errors','no') == 'yes' )? true : false;
	}
	
	function onPrepareContent( &$article, &$params, $limitstart=0 ) {
		$this->keys = array();
		$this->types = array();
		$this->_article = $article;
		$preg_block_keys = '';
		$preg_single_keys = '';
		
		for ($i=1; $i<=$this->num_snippets; $i++) {
			if ( ($key = $this->_params->get("key$i",'')) &&
			     (preg_match('#^/?[a-z\d_]+$#i',$key)) && // check key validity
			     (!in_array( $key, $this->keys ))
			) {
				$this->keys[$i] = $key;
				$this->types[$i] = $this->_params->get("type$i",'');
				if (in_array($this->types[$i], $this->block_types)) {
					$preg_block_keys .= preg_quote($this->keys[$i],'#') . '|';
				} else {
					$preg_single_keys .= preg_quote($this->keys[$i],'#') . '|';
				}
			}
		}
		
		if ($preg_single_keys) {
			$preg_single_keys = '#{{\s*(' . substr($preg_single_keys,0,-1) . ')\s*((?:\s.*?)?)}}#is';
			$article->text = preg_replace_callback($preg_single_keys, array($this,'callback_recognize_match'), $article->text);
		}
		if ($preg_block_keys) { // this is actually meant to always match WHOLE document as $matches[0]
			$preg_block_keys = '#^(.*?){{\s*(' . substr($preg_block_keys,0,-1) . ')\s*((?:\s.*?)?)}}(.*?){{/\2}}(.*)$#is';
			do 
				$article->text = preg_replace_callback($preg_block_keys, array($this,'callback_recognize_match'), $article->text, -1, $found);
			while ( $found) ;
		}
		return true;
	}
	
	function callback_recognize_match($matches) {
		if ( isset( $matches[3] ) ) { //this happens just if the block matching was performed
			$id = array_search( $matches[2], $this->keys );
			$env = array( $matches[0], $matches[1], $matches[4], $matches[5] );
			$param = trim($matches[3]);
		} else {
			$id = array_search( $matches[1], $this->keys );
			$env = array( $matches[0] );
			$param = trim($matches[2]);
		}
		$output = '';
		switch ($this->types[$id]) {
			case 'html':
				$output = $this->sub_html( $id, $param );
				break;
			case 'html_ext':
				$output = $this->sub_html_ext( $id, $param, $matches[0] );
				break;
			case 'php':
			case 'phpblock':
				$output = $this->sub_php( $id, $param, $env );
				break;
			case 'php_ext':
			case 'phpblock_ext':
				$output = $this->sub_php_ext( $id, $param, $env );
				break;
			case 'style_ext':
				$this->sub_style_ext( $id );
				break;
			case 'script_ext':
				$this->sub_script_ext( $id );
				break;
			default: // corrupt database setting? did the user really mean to output the tag text?
				$output = $matches[0];
		}
		return $output;
	}
	
/**
 * Specific replace functions. 
 * Remember: security checks are implemented before. When these are executed, the following conditions are met:
 * 	- the key does exist, and its ID is $id
 * 	- the template is meant to be read by the called function (ie. when sub_html() is called, it will receive the ID 
 * 	  of a snippet with type=html, no need to check again)
 * These functions have to return the markup to output.
 */
	
	function sub_html( $id, $param ) {
		$output = $this->_params->get( "code$id", '' );
		if ($param) {
			$output = str_replace( '\$', '$', preg_replace( '/([^\\\])\$/e', "'\\1'.\$param", $output ) );
		}
		return $output;
	}
	
	function sub_html_ext( $id, $param, $default ) {
		$filename = trim( $this->_params->get( "code$id", '' ) );
		if (!file_exists($filename)) { 
			return ($this->show_errors)? '<strong>JIncludes: HTML file not found (' .htmlentities($filename). ')</strong>' : $default;
		}
		$output = file_get_contents($filename);
		if ($param) {
			$output = str_replace( '\$', '$', preg_replace( '/([^\\\])\$/e', "'\\1'.\$param", $output ) );
		}
		return $output;
	}
	
	function sub_php( $id, $param, $env ) {
		$code = $this->_params->get( "code$id", '' );
		if (version_compare('1.5.3',JVERSION,'>')) // if older than 1.5.3, we need a workaround for pipes not being unescaped
			$code = str_replace( '\|', '|', $code );
		ob_start();
			eval( $code );
			$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
	
	function sub_php_ext( $id, $param, $env ) {
		$filename = trim( $this->_params->get( "code$id", '' ) );
		if (!file_exists($filename)) {
			return ($this->show_errors)? '<strong>JIncludes: PHP file not found (' .htmlentities($filename). ')</strong>' : $env[0];
		}
		ob_start();
			if (include($filename)) {
				$output = ob_get_contents();
			} else {
				$output = $env[0];
			}
		ob_end_clean();
		return $output;
	}
	
	function sub_style_ext( $id ) {
		$doc =& JFactory::getDocument();
		$doc->addStyleSheet(trim( $this->_params->get( "code$id", '' ) ));
	}
	
	function sub_script_ext( $id ) {
		$doc =& JFactory::getDocument();
		$doc->addScript(trim( $this->_params->get( "code$id", '' ) ));
	}
	
	// end of class definition
}