<?php
/*
 * @component AlphaUserPoints
 * @copyright Copyright (C) 2008-2009 Bernard Gilly
 * @license : GNU/GPL
 * @Website : http://www.alphaplug.com
 */

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * AlphaUserPoints Content Plugin
 *
 * @package		Joomla
 * @subpackage	AlphaUserPoints
 * @since 		1.5
 */

class plgContentsysplgaup_content extends JPlugin
{

	function plgContentsysplgaup_content( &$subject, $params )
	{
		parent::__construct( $subject, $params );
	}


	function onPrepareContent( &$article, &$params, $limitstart )
	{
		global $mainframe;
		
		$user 	= & JFactory::getUser();
		
		$authorid  = $article->created_by;
		$articleid = $article->id;
		
		$option = JRequest::getCmd('option', '');
		$view   = JRequest::getVar('view',   '');
		$print	= JRequest::getVar('print');
		$format	= JRequest::getVar('format');
		
		if ($mainframe->isAdmin()) return;
		
		if ( !$user->id || $user->id==$authorid || $print || $format=='pdf' || !$articleid ) {
			$article->text = preg_replace( " |{AUP::CONTENT=(.*)}| ", "", $article->text );
			return;
		}		
		
		if ( preg_match('#{AUP::CONTENT=(.*)}#Uis', $article->text, $m) )
		{
			$points = $m[1];			
			
			JPlugin::loadLanguage( 'com_alphauserpoints' );
							
			require_once (JPATH_SITE.DS.'components'.DS.'com_alphauserpoints'.DS.'helper.php');
			
			$datareference = '<a href="' . JURI::current() . '">' . $article->title . '</a>' ;
			
			// com_content
			if ( $option=='com_content') {
				switch ( $view ) {
					case 'article' :
						if ( $option=='com_content' && $limitstart==0 ) {						
							// Rule content plugin
							if ( AlphaUserPointsHelper::userpoints( 'sysplgaup_content', '', 0, $articleid, $datareference, $points, true )===false )
							{
								$mainframe->redirect('index.php');
							}							
						}
						break;
					default:
				}
			} else {
				// other components
				if ( !$article->title || $article->title==NULL ) $article->title = $option;
				if ( AlphaUserPointsHelper::userpoints( 'sysplgaup_content', '', 0, $articleid, $datareference, $points, true )===false )
				{
					$mainframe->redirect('index.php');
				}			
			}
			
			$article->text = preg_replace( " |{AUP::CONTENT=(.*)}| ", "", $article->text );
		}
	}
}
?>