<?php
/**
* @version        $Id: helper.php 11626 2009-02-15 15:40:39Z kdevine $
* @package        Joomla.Framework
* @subpackage    Application
* @copyright    Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license        GNU/GPL, see LICENSE.php
*  Joomla! is free software. This version may have been modified pursuant
*  to the GNU General Public License, and as distributed it includes or
*  is derivative of works licensed under the GNU General Public License or
*  other free or open source software licenses.
*  See COPYRIGHT.php for copyright notices and details.
*/
 
// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();
 
/**
 * Application helper functions
 *
 * @static
 * @package        Joomla.Framework
 * @subpackage    Application
 * @since        1.5
 */
class NApplicationHelper
{  
    function parseXMLFile($path)
    {
        // Read the file to see if it's a valid component XML file
        $xml = & JFactory::getXMLParser('Simple');
 
        if (!$xml->loadFile($path)) {
            unset($xml);
            return false;
        }
 
        /*
         * Check for a valid XML root tag.
         *
         * Should be 'install', but for backward compatability we will accept 'mosinstall'.
         */
        if ( !is_object($xml->document) || ($xml->document->name() != 'install' && $xml->document->name() != 'mosinstall')) {
            unset($xml);
            return false;
        }
 
        $data = array();
        $data['legacy'] = $xml->document->name() == 'mosinstall';
 
        $element = & $xml->document->name[0];
        $data['name'] = $element ? $element->data() : '';
        $data['type'] = $element ? $xml->document->attributes("type") : '';
 
        $element = & $xml->document->creationDate[0];
        $data['creationdate'] = $element ? $element->data() : JText::_('Unknown');
 
        $element = & $xml->document->author;
        $data['author'] = $element ? $element : JText::_('Ninja Team');
        
        $element = & $xml->document->changelog[0];
        $data['changelog'] = $element ? $element : JText::_('Initial Release');
        
        $element = & $xml->document->credits[0];
        $data['credits'] = $element ? $element : '';
 
        $element = & $xml->document->copyright[0];
        $data['copyright'] = $element ? $element->data() : '';
 
        $element = & $xml->document->authorEmail[0];
        $data['authorEmail'] = $element ? $element->data() : '';
 
        $element = & $xml->document->authorUrl[0];
        $data['authorUrl'] = $element ? $element->data() : '';
 
        $element = & $xml->document->version[0];
        $data['version'] = $element ? $element->data() : '';
        
        $element = & $xml->document->slogan[0];
        $data['slogan'] = $element ? $element->data() : '';
 
        $element = & $xml->document->description[0];
        $data['description'] = $element ? $element->data() : '';
 
        $element = & $xml->document->group[0];
        $data['group'] = $element ? $element->data() : '';
 
        return $data;
    }
    
    /**
	* Get a path
	*
	* @access public
	* @param string $varname
	* @param string $user_option
	* @return string The requested path
	* @since 1.0
	*/
	function getExec( $varname, $user_option=null )
	{
		// check needed for handling of custom/new module xml file loading
		$check = ( ( $varname == 'mod0_xml' ) || ( $varname == 'mod1_xml' ) );

		if ( !$user_option && !$check ) {
			$user_option = JRequest::getCmd('option');
		} else {
			$user_option = JFilterInput::clean($user_option, 'path');
		}

		$result = null;
		$name 	= substr( $user_option, 4 );

		switch ($varname) {
			case 'front':
				$result = NApplicationHelper::_checkPath( DS.'components'.DS. $user_option .DS. $name .'.php', 0 );
				break;

			case 'html':
			case 'front_html':
				if ( !( $result = NApplicationHelper::_checkPath( DS.'templates'.DS. NApplication::getTemplate() .DS.'components'.DS. $name .'.html.php', 0 ) ) ) {
					$result = NApplicationHelper::_checkPath( DS.'components'.DS. $user_option .DS. $name .'.html.php', 0 );
				}
				break;

			case 'toolbar':
				$result = NApplicationHelper::_checkPath( DS.'components'.DS. $user_option .DS.'toolbar.'. $name .'.php', -1 );
				break;

			case 'toolbar_html':
				$result = NApplicationHelper::_checkPath( DS.'components'.DS. $user_option .DS.'toolbar.'. $name .'.html.php', -1 );
				break;

			case 'toolbar_default':
			case 'toolbar_front':
				$result = NApplicationHelper::_checkPath( DS.'includes'.DS.'HTML_toolbar.php', 0 );
				break;

			case 'admin':
				$path 	= DS.'components'.DS. $user_option .DS.'admin.'. $name .'.php';
				$result = NApplicationHelper::_checkPath( $path, -1 );
				if ($result == null) {
					$path = DS.'components'.DS. $user_option .DS. $name .'.php';
					$result = NApplicationHelper::_checkPath( $path, -1 );
				}
				break;

			case 'admin_html':
				$path	= DS.'components'.DS. $user_option .DS.'admin.'. $name .'.html.php';
				$result = NApplicationHelper::_checkPath( $path, -1 );
				break;

			case 'admin_functions':
				$path	= DS.'components'.DS. $user_option .DS. $name .'.functions.php';
				$result = NApplicationHelper::_checkPath( $path, -1 );
				break;

			case 'class':
				if ( !( $result = NApplicationHelper::_checkPath( DS.'components'.DS. $user_option .DS. $name .'.class.php' ) ) ) {
					$result = NApplicationHelper::_checkPath( DS.'includes'.DS. $name .'.php' );
				}
				break;

			case 'helper':
				$path	= DS.'components'.DS. $user_option .DS. $name .'.helper.php';
				$result = NApplicationHelper::_checkPath( $path );
				break;

			case 'com_xml':
				$path 	= DS.'components'.DS. $user_option .DS. $name .'.xml';
				$result = NApplicationHelper::_checkPath( $path, 1 );
				break;

			case 'mod':
				$path = DS.'modules'.DS. $user_option .DS.'execute.php';
				$result = NApplicationHelper::_checkPath( $path );
				break;

			case 'mod1_xml':
				// admin modules
				$path = DS.'modules'.DS. $user_option .DS. $user_option. '.xml';
				$result = NApplicationHelper::_checkPath( $path, -1 );
				break;

			case 'bot_xml':
				// legacy value
			case 'plg_xml':
				// Site plugins
				$path 	= DS.'plugins'.DS. $user_option .'.xml';
				$result = NApplicationHelper::_checkPath( $path, 0 );
				break;

			case 'menu_xml':
				$path 	= DS.'components'.DS.'com_menus'.DS. $user_option .DS. $user_option .'.xml';
				$result = NApplicationHelper::_checkPath( $path, -1 );
				break;
		}

		return $result;
	}
	
	/**
	 * Tries to find a file in the administrator or site areas
	 *
	 * @access private
	 * @param string 	$parth			A file name
	 * @param integer 	$checkAdmin		0 to check site only, 1 to check site and admin, -1 to check admin only
	 * @since 1.5
	 */
	function _checkPath( $path, $checkAdmin=1 )
	{
		$file = JPATH_SITE . $path;
		if ($checkAdmin > -1 && file_exists( $file )) {
			return $file;
		} else if ($checkAdmin != 0) {
			$file = JPATH_ADMINISTRATOR . $path;
			if (file_exists( $file )) {
				return $file;
			}
		}

		return null;
	}
}