<?php
/**
* @version		$Id: author.php 10381 2008-06-01 03:35:53Z pasamio $
* @package		Joomla
* @subpackage	Articles
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Renders a author element
 *
 * @package 	Joomla
 * @subpackage	Articles
 * @since		1.5
 */
class JElementDashboard extends JElement
{
	/**
	 * Element name
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'dashboard';

	function fetchElement($name, $value, &$node, $control_name)
	{
		jimport('joomla.filesystem.file');
		$doc = & JFactory::getDocument();
		$db 	=& JFactory::getDBO();
		$id 	= JRequest::getInt('id');
		if (!$id) { 
			$id = reset(JRequest::getVar( 'cid', array())); 
		}
		//Get the module name, in a slightly hacky way.
		$module		= JRequest::getWord('module');
		$mod		=& JTable::getInstance('Module', 'JTable');
		if ($id) {
			$mod->load($id);
			$modname = $mod->module;
		} elseif($module) {
			$modname = $module;
		}
		nimport('napi.application.helper');
		$xml = NApplicationHelper::parseXMLFile(JApplicationHelper::getPath('mod0_xml', $modname));
    	if (!defined('NAPI_DASHBOARD'))
    	{
		//return '<pre>'.print_r($xml,true).'</pre>';
		define('NAPI_DASHBOARD', 1);
		}
		
		jimport('joomla.html.pane');
        // TODO: allowAllClose should default true in J!1.6, so remove the array when it does.
		$panel = &JPane::getInstance('sliders');	
		
		jimport('joomla.language.helper');
        $locale = JLanguageHelper::detectLanguage();
        $instructions = JText::_('NINSTRUCTIONS');
        //$instructions = JFile::read(JURI::root().'modules/'.$modname.'/dashboard/'.$locale.'/instructions.html');
        if ( !$instructions ) {
        	//$instructions = JFile::read(JURI::root().'modules/'.$modname.'/dashboard/en-GB/instructions.html');
        }
		$changelog = JText::_($node->attributes('changelog'));
        if ( !$changelog ) {
        	$changelog = 'No changelog here yet.';
        }
        
        $imgpath = $node->attributes('imgpath') ? $node->attributes('imgpath') : 'media/napi/img/dashboard/';
        
		$support = '<a href="http://ninjaforge.com/index.php?option=com_fireboard&Itemid=111"> NinjaForge forums</a>';
		$rate = '<a href="http://extensions.joomla.org/extensions/style-&-design/tabs-&-tabss/5726/details"> Joomla.org</a>';
			
		$return  = '';
		$script = "function $control_name$name(e) {
			jQuery(e).addClass('tabactive').siblings().removeClass('tabactive');jQuery('.panel .jpane-toggler-down + .content').height(jQuery('.panel .jpane-toggler-down + .content > div').outerHeight());
			return e;
		}";
//		$filter = ' {prefix: \'tab-\', invert: \'ui-filter-select\', parent: \'.ui-corner-all.ui-filter\', items: \'.nftab\', onfilter: function(){ '.$control_name.$name.'(this)} }';
		$filter = '';
		//$return .= $panel->endPanel();
		if(!$this->_parent->get('dashboardStyle')) {
			$return .= '
<div class="panel ui-corner-all">
<h3 class="title ui-corner-all jpane-toggler" id="'.$control_name.$name.'title"><span>'.JText::_('DASHPANELTITLE').'</span></h3>
<div id="'.$control_name.$name.'" class="jpane-slider content ui-corner-bottom ui-filter">';
			$return .= '<style type="text/css"> 

  
    #'.$control_name.$name.'{ border:1px solid #dddddd; }
    .nftab .inner{}
    .nftab{}
  </style>';
		} else {
		$return .= '<div id="'.$control_name.$name.'" class="ui-corner-all ui-filter">';
		}
		$return .= '
		
		
		<style type="text/css"> 
		#paramsdashboard-lbl     {
			display: none;
		} 
		#hideme {
		display:none;
		}
		
    body{font-family:Helvetica,Arial,sans-serif; }
    #'.$control_name.$name.'{background: #ffffff 0 0; background-repeat: repeat-x; background-position: center -63px; 	border:0px solid #dddddd; position:relative; margin:0; }
    #'.$control_name.$name.'.content .ui-corner-top { -webkit-border-top-left-radius: 0px;
-webkit-border-top-right-radius: 0px; -moz-border-radius-topLeft: 0px;
-moz-border-radius-topRight: 0px; }
    
    .menu{ display:block;
background-position: 50% 100%; position:relative; }

    .menu img.dashbg{ width:100%; max-width:692px; display:block;margin: 0px auto 0px 0px auto; background-color: #6A84AB; }
    
    .menu ul{display: block; margin-left:auto; margin-right:auto; padding:0px; list-style:none; text-align:center; position: absolute; top:0px; width:100%;}
    .menu li{background:none; float:left; margin:0px 0px 0px 0px; padding:0px; display:inline-block; overflow:hidden;}
    .menu li img { float:left; cursor:pointer;visibility:hidden; position: relative; width: 100%; }
    .menu li#tablink0{max-width: 135px; width:19.5086705202312%;cursor:default; }
    .menu li#tablink1{max-width: 183px; width:26.4450867052023%}
    .menu li#tablink2{max-width:191px; width:27.6011560693642%;}
    .menu li#tablink3{max-width:183px; width:26.4450867052023%; }
    .menu li#tablink3 img{ cursor:default; }
    .menu li#tablink1.tabactive,{backgroud:url(\''.JURI::root().$imgpath.'bg.png\') no-repeat 0 0; }
    .menu li#tablink2.tabactive,{backgrond:url(\''.JURI::root().$imgpath.'bg.png\') no-repeat -139px 0; }
    .menu li#tablink3.tabactive,.menu li#tablink3:hover{backgroud:url(\''.JURI::root().$imgpath.'bg.png\') no-repeat -277px 0; }
    .menu li.tabactive img, .menu li:hover img {
    	/*display:inline;*/
    	visibility: visible;
    }
    .menu .menu-nav li:hover {
    	opacity:0.1;
    }
    
    .menu .menu-nav li.tabactive, .menu .menu-nav li.tabactive:active {
    	opacity:1;
    }
    
    .tabtxt{padding:0 0 0 0px; float:none; display:none; }
    
    .nftab{ width:auto; text-align:left; padding:0px 10px 6px 10px; font-size:12px; margin-bottom:5px;
background-position: 50% -67px;
background-repeat: repeat-x;
background-color: transparent;
background-image: url('.JURI::root().$imgpath.'dashbg.png); }
    .nftab .inner{ overflow-y:auto; overflow-x:hidden; width:100%; }
    .nftab h2,.nftab h1{font-weight:bold; text-align:center; padding: 10px 0px; }
    .nftab h1{color:#fff; margin:0px 0px 15px; padding: 1px 0px 0px 0px; }
    .nftab strong{font-weight:normal; }
    .nftab dt strong,.nftab h3 strong{font-weight:bold !important; }
    .nftab dt{font-weight:bold !important; padding:5px 0pt 2px; }
.buttons{border:none; padding:3px; }
.nftab .boxshot {
	text-align:center;
	margin:0px auto;
}
.nftab .boxshot img {
	max-width: '.($node->attributes('boxshotwidth') ? $node->attributes('boxshotwidth') : '233px' ).';
	width: 100%;
}
.nftab .nftab-content {
	display: inline-block;
	width: 50%;
	float:left;
}
.nftab .nftab-content p {
	margin-left: 10px;
}
.nftab ol {
	counter-reset: steps;
}
.nftab ol li {
	counter-increment: steps;
}
.nftab ol li:before {
	content: counter(steps)". "; 
}
.nftab.tab-changelog .inner div {
	float:left;
	width:100%;
	display:block;
	clear:both;
	margin-bottom: 40px;
}
.dashboard-footer {
	text-align:center;
	display:inline-block;
}
  </style>
  <!--[if lte IE 6]>     
    <style>
  	 .nftab h1 {margin:0px 0px 15px 0px !important;}
     .nftab {padding:0px 0px 6px !important;}           
    </style>
	<![endif]--> 

<div class="menu ui-corner-top">
	<img src="'.JURI::root().$imgpath.'bg.png" class="dashbg ui-corner-top" />
	<ul class="menu-nav ui-corner-top">
	<li title="" id="tablink0" class="ui-corner-tl"><img src="'.JURI::root().$imgpath.'dashtabbg_0.png" class="ui-corner-tl" /></li>
    	<li title="" id="tablink1" class="tabactive ui-filter-trigger'.$filter.'"><img src="'.JURI::root().$imgpath.'dashtabbg_1.png" /><span id="info" class="tabtxt">General Info</span></li>
    	<li title="" id="tablink2" class="ui-filter-trigger'.$filter.'"><img src="'.JURI::root().$imgpath.'dashtabbg_2.png" /><span id="inst" class="tabtxt">Instructions</span></li>
    	<li title="" id="tablink3" class="ui-filter-trigger'.$filter.'"><img src="'.JURI::root().$imgpath.'dashtabbg_3.png" /><span id="change" class="tabtxt">Changelog</span></li>
	</ul>
</div>
<div id="tabcontent1" class="nftab tab-general-info filter-general-info ui-filter-item ui-filter-select ">
    <h1>'.JText::_($xml['name']).'</h1>
    <div class="inner">
    <h2>'.JText::_($xml['slogan']).'</h2>
    <div class="boxshot nftab-content"><img class="ui-widget-content" src="'.JURI::root().'media/'.$modname.'/images/256/'.str_replace('mod_', '', $modname).'.png" alt="'.JText::_($xml['name']).'" title="'.JText::_($xml['name']).'"></div>
    <div class="description nftab-content">
    <p><b>'.JText::_('EXTCREATEDBY').'</b> ';
    $i = 0;
    $count = count($xml['author']);
    $separator = '&nbsp;';
    foreach($xml['author'] as $author):
    	 $separator = '&nbsp;';
    	 $i++;
    	if ($count!=1&&$i!=$count)
    	{
    	$separator = ( ($i+1) == $count ? '&nbsp;&amp;' : ( ($i!=0) ? ',' : '' ) );
    	}
    	//$separator = $i.$count;
    	$children = $author->children();
    	$children = $children[$i];
    	$email = ($author->attributes('email') ? $author->attributes('email') : $xml['authorEmail'] );
    	$return .= '&nbsp;<a href="mailto:'.$email.'">'.$author->data().'</a>'.$separator;
    	unset($email);
    endforeach;
    unset($i);
    unset($separator);
    
    $creditsxml = $xml['credits'];
    $credits = array();
    $i = 0;
    foreach($creditsxml->children() as $credit)
    {
    	$credits[$i] = '<p>';
    	$credits[$i] .= '<b>'.JText::_($credit->attributes('what')).'</b> ';
    	$credits[$i] .= '<a href="'.JText::_($credit->attributes('where')).'">'.JText::_($credit->attributes('who')).'</a>';
    	$credits[$i] .= '</p>';
    	
    	$i++;
    }
    $credits = implode("\n", $credits);
    $return .= '</p>
    '.$credits.'
    <p><b>'.JText::_('EXTPHPLIC').'</b>  <a href="http://creativecommons.org/licenses/LGPL/2.1/"> CC-GNU LGPL</a></p>
    <p><b>'.JText::_('EXTJSLIC').'</b> <a rel="license" href="http://www.opensource.org/licenses/mit-license.php"> MIT </a></p>
    <p><b>'.JText::_('EXTCSSIMGCOP').'</b> '.JText::sprintf('EXTCSSIMGCOPTXT', '2008', date('Y')).' <a target="_blank" href="http://'.$xml['authorUrl'].'" class="hasTip"  title="Click me!::Get more extensions at '.JText::_($xml['copyright']).'">'.JText::_($xml['copyright']).'</a></p>
    <p><b>'.JText::_('EXTSUP').'</b> '.JText::sprintf('EXTSUPTXT', $support).'</p>
    <p><b>'.JText::_('EXTRATE').'</b> '.JText::sprintf('EXTRATETXT', $rate).'</p>
    </div>
</div></div>
<div id="tabcontent2" class="nftab tab-instructions filter-instructions ui-helper-hidden ui-filter-select  ui-filter-item">

    <h1>'.JText::_('INSTRUCTIONS').'</h1>  
    <div class="inner">   
    '.$instructions.'
</div></div>

<div id="tabcontent3" class="nftab tab-changelog ui-helper-hidden ui-filter-select">
<h1>'.JText::_('CHANGELOG').'</h1> 
<div class="inner">
';
    $i = 0;
    $changelog = $xml['changelog'];
    $count = count($changelog->children());
    $count = 2;
    foreach($changelog->children() as $log):
    	 $i++;

    	//$separator = $i.$count;
    	//$children = $log[$i];
    	//die(print_r($log, true));
    	//$children = $children->children();
    	//$test = print_r($children->children(), true);
    	$version = ($log->attributes('version') ? '<p><b>'.JText::_('Version:').'</b> '.$log->attributes('version').'</p>' : '<p><b>'.JText::_('Version:').'</b> '.$xml['version'].'</p>' );
    	$date = ($log->attributes('date') ? '<p><b>'.JText::_('Date:').'</b> '.$log->attributes('date').'</p>' : '' );
    	$state = ($log->attributes('state') ? '<p><b>'.JText::_('State:').'</b> '.$log->attributes('state').'</p>' : '' );
    	$changes = '<ul>';
    	foreach($log->children() as $child)
    	{
    		$changes .= '<li>'.$child->data().'</li>';
    	}
    	$changes .= '</ul>';
    	$return .= '<div>'.$version.$date.$state.$changes.'</div>';
    	unset($email);
    endforeach;
    unset($i);
    unset($separator);
    $return .= '
</div></div>
<span class="dashboard-footer">
<a href="http://www.ninjaforge.com" target="_self"><img  class="buttons" src="'.JURI::root().$imgpath.'ninjaforge.png" alt="Visit NinjaForge" title="Visit Ninjaforge"/></a>
<a href="http://jcd-a.org" target="_self"><img class="buttons" src="'.JURI::root().$imgpath.'jcda.png" alt="NinjaForge is a JCDA Member" title="NinjaForge is a JCDA Member"/></a>
<a href="http://www.mozilla-europe.org/en/firefox/" target="_self"><img class="buttons" src="'.JURI::root().$imgpath.'firefox3.png" alt="Get Firefox for a better internet experience" title="Get Firefox for a better internet experience"/></a>
<a href="http://getfirebug.com/" target="_self"><img class="buttons" src="'.JURI::root().$imgpath.'firebug.png" alt="Ninjas use and recommend Firebug" title="Ninjas use and recommend Firebug"/></a>
<a href="http://validator.w3.org/check?uri=referer" target="_self"><img  class="buttons" src="'.JURI::root().$imgpath.'validation_xhtml.png" alt="Valid XHTML Transitional" title="Valid XHTML Transitional"/></a>
<a href="http://jigsaw.w3.org/css-validator/check/referer" target="_self"><img  class="buttons" src="'.JURI::root().$imgpath.'validation_css.png" alt="Valid CSS" title="Valid CSS"/></a>
<a href="http://creativecommons.org/licenses/by-nc-sa/3.0/us/"><img class="buttons" alt="Creative Commons License" src="'.JURI::root().$imgpath.'byncsa.png" /></a>
<a href="http://creativecommons.org/licenses/LGPL/2.1/"><img  class="buttons" alt="CC-GNU GPL" src="'.JURI::root().$imgpath.'gnugpl.png" /></a>
</span>
<script type="text/javascript">
	jQuery(function($) {
  		$("#'.$control_name.$name.'").parent().appendTo("#menu-pane");
	});
</script>';
		if($this->_parent->get('dashboardStyle')) {	
			$return .= '</div><style type="text/css"> 

		
  
    #'.$control_name.$name.'{ border:1px solid #dddddd; }
  </style>
  </div>';
  
  
			$return .= $panel->startPanel(JText :: _('This is a workaround.'), "hideme");
		}
		$doc->addScriptDeclaration($script);
		//filter shortcut
        function f($filterme)
        {
        	return JFilterOutput::linkXHTMLSafe($filterme);
        }
		return f($return);
	}
	
	function fetchToolTip()
	{
		return false;
	}
}