<?php
/**
* @version		$Id: author.php 10381 2008-06-01 03:35:53Z pasamio $
* @package		Joomla
* @subpackage	Articles
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
 
class JElementLoadGroup extends JElement
{
	/**
	 * Element name
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'LoadGroup';
	
	function fetchElement($name, $value, &$node, $control_name)
	{	
		if(!$node->attributes('secret') || JRequest::getBool($node->attributes('secret')))
		{
			$order = ( $node->attributes('order')=='after' ? 'after' : 'before' );
			$label = ( $node->attributes('label') ? $node->attributes('label') : 'Layout Parameters' );
			$doc = & JFactory::getDocument();		
			$style = "
		#$control_name$name-tabs {
			border-top-width: 0px;
			border-right-width: 0px;
			border-bottom-width: 0px;
			border-left-width: 0px;
		}";
			$doc->addStyleDeclaration($style);
	
			$id 	= JRequest::getInt('id');
			if (!$id) { 
				$id = reset(JRequest::getVar( 'cid', array())); 
			}
			$values = $this->_parent->_raw;
			
			//Get the module name, in a slightly hacky way.
			$module		= JRequest::getWord('module');
			$mod		=& JTable::getInstance('Module', 'JTable');
			if ($id) {
				$mod->load($id);
				$modname = $mod->module;
			} elseif($module) {
				$modname = $module;
			}
			nimport('napi.html.parameter');
			$load = new NParameter($values, JPATH_ROOT.DS.'modules'.DS.$modname.DS.$modname.'.xml');
	
			$content = $load->renderFieldset('params', $value, $node->attributes('suffix'));
			
			$container = ( $node->attributes('panel') ? "
			<div id='$control_name$name' class='panel ui-widget ui-widget-content'>
				<h3 class='title jpane-toggler' id='$name-page'>
					<span>".JFilterOutput::ampReplace($label)."</span>
				</h3>
				<div class='jpane-slider ui-widget-content content' style='background:transparent;'>$content</div>
			</div>" 
			: 
			" <div id='$control_name$name'>$content</div>" );
			
			$script = "
				jQuery.noConflict();
	 
				jQuery(document).ready(function($){
					$('#$control_name$name').closest('.pane-sliders > .panel').$order($('#$control_name$name'));
				});
				";
			$doc->addScriptDeclaration($script);
			
			
			return $container;	
		}
		else
		{
			return false;
		}
	}
	
	function fetchToolTip()
	{
		return false;
	}
}