<?php
/**
* @version		$Id: text.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a text element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementSpinner extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'spinner';

	function fetchElement($name, $value, &$node, $control_name)
	{
		/*
         * Required to avoid a cycle of encoding &
         * html_entity_decode was used in place of htmlspecialchars_decode because
         * htmlspecialchars_decode is not compatible with PHP 4
         */
        $value = htmlspecialchars(html_entity_decode($value, ENT_QUOTES), ENT_QUOTES);
		$doc = & JFactory::getDocument();
		$size = ( $node->attributes('size') ? 'size="'.$node->attributes('size').'"' : '' );
		$jqui = ( $node->attributes('ui') ? 'text ui-widget-content ui-corner-all preview ' : 'text_area preview' );
		$class = ( $node->attributes('class') ? ' class="'.$jqui.$node->attributes('class').' ui-spinner"' : ' class="ui-spinner '.$jqui.'"' );
		$placeholder = ( $node->attributes('placeholder') ? ' placeholder="'.$node->attributes('placeholder').'"' : ' ' );
		
		$options = null;
		if($value) { $options[] = 'start: \''.$value.'\''; }
		if($node->attributes('min')==='0'||$node->attributes('min')) { $options[] = 'min: \''.$node->attributes('min').'\''; }
		if($node->attributes('max')) { $options[] = ' max: \''.$node->attributes('max').'\''; }
		if($node->attributes('step')) { $options[] = ' step: \''.$node->attributes('step').'\''; }
		if($node->attributes('decimals')) { $options[] = ' decimals: \''.$node->attributes('decimals').'\''; }
		$opt = null;
		if($options) {$opt 	   = '{'.implode(',', $options).'}'; }

		if(!defined(( $node->attributes('instance') ? $node->attributes('instance') : $name )))
		{
			$script = "
				jQuery(document).ready(function($){
					$('#$control_name$name').spinner($opt);
				});
			";
			$doc->addScriptDeclaration($script);
			define(( $node->attributes('instance') ? $node->attributes('instance') : $name ), 1);
		}

		return ' <span class="ui-helper-inherit ui-state-default nj-spinner-value ui-corner-all"><input type="text" name="'.$control_name.'['.$name.']" id="'.$control_name.$name.'"'.$placeholder.' value="'.$value.'" '.$class.' '.$size.' /></span>';
	}
}