<?php
/**
 * @version		$Id: parameter.php 10707 2008-08-21 09:52:47Z eddieajau $
 * @package		Joomla.Framework
 * @subpackage	Parameter
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class NJPlugin
{
	function renderParams($name, $value, $node, $control_name)
	{
		return false;
	}
	
	function render($type, $params, $module)
	{
		$this->onBeforeRender($params, $module);
		$plugin =& $this->loadPlugin($type, $params, $module);
		
		// error happened
		if ($plugin === false)
		{
			$result = JText::_('Plugin not defined for type').' = '.$type;
			return $result;
		}

		return $plugin->render($this->_items, $this->_module, $this->_params);
	}
	
	function onBeforeRender()
	{
		return;
	}
	
	function &loadPlugin( $type, $params, $module, $new = false )
	{
		$false = false;
		$signature = md5( $type  );
		
		if( (isset( $this->_plugins[$signature] ) && !is_a($this->_plugins[$signature], '__PHP_Incomplete_Class'))  && $new === false ) {
			return	$this->_plugins[$signature];
		}
		
		$pluginClass	=	get_class($this).$type;
		if( !class_exists( $pluginClass ) )
		{
			if( isset( $this->_pluginPath ) ) {
				$dirs = $this->_pluginPath;
			} else {
				$dirs = array();
			}

			$file = JFilterInput::clean(str_replace('_', DS, $type).'.php', 'path');
			//die(dirname(__FILE__).DS.$this->_name.$file.this->_pluginPath);
			jimport('joomla.filesystem.path');
			if ($pluginFile = JPath::find($dirs, $file)) {
				include_once $pluginFile;
			} else {
				return $false;
			}
		}

		if( !class_exists( $pluginClass ) ) {
			die($pluginClass);
			return $false;
		}

		$this->_plugins[$signature] = new $pluginClass($this);
		
		return $this->_plugins[$signature];
	}
	
	function thumbpath($name)
	{
		return JURI::root(true).'/media/napi/img/plugins/'.$name.'/';
	}
}

class NJPluginHelper
{
	function renderParams($plugin_name, $name, $value, $node, $control_name)
	{	
		$classpath	= 'napi.plugins.'.$plugin_name;
		$classname	= 'NJPlugin'.$plugin_name;
		nimport($classpath);
		
		
		$plugin = new $classname();
		return $plugin->renderParams($name, $value, $node, $control_name);
	}
	function render($plugin_name, $name, $params, $module)
	{
		$classpath	= 'napi.plugins.'.$name;
		$classname	= 'NJPlugin'.$name;
		nimport($classpath);
		
		$plugin = new $classname();
		return $plugin->render($plugin_name, $params, $module);
	}
}