<?php
/**
 * @version		$Id: parameter.php 10707 2008-08-21 09:52:47Z eddieajau $
 * @package		Joomla.Framework
 * @subpackage	Parameter
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// Check to ensure this file is within the rest of the framework
defined('_JEXEC') or die('Restricted access');

nimport('napi.plugin');

//Register the element class with the loader
JLoader::register('JElement', dirname(__FILE__).DS.'parameter'.DS.'element.php');

/**
 * Parameter handler
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcase extends NJPlugin
{
	
	function renderParams($name, $value, $node, $control_name)
	{
		$thumbpath = $this->thumbpath('showcase');
		
		
		jimport( 'joomla.filesystem.folder' );
		jimport( 'joomla.filesystem.file' );
		
		// path to images directory
		$path		= ( $node->attributes('directory') ? JPATH_ROOT.DS.$node->attributes('directory') : JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'napi'.DS.'plugins'.DS.'showcase' );
		$exclude	= $node->attributes('exclude');
		$files		= JFolder::files($path, '\.xml$');

		$options 	= array ();
		$children 	= '';
		$params     = '';
		foreach ($files as $option)
		{					
			nimport('napi.application.helper');
			$xml = NApplicationHelper::parseXMLFile($path.DS.$option);
			
			$val	= JFile::stripext($option);
			$text	= $xml['name'];
			
			$active = ( $value===$val ? ' active' : '' );
			$children  .= ' <div id="'.$val.'" class="thumb ui-corner-all'.$active.'"><img src="'.$thumbpath.$val.'.png" title="'.JText::sprintf('%s plugin', $val).'" alt="'.JText::sprintf('%s plugin', $val).'" class="ui-corner-all"><span>'.JText::_($text).'</span></div>';
			
			$form 	= new NParameter('', $path.DS.$option);							
			// Set base path
			$form->_elementPath[] = JPATH_PLUGINS.DS.'system'.DS.'napi'.DS.'elements';
			
			$params 			.= $form->renderFieldset('params', '_default', '', ($name.' paramlist fl f-select l-'.JFilterOutput::stringURLSafe($text)));

		}
		$html    = '
<div id="'.$control_name.$name.'" class="scrollable-wrap ui-corner-all panel">
	<!-- navigator -->
	<div class="navi"></div>
	
	<!-- prev link -->
	<a class="prevPage ui-icon ui-icon-circle-triangle-w"></a>
	
	<!-- root element for scrollable -->
	<div class="scrollable">
		<!-- root element for the items -->
		<div class="items">
			'.$children .'
		</div>
		
	</div>
	
	<!-- next link -->
	<a class="nextPage ui-icon ui-icon-circle-triangle-e"></a>
	<!-- power tag: let rest of the page layout normally --> 
	<input type="hidden" name="'.$control_name.'['.$name.']" id="'.$control_name.$name.'-val" value="'.$value.'" />
	<div style="display:block;clear:both;width:100%;"></div>
	<!--<div class="scrollable-status">Test</div>-->
</div>';
		
		$doc = & JFactory::getDocument();
		$doc->addScript(JURI::root(true)."/media/napi/js/jquery.scrollable-1.0.2.min.js");
		$doc->addScript(JURI::root(true)."/media/napi/js/jquery.mousewheel.js");
		$doc->addStyleSheet(JURI::root(true).'/media/napi/css/scrollable-minimal.css');
	
		$script = "
		jQuery.noConflict();
 
		jQuery(document).ready(function($){
			$(window).load(function () {
					$('#$control_name$name div.scrollable .items div.active').triggerHandler('click');
				});
			$('#$control_name$name div.scrollable .items div').live('click', function() {
				$('#$control_name$name-val').val($('#$control_name$name div.scrollable .items div.active').attr('id'));
			});
			$('#$control_name$value').prependTo('#menu-pane');
			$('#$control_name$name div.scrollable').scrollable({size: Math.floor($('#$control_name$name .scrollable').width()/$('#$control_name$name .scrollable .items > :first').outerWidth(true)) });
	    	
	    	//Initiate first theme
	    	var api = $('#$control_name$name div.scrollable').scrollable();
	    	var mainNavLinks = $('#$control_name$name div.scrollable .items .thumb');
			mainNavLinks.one('click', function(){
				api.seekTo(mainNavLinks.index(this));
			});
		});";
		
		$doc->addScriptDeclaration($script);
		return $html.$params;
	}
	
	function onBeforeRender(&$params, &$module)
	{
		$this->_name = 'showcase';
		$this->_pluginPath[] = dirname(__FILE__).DS.$this->_name;
		
		//Register the item class with the loader
		//JLoader::register('NModulePlugin', $this->path($module->module));
		$this->_params = $params;
		$this->_module = $module;
		
		$test = 0;
		$items 	= array();
		$iexplode 		= explode(',', $params->get('items'));
		$before = count($iexplode);
		foreach($iexplode as $i)
		{
			switch( $params->get('model'.$i) )
			{
				case 'article':
							//Create com_content table instance for getting content items
							if(!isset($article))
							{
								$article =& JTable::getInstance('content');
							}
							
							$article->load($params->get('article'.$i));
							$items[$i]['title']   = $params->get('title'.$i);
							$items[$i]['content'] = $article->introtext ? JHTML::_('content.prepare', $article->introtext ) : null;
							break;
				case 'image':
							$items[$i]['title']   = $params->get('title'.$i);
							$items[$i]['content'] = $params->get('image'.$i);
							break;
				case 'module':			
							//Needed objects to load modules
							if(!isset($getmod, $doc, $renderer, $user, $aid, $Itemid))
							{
								global $Itemid;
								$getmod     = &JTable::getInstance('Module', 'JTable');
								$doc 		= &JFactory::getDocument();
								$renderer	= $doc->loadRenderer('module');
								$user	    =& JFactory::getUser();
								$aid        = $user->get('aid', 0);
							}
							
							if(!isset($modets))
								{
									$modets = array();
									foreach($iexplode as $e)
									{
										if($params->get('model'.$e) == 'module')
										{
											$modets[] = ' m.id = '.$params->get('module'.$e).' ';
										}
									}
									$modets = implode('OR', array_unique($modets));
								} 
							
							$getmod->load($params->get('module'.$i));
							$items[$i]['title']   = $params->get('title'.$i);
							$getmodparams		= array('style'=>$this->_module->style);
							//die($modets);
							$modules = $this->getModules($modets);
							
							foreach ($modules as $mod)  {
							//echo ' <p>count='.count($modules).'&id='.$mod->id.'&itemid='.$mod->itemid.'</p>&nbsp;';
								if ($getmod->id === $mod->id)
								{
									$file					= $mod->module;
									$custom 				= substr( $file, 0, 4 ) == 'mod_' ?  0 : 1;
									$mod->user = $custom;
									if(is_null($mod->user)) 
									{
										die($getmod->user.$mod->content);
									}
//echo $Itemid.'&nbsp;'.$mod->itemid.'&nbsp;&nbsp;&nbsp;&nbsp;';
									if(!$params->get('module_respect_access'.$i, 0)) { 
										$mod->access = $aid;
									} 
									if($params->get('module_render_unpublished'.$i, 1)) { 
										$mod->published = 1;
									} 
									if($params->get('module_override_itemid'.$i, 1)) {
										$mod->itemid = $Itemid;
									}
									//die('test'.$Itemid.'test');
									if( ($aid >= $mod->access) && $mod->published && ($mod->itemid == 0 || $mod->itemid == $Itemid) ) {
										$items[$i]['content'] = JHTML::_('content.prepare', $renderer->render($mod, $getmodparams));
									} else {
										$items[$i]['content'] = NULL;
									}
								}
							}
							break;
				case 'ninjamonials':
							//Ninjamonials support
							$ninjamonials = JComponentHelper::getComponent('com_ninjamonials', true);
							JTable::addIncludePath ( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_ninjamonials' . DS . 'tables' );
							$testimonial = & JTable::getInstance ( 'Ninjamonials', 'Table' );
							if (!$ninjamonials->enabled && !$testimonial->load($params->get('ninjamonials'.$i)))
							{
								break;
							}
							$testimonial->load($params->get('ninjamonials'.$i));
							$items[$i]['title']   = $params->get('title'.$i);
							$items[$i]['content'] = JHTML::_('content.prepare', ( $testimonial->summary ? $testimonial->summary : $testimonial->testimonial ));
							break;
				case 'k2-item':
							//K2 Support
							$k2 = JComponentHelper::getComponent('com_k2', true);
							JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'tables');
							$kitem = & JTable::getInstance('K2Item', 'Table');
							if (!$k2->enabled && !$kitem->load($params->get('k2item'.$i)))
							{
								break;
							}
							$kitem->load($params->get('k2item'.$i));
							$items[$i]['title']   = $params->get('title'.$i);
							$items[$i]['content'] = JHTML::_('content.prepare', $kitem->introtext);
							break;
				case 'zoo-item':
							//ZOO Support
							$zoo = JComponentHelper::getComponent('com_zoo', true);
							// load config
							require_once(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
							if (!$zoo->enabled && !$zitem->load($params->get('zooitem'.$i)))
							{
								break;
							}
							$zitem = new Item($params->get('zooitem'.$i));
							
							$items[$i]['title']   = $params->get('title'.$i);
							$items[$i]['content'] = JHTML::_('content.prepare', $zitem->search_data);
							break;
			}
			//Enter incremental number for items without a title
			if(!$items[$i]['title'])
				{
					$items[$i]['title'] = !isset($notitle) ? $notitle = 0 : ++$notitle;
				}
			//Remove empty items from output
			if(!isset($items[$i]['content'])) {
			//print_r($items);
				unset($items[$i]);
			}
			
		}
		//Function that account for removed items and reinstate the default open item
		$after = $before-count($items);
		if(($this->_params->get('items_special')-$after) >= 0) 
		{ 
			$this->_params->set('items_special', ($this->_params->get('items_special')-$after));
		}
		else if($after <= 0)
		{
			$this->_params->set('items_special', '0');
		}
		
		$this->_items = $items;
		//die('<pre>'.print_r($items, true).'</pre>');
	}
	function &getModule($name, $id = null )
    {
        $result        = null;
        $modules    = $this->_load();
        $total        = count($modules);
        for ($i = 0; $i < $total; $i++)
        {
            // Match the name of the module
            if ($modules[$i]->name == $name)
            {
                // Match the title if we're looking for a specific instance of the module
                if ( ! $id || $modules[$i]->id == $id )
                {
                    $result =& $modules[$i];
                    break;    // Found it
                }
            }
        }
 
        // if we didn't find it, and the name is mod_something, create a dummy object
        if (is_null( $result ) && substr( $name, 0, 4 ) == 'mod_')
        {
            $result                = new stdClass;
            $result->id            = 0;
            $result->title        = '';
            $result->module        = $name;
            $result->position    = '';
            $result->content    = '';
            $result->showtitle    = 0;
            $result->control    = '';
            $result->params        = '';
            $result->user        = 0;
        }
 
        return $result;
    }
    
    /**
	 * Get modules by position
	 *
	 * @access public
	 * @param string 	$position	The position of the module
	 * @return array	An array of module objects
	 */
	function &getModules($ids)
	{
		$result		= array();

		$result =& $this->_loadModules($ids);

		if(count($result) == 0) {
			if(JRequest::getBool('np')) {
				$result[0] = JModuleHelper::getModule( 'mod_'.$position );
				$result[0]->title = $position;
				$result[0]->content = $position;
				$result[0]->position = $position;
			}
		}

		return $result;
	}
    
    /**
	 * Load published modules
	 *
	 * @access	private
	 * @return	array
	 */
	function &_loadModules($overrides)
	{
		global $mainframe, $Itemid;

		static $modules;

		if (isset($modules)) {
			return $modules;
		}

		$user	=& JFactory::getUser();
		$db		=& JFactory::getDBO();

		$aid	= $user->get('aid', 0);

		$modules	= array();
		
		$overridequery = ($overrides ? ' AND '.$overrides : '' );

		$wheremenu = isset( $Itemid ) ? ' AND ( mm.menuid = '. (int) $Itemid .' OR mm.menuid = 0 ) '. $overridequery .' ' : '';

		$query = 'SELECT id, title, module, position, content, showtitle, control, params, access, published, mm.menuid, mm.moduleid'
			. ' FROM #__modules AS m'
			. ' LEFT JOIN #__modules_menu AS mm ON mm.moduleid = m.id'
//			. ' WHERE m.published = 1'
//			. ' AND m.access <= '. (int)$aid
			//Original function below
//			. ' AND m.client_id = '. (int)$mainframe->getClientId()
			. ' WHERE m.client_id = '. (int)$mainframe->getClientId()
			. $wheremenu
			. ' ORDER BY id, position, ordering';

		$db->setQuery( $query );
		//die('<pre>'.$query.'</pre>');
		if (null === ($modules = $db->loadObjectList())) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_( 'Error Loading Modules' ) . $db->getErrorMsg());
			return false;
		}
		//die('<pre>'.count($modules).print_r($modules, true).'</pre>');
		$total = count($modules);
		//die('total '.$Itemid);
		for($i = 0; $i < $total; $i++)
		{
			//determine if this is a custom module
			$file					= $modules[$i]->module;
			$custom 				= substr( $file, 0, 4 ) == 'mod_' ?  0 : 1;
			$modules[$i]->user  	= $custom;
			$modules[$i]->access  	= $modules[$i]->access;
			$modules[$i]->itemid  	= $modules[$i]->menuid;
			$modules[$i]->published	= $modules[$i]->published;
			// CHECK: custom module name is given by the title field, otherwise it's just 'om' ??
			$modules[$i]->name		= $custom ? $modules[$i]->title : substr( $file, 4 );
			$modules[$i]->style		= null;
			$modules[$i]->position	= strtolower($modules[$i]->position);
		}

		return $modules;
	}
}

/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcaseTemplate
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = null;

	/**
	* reference to the object that instantiated the element
	*
	* @access	protected
	* @var		object
	*/
	var	$_parent = null;

	/**
	 * Constructor
	 *
	 * @access protected
	 */	
	function __construct($parent = null) {
		$this->_parent = $parent;
	}

	/**
	* get the element name
	*
	* @access	public
	* @return	string	type of the parameter
	*/
	function getName() {
		return $this->_name;
	}
	
	function render(&$items, &$module, &$params)
	{
		$return = null;
		foreach($items as $key => $item)
		{
			$return .= $this->fetchItem($item, $key, &$module, &$params);
			
		}
		return $this->fetchItems(&$return, &$module, &$params);
	}
	
	function fetchItem($item, $id, $module, $params)
	{
		return $item['content'];
	}
	
	function fetchItems($items, $module, $params)
	{
		return $items;
	}
}