<?php
/**
* @version		$Id: element.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );


/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcase3DCarousel extends NJPluginShowcaseTemplate
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = '3dcarousel';
	
	function fetchItem($item, $id, $module, $params)
	{
		return '<div>'.$item['content'].'</div>';
	}
	
	function fetchItems($items, $module, $params)
	{	
		
		// Setup options object
		$options				= array();
		$options['speed']		= ($params->get('3dcarouselspeed') ? $params->get('3dcarouselspeed') : null);
		$options['basespeed']	= ($params->get('3dcarouselbasespeed') ? $params->get('3dcarouselbasespeed') : null);
		$width 					= $params->get('3dcarouselwidth');
		$options['width']		= ($width ? ( ( substr($width, -2) == 'px') ? $width : $width.'px' ) : '');
		$height 				= $params->get('3dcarouselheight');
		$options['height']		= ($width ? ( ( substr($height, -2) == 'px') ? $height : $height.'px' ) : '');
		$options['radiusx']		= ($params->get('3dcarouselradiusx') ? $params->get('3dcarouselradiusx') : null);
		$options['radiusy']		= ($params->get('3dcarouselradiusy') ? $params->get('3dcarouselradiusy') : null);
		$options['centerx']		= ($params->get('3dcarouselcenterx') ? $params->get('3dcarouselcenterx') : null);
		$options['centery']		= ($params->get('3dcarouselcentery') ? $params->get('3dcarouselcentery') : null);
		
		$return  = ' <div id="'.$module->name.'-'.$module->id.'" class="nj-3d-carousel" style="'.( $options['width'] ? 'width: '.$options['width'].';' : '' ).( $options['height'] ? 'height: '.$options['height'].';' : '' ).'">';
		$return .= $this->script($module->name.'-'.$module->id, $options, $params->get('stylepicker'));
		$return .= $items;
		$return .= '</div>';
		return $return;
	}
	
	function script($selector='3dcarousel', $params = array(), $css = null)
	{
		static $carousels;
		static $included;
		
		
		$document =& JFactory::getDocument();

		// Load the necessary files if they haven't yet been loaded
		if (!isset($included)) {

			// Load the javascript and css
			JHTML::_('behavior.mootools');
//			JHTML::script('jquery.eye.js', NAPI_JS.'/spacegallery/', false);
//			JHTML::script('jquery.utils.js', NAPI_JS.'/spacegallery/', false);
//			JHTML::script('jquery.spacegallery.js', NAPI_JS.'/spacegallery/', false);
			if($css) {
			$document->addStyleSheet($css);
			} else {
				JHTML::stylesheet('3dcarousel.css', NAPI_CSS.'/widgets/');
			}
			
			$included = true;
		}

		if (!isset($carousels)) {
			$carousels = array();
		}

		$sig = md5(serialize(array($selector,$params)));
		if (isset($carousels[$sig]) && ($carousels[$sig])) {
			return;
		}

		// Setup options object
		$opt['speed']		= (isset($params['speed'])) ? $params['speed'] : '0.3';
		$opt['baseSpeed']		= (isset($params['basespeed'])) ? $params['basespeed'] : '0.05';
		$opt['width']		= (isset($params['width'])) ? $params['width'] : '550px';
		$opt['heigt']		= (isset($params['height'])) ? $params['height'] : '300px';
		$opt['radiusx']	= (isset($params['radiusx'])) ? $params['radiusx'] : '190';
		$opt['radiusy']	= (isset($params['radiusy'])) ? $params['radiusy'] : '42';
		$opt['centerx']		= (isset($params['centerx'])) ? $params['centerx'] : '245';
		$opt['centery']		= (isset($params['centery'])) ? $params['centery'] : '120';

		//$options = JHTMLBehavior::_getJSObject($opt);

		// Attach modal behavior to document
		$document->addScriptDeclaration("
		var count = 0; 
		var baseSpeed = ".$opt['baseSpeed']."; 
		var radiusX = ".$opt['radiusx']."; 
		var radiusY = ".$opt['radiusy']."; 
		var centerX = ".$opt['centerx']	."; 
		var centerY = ".$opt['centery'].";
		var speed   = ".$opt['speed'].";
		var imageDivs = '';
		var numberOfElements = 0;
		var carousel = '';
		 
		 
		window.addEvent('domready', function(){
		  
			carousel = $('$selector');
		 
			imageDivs = carousel.getElementsByTagName('div'); 
			numberOfElements = imageDivs.length; 
			
			setInterval('startCarousel()',40);
			
		});
		 
		 
		function startCarousel(){
			const1 = ( Math.PI * 2 ) / numberOfElements; 
			const2 = count * ( baseSpeed * speed );
			//console.log(count);
			angle = 0;
			for(i=0; i < numberOfElements; i++){
				imageDivsStyle = imageDivs[ i ].style; 
				imageDivsStyle.position='absolute'; 
				
				const3 = const2 + angle; /* (this eliminates 1 addition)*/
				angle += const1;
				posX = ( Math.sin( const3 )* radiusX + centerX );
				posY = ( Math.cos( const3 )* radiusY + centerY );
				
				imageDivsStyle.left = posX+'px'; 
				imageDivsStyle.top = posY+'px'
				
				imageDivWidth = posY/2;
				imageDivZIndex = Math.round(imageDivWidth)+100;
				
				imageDivsStyle.width = imageDivWidth+'px';
				imageDivsStyle.zIndex = imageDivZIndex;
			}
			count++
		}
		
		");

		// Set static array
		$carousels[$sig] = true;
		return;
	}
}
