<?php
/**
* @version		$Id: element.php 10707 2008-08-21 09:52:47Z eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );


/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NModulePlugin3DCarousel extends NModulePlugin
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = '3dcarousel';
	
	function fetchItem($item, $id, $module, $params)
	{
		return '<div>'.$item['content'].'</div>';
	}
	
	function fetchItems($items, $module, $params)
	{	
		
		// Setup options object
		$options				= array();
		$options['speed']		= ($params->get('3dcarouselspeed') ? $params->get('3dcarouselspeed') : null);
		$options['basespeed']	= ($params->get('3dcarouselbasespeed') ? $params->get('3dcarouselbasespeed') : null);
		$width 					= $params->get('3dcarouselwidth');
		$options['width']		= ($width ? ( ( substr($width, -2) == 'px') ? $width : $width.'px' ) : '');
		$height 				= $params->get('3dcarouselheight');
		$options['height']		= ($width ? ( ( substr($height, -2) == 'px') ? $height : $height.'px' ) : '');
		$options['radiusx']		= ($params->get('3dcarouselradiusx') ? $params->get('3dcarouselradiusx') : null);
		$options['radiusy']		= ($params->get('3dcarouselradiusy') ? $params->get('3dcarouselradiusy') : null);
		$options['centerx']		= ($params->get('3dcarouselcenterx') ? $params->get('3dcarouselcenterx') : null);
		$options['centery']		= ($params->get('3dcarouselcentery') ? $params->get('3dcarouselcentery') : null);
		
		$return  = ' <div id="'.$module->name.'-'.$module->id.'" class="nj-3d-carousel" style="'.( $options['width'] ? 'width: '.$options['width'].';' : '' ).( $options['height'] ? 'height: '.$options['height'].';' : '' ).'">';
		$return .= JHTML::_('3dcarousel.init', $module->name.'-'.$module->id, $options, $params->get('stylepicker'));
		$return .= $items;
		$return .= '</div>';
		return $return;
	}
}
