<?php
/**
* @version		$Id: element.php 10$id0$id 2008-08-21 09:52:4$idZ eddieajau $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined ( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );


/**
 * Parameter base class
 *
 * The JElement is the base class for all JElement types
 *
 * @abstract
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */
class NJPluginShowcaseNoobSlide extends NJPluginShowcaseTemplate
{
	/**
	* element name
	*
	* This has to be set in the final
	* renderer classes.
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'noobslide';
	
	var $_thumbs = null;
	
	function render(&$items, &$module, &$params)
	{
		$return = null;
		$this->_items = $items;
		$this->_count = count($items);
		$this->_item_width = 100/($this->_count+1);
		$this->_default = $params->get('items_special');
		$this->_thumbs = null;
		foreach($items as $key => $item)
		{
			$return .= $this->fetchItem($item, $key, &$module, &$params);
			$this->_thumbs .= $this->fetchItemThumb($item, $key, &$module, &$params);
		}
		return $this->fetchItems(&$return, &$module, &$params);
	}
	
	function fetchItem($item, $id, $module, $params)
	{
		return '			<span style="width:'.$this->_item_width.'%;">'.$item['content'].'</span>'."\n";
	}
	
	function fetchItemThumb($item, $id, $module, $params)
	{
		return '			<div>'.$item['content'].'</div>'."\n";
	}
	
	function fetchItems($items, $module, $params)
	{	
		$width   = $this->_count*90;
		foreach(range(1, $this->_count) as $i) {
			$handles[] = '			<span></span>';
		}
		$return = '
<div class="sample noobslide" style="margin: 0px 0px 0px 0px;padding: 2%;position: relative;">
	<div class="mask6" id="mask'.$module->id.'">
		<div class="box7" id="box'.$module->id.'">
'.$items.'
		</div>
	</div>

	<div class="thumbs7" id="thumbs'.$module->id.'">
		<div class="thumbs thumbs_items7" id="thumbs_items'.$module->id.'" style="width:'.$width.'px;">
'.$this->_thumbs.'
		</div>

		<div class="thumbs_mask7" id="thumbs_mask'.$module->id.'"></div>

		<p class="thumbs_handles7" id="thumbs_handles'.$module->id.'" style="width:'.$width.'px;">
'.implode($handles, "\n").'
		</p>
	</div>
</div>';

		$return .= $this->script($module->id);
		return $return;
	}
	
	function script($id)
	{
		static $carousels;
		static $included;

		$document =& JFactory::getDocument();

		// Load the necessary files if they haven't yet been loaded
		if (!isset($included)) {

			// Load the javascript and css
			JHTML::_('behavior.mootools');
			JHTML::script('mootools.noobslide.js', NAPI_JS.'/noobslide/', false);
			JHTML::stylesheet('style.css', NAPI_CSS.'/noobslide/');

			$included = true;
			$document->addScriptDeclaration('
	var '.__CLASS__.' = new Class({
	    initialize: function(instance, count, walkTo, items, size){
	        this.startItem = count;
	        this.thumbs_items = $(\'thumbs_items\'+instance).setStyle(\'left\',(this.startItem*60*-1)+\'px\');
	        this.thumbs_handles = $(\'thumbs_handles\'+instance).setStyle(\'left\',(this.startItem*60*-1)+\'px\');
			this.fxOptions = {duration:1000, transition:Fx.Transitions.Back.easeOut, wait:false}
			var thumbsFx = new Fx.Style(this.thumbs_handles,\'left\',this.fxOptions);
			var itemsFx = new Fx.Style(this.thumbs_items,\'left\',this.fxOptions);
			var nS = new noobSlide({
				box: $(\'box\'+instance),
				size: size.size.x,
				items: items,
				handles: $ES(\'span\',\'thumbs_handles\'+instance),
				fxOptions: this.fxOptions,
				onWalk: function(currentItem){
					thumbsFx.start(currentItem*60*-1);
					itemsFx.start(currentItem*60*-1);
				},
				startItem: this.startItem
			});
			nS.walk(walkTo);
	    }
	});
			');
		}
		// Attach modal behavior to document
		$document->addScriptDeclaration("
	window.addEvent('domready',function(){
		var ".__CLASS__.$id." = new ".__CLASS__."($id, ".$this->_count.", ".$this->_default.", [".implode(range(0, $this->_count), ',')."], $('mask$id').getSize());
	});");
		return;
	}
}
