<?php
/**
 *  $Id: plg_ninja_shadowbox.php, 3 2009/01/29 10:24:55 +0100 uwalter Exp $
 *
 * Ninja Shadowbox 2.0
 * By Richie Mortimer & Uwe Walter
 * http://ninjaforge.com 
 * Shadowbox : (C) 2007 Michael J. I. Jackson GNU LGPL
 * Copyright (C) 2008 ninjaforge.com - Get on the Cutting Edge.
 * email: uwe@ninjforge.com
 * date: January 2009
 * Release: 2.0.2
 * License : http://www.gnu.org/copyleft/lgpl.html GNU/LGPL 
 *
 */
###################################################################
//Copyright (C) 2008 NinjaForge.com. All rights reserved.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
###################################################################

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die( "Direct Access Is Not Allowed" );
global $mainframe;

$mainframe->registerEvent( 'onAfterInitialise', 'plgSystemNinjaShadowbox' );

function plgSystemNinjaShadowbox() {

	global $mainframe;   

	// Don't load shadowbox at the back end.
	if (! $mainframe->isAdmin()) {

		$plugin =& JPluginHelper::getPlugin('system', 'ninja.shadowbox');
		$params = new JParameter( $plugin->params );   

		//module base
		$modbase = ''.JURI::base().'plugins/system/ninja.shadowbox/';
		$document =& JFactory::getDocument();

		// get the parameters and put them in an array
		$param = array(
			'forceValid'	=> $params->get('forceValid'),
			'core'			=> $params->get('core'),
			'lang'			=> $params->get('lang'),
			'jstype'		=> $params->get('jstype',''),
			'skin'			=> $params->get('skin'),
			'incjs'			=> $params->get('incjs'),
			'useadv'		=> $params->get('useadv')
		);
   
		//if advanced options is selected, populate the options
		//also populate the optionsjs for the other js librarys
		$options = $loadoptions = '';
		if ($param['useadv']) {
			$param['animate']			= $params->get('animate', '');
			$param['animateFade']		= $params->get('animateFade', '');
			$param['animSequence']		= $params->get('animSequence', '');
			$param['flvPlayer']			= $params->get('flvPlayer', '');
			$param['overlayColor']		= $params->get('overlayColor', '');
			$param['overlayOpacity']	= $params->get('overlayOpacity', '');
			$param['flashBgColor']		= $params->get('flashBgColor', '');
			$param['listenOverlay']		= $params->get('listenOverlay', '');
			$param['autoplayMovies']	= $params->get('autoplayMovies', '');
			$param['showMovieControls']	= $params->get('showMovieControls', '');
			$param['slideshowDelay']	= $params->get('slideshowDelay', '');
			$param['resizeDuration']	= $params->get('resizeDuration', '');
			$param['fadeDuration']		= $params->get('fadeDuration', '');
			$param['displayNav']		= $params->get('displayNav', '');
			$param['continuous']		= $params->get('continuous', '');
			$param['displayCounter']	= $params->get('displayCounter', '');
			$param['counterType']		= $params->get('counterType', '');
			$param['counterLimit']		= $params->get('counterLimit', '');
			$param['viewportPadding']	= $params->get('viewportPadding', '');
			$param['handleOversize']	= $params->get('handleOversize', '');
			$param['handleException']	= $params->get('handleException', '');
			$param['initialHeight']		= $params->get('initialHeight', '');
			$param['initialWidth']		= $params->get('initialWidth', '');
			$param['enableKeys']		= $params->get('enableKeys', '');
			$param['handleUnsupported']	= $params->get('handleUnsupported', '');

			$options  = ' var options = { ';
			$options .= !$param['animate']           ? 'animate: false,'									: '';
			$options .= !$param['animateFade']       ? 'animateFade: false,'								: '';
			$options .=  $param['animSequence']      ? 'animSequence: \''.$param['animSequence'].'\','		: '';
			$options .=  $param['flvPlayer']         ? 'flvPlayer: \''.$param['flvPlayer'].'\','			: '';
			$options .=  $param['overlayColor']      ? 'overlayColor: \''.$param['overlayColor'].'\','		: '';
			$options .=  $param['overlayOpacity']    ? 'overlayOpacity: '.$param['overlayOpacity'].','		: '';
			$options .=  $param['flashBgColor']      ? 'flashBgColor: \''.$param['flashBgColor'].'\','		: '';
			$options .= !$param['listenOverlay']     ? 'modal: false,'										: '';
			$options .= !$param['autoplayMovies']    ? 'autoplayMovies: false,'								: '';
			$options .= !$param['showMovieControls'] ? 'showMovieControls: false,'							: '';
			$options .=  $param['slideshowDelay']    ? 'slideshowDelay: \''.$param['slideshowDelay'].'\','	: '';
			$options .=  $param['resizeDuration']    ? 'resizeDuration: '.$param['resizeDuration'].','		: '';
			$options .=  $param['fadeDuration']      ? 'fadeDuration: '.$param['fadeDuration'].','			: '';
			$options .= !$param['displayNav']        ? 'displayNav: false,'									: '';
			$options .=  $param['continuous']        ? 'continuous: true,'									: '';
			$options .= !$param['displayCounter']    ? 'displayCounter: false,'								: '';
			$options .=  $param['counterType']       ? 'counterType: \''.$param['counterType'].'\','		: '';
			$options .=  $param['counterLimit']      ? 'counterLimit: \''.$param['counterLimit'].'\','		: '';
			$options .=  $param['initialHeight']     ? 'initialHeight: \''.$param['initialWidth'].'px\','	: '';
			$options .=  $param['initialWidth']      ? 'initialWidth: \''.$param['initialWidth'].'px\','	: '';
			$options .= !$param['enableKeys']        ? 'enableKeys: false,'									: '';
			$options .=  'handleOversize: \''.$param['handleOversize'].'\',';
			if ($param['handleException'] != 'null') { 
				$options .= 'handleException: \''.$param['handleException'].'\',';
			}
			$options .=  'handleUnsupported: \''.$param['handleUnsupported'].'\'';
			$options .= ' } ';

			$loadoptions = 'options';
		}

		//because none of the other js systems work as well as mootools, with the simple window.addevent option
		//we have to have some more code to make it work with the options
		$endload = '});';
		switch ($param['jstype']) {
			case "jquery":
				$onload = 'jQuery.noConflict(); jQuery(document).ready(function(){';
				break;
			case "dojo":
				$onload = 'dojo.addOnLoad(function(){';
				break;
			case "ext":
				$onload = 'Ext.onReady(function(){';
				break;
			case "prototype":
				$onload = 'Event.observe(window, \'load\',function() {';
				break;
			case "yui":
				$onload = 'window.onload = function() {';
				$endload = '};';
				break;
		}

		// Get player list.
		$players = array();
		if ($params->get('img'))    array_push($players, '"img"');
		if ($params->get('swf'))    array_push($players, '"swf"');
		if ($params->get('flv'))    array_push($players, '"flv"');
		if ($params->get('qt'))     array_push($players, '"qt"');
		if ($params->get('wmp'))    array_push($players, '"wmp"');
		if ($params->get('iframe')) array_push($players, '"iframe"');
		if ($params->get('html'))   array_push($players, '"html"');
    
		// Load language, skin and players.
		$jscode = '
		Shadowbox.loadSkin("'.$param['skin'].'", "'.$modbase.'js/skin");
		Shadowbox.loadLanguage("'.$param['lang'].'", "'.$modbase.'js/lang");
		Shadowbox.loadPlayer(['.implode(',', $players).'], "'.$modbase.'js/player");
		';

		//we also check to see if we have chosen advanced options and load the script accordingly
		$jscode .= ($param['useadv'])
				? "\t".$onload."\n\t\t".$options."\n\t\tShadowbox.init(options);\n\t".$endload
				: "\t".$onload."\n\t\twindow.onload = Shadowbox.init;\n\t".$endload;


		/**
		 * Regarding MooTools:
		 * At the plugin we load the MooTools framework by the JHTML::_('behavior.mootools'),
		 * because the addScript method is triggered BEFORE Joomla creates its own MooTools entry.
		 * If we load here the MooTools, Joomla recognizes that does load them only once.
		 *
		 * AND: We have to trigger the behavior method in any case, because otherwise the
		 *      jQuery.noConflict() method will fail! We need the right order!
		 */
		JHTML::_('behavior.mootools');

		// 2009-01-29: !!! Removed MooTools due to incompatibilities in IE. !!!
		//             !!! Shadowbox 2.0 needs MooTool 1.2.x for IE :-(     !!!

		//lets include the JS library the user has chosen
		if ($param['core']) {
			$document->addScript($modbase . "js/lib/".$param['jstype'].".js");
    
			//if were using ext, then lets put in the support library
			if ($param['jstype'] == "ext") {
				$document->addScript($modbase . "js/lib/ext-all.js");  
			} 
    
			//because prototype is no where near as good as mootools, or anyother library for that matter
			//we have to include scriptaculous and all its files
			if ($param['jstype'] == "prototype") {
				$document->addScript($modbase . "js/lib/scriptaculous/scriptaculous.js");
				$document->addScript($modbase . "js/lib/scriptaculous/builder.js");
				$document->addScript($modbase . "js/lib/scriptaculous/controls.js");
				$document->addScript($modbase . "js/lib/scriptaculous/dragdrop.js");
				$document->addScript($modbase . "js/lib/scriptaculous/effects.js");
				$document->addScript($modbase . "js/lib/scriptaculous/slider.js");
				$document->addScript($modbase . "js/lib/scriptaculous/sound.js");
				$document->addScript($modbase . "js/lib/scriptaculous/unittest.js");
			}
		}

		//if ($param['jstype'] != 'mootools') {
		// Include the shadowbox library our user has chosen and
		$document->addScript($modbase . "js/adapter/shadowbox-".$param['jstype'].".js");

		// Include the shadowbox main js file, if we are told to
		if ($param['incjs'])
			$document->addScript($modbase . "js/shadowbox.js");


		//wow and thats it!
		//lets stick it all in the head
		$document->addScriptDeclaration($jscode);

    } // End !isAdmin()
}
?>
