<?php

class removeInclHelperClass 
{

	function getUpdatedInclusions($inclusions, $filesStr)
	{
		if (!is_array($inclusions)) return $inclusions;
		
		$files = self::getFilesForRemoving($filesStr);
		if (count($files) == 0) return $inclusions;

		foreach ($inclusions as $incFile => $value)
		{
			$uIncFile = self::_updatePath($incFile);
			foreach ($files as $file)
			{
				if (strpos($uIncFile, $file) !== false) unset($inclusions[$incFile]);
			}
		}

		return $inclusions;
	}
	
	function getFilesForRemoving($filesStr)
	{
		$files = array();
		
		$tempFiles = explode("\n", $filesStr);
		
		foreach ($tempFiles as $file)
		{
			$file = trim($file);
			if (!empty($file)) $files[] = self::_updatePath($file);
		}

		return $files;
	}
	
	function _updatePath($file)
	{
		return str_replace('\\', '/', $file);
	}

}
?>