<?php
/**
 * Language Include File (English)
 * Can overrule set variables used in different elements
 *
 * @package    Articles Anywhere
 * @version    0.2.0
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/articlesanywhere
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Variables that can be overruled:
 * $image
 * $title
 * $description
 * $help
 */

if ( $description == 'Easily place articles anywhere in your site' ) {
	$description = '
		<p>Easily place articles anywhere in your site.</p>
		<p>You can place articles using the syntax:<br />
		Using the title of the article: {<span style="color:green">article</span> <span style="color:blue">Some article</span>}...{/<span style="color:green">article</span>}<br />
		Using the alias of the article: {<span style="color:green">article</span> <span style="color:blue">some-article</span>}...{/<span style="color:green">article</span>}<br />
		Using the id of the module: {<span style="color:green">article</span> <span style="color:blue">123</span>}...{/<span style="color:green">article</span>}</p>
		<p>Within those tags you can place different tags to place different article data/details:<br />
		{<span style="color:red">text</span>} (the entire text: introtext+fulltext)<br />
		{<span style="color:red">readmore</span>} (a read more link)<br />
		{<span style="color:red">url</span>} (the url to the article)<br />
		{<span style="color:red">introtext</span>}<br />
		{<span style="color:red">fulltext</span>}<br />
		{<span style="color:red">title</span>}<br />
		{<span style="color:red">id</span>}<br />
		Or any other data available (must match the column name in the database)</p>
		<p>When showing text (all text, introtext or fulltext), you can also make the tag only show a certain amount of caracters:<br />
		{<span style="color:red">text:100</span>} (shows the first 100 characters of the entire text)</p>
		<p>When showing read more link, you can also overrule the standar "Read more..." text:<br />
		{<span style="color:red">readmore:Please read on!</span>}</p>
		<p><em>The colors used in the examples are for readability. Do not use colors in the actual tags, because that will stop them from working.</em></p>
		';
}