<?php
/**
 * Main Plugin File
 * Does all the magic!
 *
 * @package    Articles Anywhere
 * @version    0.2.0
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/articlesanywhere
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.event.plugin' );

// Include the syndicate functions only once
if ( is_file( JPATH_SITE.DS.'plugins'.DS.'system'.DS.'articlesanywhere.php' ) ) {
	require_once JPATH_SITE.DS.'plugins'.DS.'system'.DS.'articlesanywhere.php';
}

/**
* Button Plugin that places Editor Buttons
*/
class plgButtonArticlesAnywhere extends JPlugin
{
	/**
	* Constructor
	*
	* For php4 compatability we must not use the __constructor as a constructor for
	* plugins because func_get_args ( void ) returns a copy of all passed arguments
	* NOT references. This causes problems with cross-referencing necessary for the
	* observer design pattern.
	*/
	function plgButtonArticlesAnywhere( &$subject, $config )
	{
		if ( !is_file( JPATH_SITE.DS.'plugins'.DS.'system'.DS.'articlesanywhere.php' ) ) {
			return;
		}

		parent::__construct( $subject, $config );

		// Load plugin parameters
		$params = new JParameter( $config['params'], JPATH_PLUGINS.DS.$config['type'].DS.$config['name'].'.xml' );
		$this->params = $this->getParamValues( $params );

		// Load plugin language
		$this->loadLanguage();
	}

	/**
	* Display the button
	*
	* @return array A two element array of ( imageName, textToInsert )
	*/
	function onDisplay( $name )
	{
		$mainframe = &JFactory::getApplication();

		$button = new JObject();

		if ( !$mainframe->isAdmin() ) {
			$enable_frontend = $this->params->enable_frontend;
			if ( !$enable_frontend ) {
				return $button;
			}
		}
		
		$document =& JFactory::getDocument();

		JHTML::_( 'behavior.modal' );

		$button_style = 'blank';

		if ( $this->params->button_icon ) {
			$button_style = 'articlesanywhere';
			$document->addStyleSheet( JURI::root( true ).'/plugins/editors-xtd/articlesanywhere/css/articlesanywhere.css' );
		}

		$link = 'index.php?option=com_nn_page'
			.'&folder=plugins.editors-xtd.articlesanywhere'
			.'&file=articlesanywhere.inc.php'
			.'&name='.$name;

		$button->set( 'modal', true );
		$button->set( 'link', $link );
		$button->set( 'text', JText::_( $this->params->button_text ) );
		$button->set( 'name', $button_style );
		$button->set( 'options', "{handler: 'iframe', size: {x:window.getSize().scrollSize.x-100, y: window.getSize().size.y-100}}" );

		return $button;
	}

	function getParamValues( &$params ) {
		$values = '';
		if ( isset( $params->_xml ) ) {
			foreach ( $params->_xml as $xml_group ) {
				foreach ( $xml_group->children() as $xml_child ) {
					$key = $xml_child->attributes('name');
					if ( !empty( $key ) && $key['0'] != '@' ) {
						$val = $params->get( $key );
						if ( !strlen( $val ) ) {
							$val = $xml_child->attributes('default');
							if ( $xml_child->attributes('type') == 'textarea' ) {
								$val = str_replace( '<br />', "\n", $val );
							}
						}
						$values->$key = $val;
					}
				}
			}
		}

		return $values;
	}
}