<?php
/**
 * Popup page
 * Displays a list with modules
 *
 * @package    Articles Anywhere
 * @version    0.2.0
 * @since      File available since Release v0.1.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/articlesanywhere
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$html = renderHTML();

function renderHTML()
{
	$mainframe = &JFactory::getApplication();

	require_once JPATH_ADMINISTRATOR.DS.'components'.DS.'com_content'.DS.'helper.php';

	// Initialize variables
	$db			=& JFactory::getDBO();
	$client	=& JApplicationHelper::getClientInfo( JRequest::getVar( 'client', '0', '', 'int' ) );
	$filter		= null;

	// Get some variables from the request
	$sectionid			= JRequest::getVar( 'sectionid', -1, '', 'int' );
	$redirect			= $sectionid;
	$option				= JRequest::getCmd( 'option' );
	$context			= 'com_content.viewcontent';
	$filter_order		= $mainframe->getUserStateFromRequest( $context.'filter_order',		'filter_order',		'',	'cmd' );
	$filter_order_Dir	= $mainframe->getUserStateFromRequest( $context.'filter_order_Dir',	'filter_order_Dir',	'',	'word' );
	$filter_state		= $mainframe->getUserStateFromRequest( $context.'filter_state',		'filter_state',		'',	'word' );
	$catid				= $mainframe->getUserStateFromRequest( $context.'catid',			'catid',			0,	'int' );
	$filter_authorid	= $mainframe->getUserStateFromRequest( $context.'filter_authorid',	'filter_authorid',	0,	'int' );
	$filter_sectionid	= $mainframe->getUserStateFromRequest( $context.'filter_sectionid',	'filter_sectionid',	-1,	'int' );
	$search				= $mainframe->getUserStateFromRequest( $context.'search',			'search',			'',	'string' );
	$search				= JString::strtolower($search);

	$limit		= $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
	$limitstart	= $mainframe->getUserStateFromRequest($context.'limitstart', 'limitstart', 0, 'int');

	// In case limit has been changed, adjust limitstart accordingly
	$limitstart = ( $limit != 0 ? (floor($limitstart / $limit) * $limit) : 0 );

	//$where[] = "c.state >= 0";
	$where[] = 'c.state != -2';

	if (!$filter_order) {
		$filter_order = 'section_name';
	}
	if ($filter_order == 'c.ordering') {
		$order = ' ORDER BY section_name, cc.title, c.ordering '. $filter_order_Dir;
	} else {
		$order = ' ORDER BY '. $filter_order .' '. $filter_order_Dir .', section_name, cc.title, c.ordering';
	}
	$all = 1;

	if ($filter_sectionid >= 0) {
		$filter = ' WHERE cc.section = '. (int) $filter_sectionid;
	}
	$section->title = 'All Articles';
	$section->id = 0;

	/*
	 * Add the filter specific information to the where clause
	 */
	// Section filter
	if ($filter_sectionid >= 0) {
		$where[] = 'c.sectionid = ' . (int) $filter_sectionid;
	}
	// Category filter
	if ($catid > 0) {
		$where[] = 'c.catid = ' . (int) $catid;
	}
	// Author filter
	if ($filter_authorid > 0) {
		$where[] = 'c.created_by = ' . (int) $filter_authorid;
	}
	// Content state filter
	if ($filter_state) {
		if ($filter_state == 'P') {
			$where[] = 'c.state = 1';
		} else {
			if ($filter_state == 'U') {
				$where[] = 'c.state = 0';
			} else if ($filter_state == 'A') {
				$where[] = 'c.state = -1';
			} else {
				$where[] = 'c.state != -2';
			}
		}
	}
	// Keyword filter
	if ($search) {
		$where[] = '(LOWER( c.title ) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false ) .
			' OR c.id = ' . (int) $search . ')';
	}

	// Build the where clause of the content record query
	$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');

	// Get the total number of records
	$query = 'SELECT COUNT(*)' .
			' FROM #__content AS c' .
			' LEFT JOIN #__categories AS cc ON cc.id = c.catid' .
			' LEFT JOIN #__sections AS s ON s.id = c.sectionid' .
			$where;
	$db->setQuery($query);
	$total = $db->loadResult();


	// Create the pagination object
	jimport('joomla.html.pagination');
	$pagination = new JPagination($total, $limitstart, $limit);

	// Get the articles
	$query = 'SELECT c.*, g.name AS groupname, cc.title AS name, u.name AS editor, f.content_id AS frontpage, s.title AS section_name, v.name AS author' .
			' FROM #__content AS c' .
			' LEFT JOIN #__categories AS cc ON cc.id = c.catid' .
			' LEFT JOIN #__sections AS s ON s.id = c.sectionid' .
			' LEFT JOIN #__groups AS g ON g.id = c.access' .
			' LEFT JOIN #__users AS u ON u.id = c.checked_out' .
			' LEFT JOIN #__users AS v ON v.id = c.created_by' .
			' LEFT JOIN #__content_frontpage AS f ON f.content_id = c.id' .
			$where .
			$order;
	$db->setQuery($query, $pagination->limitstart, $pagination->limit);
	$rows = $db->loadObjectList();

	// If there is a database query error, throw a HTTP 500 and exit
	if ($db->getErrorNum()) {
		JError::raiseError( 500, $db->stderr() );
		return false;
	}

	// get list of categories for dropdown filter
	$query = 'SELECT cc.id AS value, cc.title AS text, section' .
			' FROM #__categories AS cc' .
			' INNER JOIN #__sections AS s ON s.id = cc.section ' .
			$filter .
			' ORDER BY s.ordering, cc.ordering';
	$lists['catid'] = ContentHelper::filterCategory($query, $catid);

	// get list of sections for dropdown filter
	$javascript = 'onchange="document.adminForm.submit();"';
	$lists['sectionid'] = JHTML::_('list.section', 'filter_sectionid', $filter_sectionid, $javascript);

	// get list of Authors for dropdown filter
	$query = 'SELECT c.created_by, u.name' .
			' FROM #__content AS c' .
			' INNER JOIN #__sections AS s ON s.id = c.sectionid' .
			' LEFT JOIN #__users AS u ON u.id = c.created_by' .
			' WHERE c.state <> -1' .
			' AND c.state <> -2' .
			' GROUP BY u.name' .
			' ORDER BY u.name';
	$authors[] = JHTML::_('select.option', '0', '- '.JText::_('Select Author').' -', 'created_by', 'name');
	$db->setQuery($query);
	$authors = array_merge($authors, $db->loadObjectList());
	$lists['authorid'] = JHTML::_('select.genericlist',  $authors, 'filter_authorid', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'created_by', 'name', $filter_authorid);

	// state filter
	$lists['state'] = JHTML::_('grid.state', $filter_state, 'Published', 'Unpublished', 'Archived');

	// table ordering
	$lists['order_Dir']	= $filter_order_Dir;
	$lists['order']		= $filter_order;

	// search filter
	$lists['search'] = $search;

	outputHTML( $rows, $client, $pagination, $lists );
}
function outputHTML( &$rows, &$client, &$page, &$lists )
{
	$mainframe = &JFactory::getApplication();
	
	// Initialize variables
	$db		=& JFactory::getDBO();
	$user	=& JFactory::getUser();
	$config	=& JFactory::getConfig();
	$now	=& JFactory::getDate();

	$ordering = ( $lists['order'] == 'm.ordering' || $lists['order'] == 'm.position' );

	JHTML::_( 'behavior.tooltip' );
	$plugin_params = getPluginParams( 'system', 'articlesanywhere', JPATH_SITE.DS.'plugins'.DS.'system'.DS.'articlesanywhere.xml' );

	// Load plugin language
	$lang =& JFactory::getLanguage();
	$lang->load( 'plg_editors-xtd_articlesanywhere', JPATH_ADMINISTRATOR );
	$lang->load( 'plg_system_articlesanywhere', JPATH_ADMINISTRATOR );

	// Add scripts and styles
	$document = & JFactory::getDocument();
	$document->addStyleSheet( JURI::root( true ).'/plugins/editors-xtd/articlesanywhere/css/articlesanywhere_popup.css' );
	$script = "
		function articlesanywhere_jInsertEditorText( id ) {
			f = document.getElementById( 'adminForm' );
			var data = f.data.value.trim();
			if ( !data ) {
				data = 'text';
			}
			if ( data == 'readmore' ) {
				var readmoretext = f.readmoretext.value.trim();
				if ( readmoretext ) {
					data = data+':'+readmoretext;
				}
			} else if ( data == 'text' || data == 'introtext' || data == 'fulltext' ) {
				var maxtextlength = parseInt( f.maxtextlength.value.trim() );
				if ( maxtextlength && maxtextlength != 0 ) {
					data = data+':'+maxtextlength;
				}
			}

			str = '{".$plugin_params->article_tag." '+id+'}{'+data+'}{/".$plugin_params->article_tag."}';

			window.parent.jInsertEditorText( str, '".JRequest::getVar( 'name' )."' );
			window.parent.document.getElementById( 'sbox-window' ).close();
		}
	";
	$document->addScriptDeclaration( $script );
?>

	<form action="" method="post" name="adminForm" id="adminForm">
		<fieldset>
			<div style="float: left">
				<h1><?php echo JText::_( 'Articles Anywhere' ); ?></h1>
			</div>
			<div style="float: right">
				<div class="button2-left"><div class="blank hasicon cancel">
					<a rel="" onclick="window.parent.document.getElementById('sbox-window').close();" href="javascript://" title="<?php echo JText::_('Cancel') ?>"><?php echo JText::_('Cancel') ?></a>
				</div></div>
			</div>
		</fieldset>
			<p><?php
				echo JText::_( 'Click on one of the article links' );
				if( $mainframe->isAdmin() ) {
					$link = JURI::base( true ).'/index.php?option=com_plugins&client=site&filter_type=system&search=articles%20anywhere';
					echo '<br />'.JText::sprintf( 'More syntax help', $link );
				}
			?></p>
		<table class="adminlist adminform" cellspacing="1">
			<thead>
				<tr>
					<td>
						<div style="float:left;">
							<?php echo JText::_( 'Article Data' ); ?>:
							<select name="data" class="inputbox">
							<?php
								$data = JRequest::getCmd( 'data' );
								if ( !$data ) {
									$data = 'text';
								}

								echo '
									<option value="text"'.( ( $data == 'text' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'All text' ).'</option>
									<option value="introtext"'.( ( $data == 'introtext' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'Intro text' ).'</option>
									<option value="fulltext"'.( ( $data == 'fulltext' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'Full text' ).'</option>
									<option value="readmore"'.( ( $data == 'readmore' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'Readmore link' ).'</option>
									<option value="title"'.( ( $data == 'title' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'Title' ).'</option>
									<option value="id"'.( ( $data == 'id' ) ? ' selected="selected"' : '' ).'>'
										.JText::_( 'ID' ).'</option>
								';
							?>
							</select>
						</div>
						<div style="float:left;margin-left:10px;">
							<div id="data.text data.introtext data.fulltext" class="nntoggler" style="visibility: hidden;">
								<?php echo JText::_( 'Maximum text length' ); ?>:
								<input type="text" class="text_area" name="maxtextlength" id="maxtextlength" value="0" size="4" style="text-align: right;" />
							</div>
							<div id="data.readmore" class="nntoggler" style="visibility: hidden;">
								<?php echo JText::_( 'Readmore link text' ); ?>:
								<input type="text" class="text_area" name="readmoretext" id="readmoretext" value="" style="text-align: right;" />
							</div>
						</div>
						<div style="clear:both;" />
					</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<div style="float:left;">
							<?php echo JText::_( 'Filter' ); ?>:
							<input type="text" name="search" id="search" value="<?php echo $lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" title="<?php echo JText::_( 'Filter by title or enter article ID' );?>" />
							<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
							<button onclick="document.getElementById('search').value='';this.form.getElementById('filter_sectionid').value='-1';this.form.getElementById('catid').value='0';this.form.getElementById('filter_authorid').value='0';this.form.getElementById('filter_state').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
						</div>
						<div style="float:right;margin-left:10px;">
							<?php
							echo $lists['sectionid'];
							echo $lists['catid'];
							echo $lists['authorid'];
							echo $lists['state'];
							?>
						</div>
						<div style="clear:both;" />
					</td>
				</tr>
			</tbody>
		</table>

		<table class="adminlist adminform" cellspacing="1">
			<thead>
				<tr>
					<th width="5">
						<?php echo JText::_( 'Num' ); ?>
					</th>
					<th width="1%" class="title">
						<?php echo JHTML::_('grid.sort',   'ID', 'c.id', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th class="title">
						<?php echo JHTML::_('grid.sort',   'Title', 'c.title', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th class="title">
						<?php echo JHTML::_('grid.sort',   'Alias', 'c.alias', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="1%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Published', 'c.state', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th nowrap="nowrap" width="1%">
						<?php echo JHTML::_('grid.sort',   'Front Page', 'frontpage', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th width="8%">
						<?php echo JHTML::_('grid.sort',   'Order', 'c.ordering', @$lists['order_Dir'], @$lists['order'] ); ?>
						<?php if ($ordering) echo JHTML::_('grid.order',  $rows ); ?>
					</th>
					<?php
					if ( $client->id == 0 ) {
						?>
						<th nowrap="nowrap" width="7%">
							<?php echo JHTML::_( 'grid.sort', 'Access', 'groupname', @$lists['order_Dir'], @$lists['order'] ); ?>
						</th>
						<?php
					}
					?>
					<th class="title" width="8%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Section', 'section_name', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th  class="title" width="8%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Category', 'cc.title', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th  class="title" width="8%" nowrap="nowrap">
						<?php echo JHTML::_('grid.sort',   'Author', 'author', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th align="center" width="10">
						<?php echo JHTML::_('grid.sort',   'Date', 'c.created', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
					<th align="center" width="10">
						<?php echo JHTML::_('grid.sort',   'Hits', 'c.hits', @$lists['order_Dir'], @$lists['order'] ); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="<?php echo ( $client->id == 0 ) ? '13' : '12'; ?>">
						<?php
							$pagination = str_replace( 'index.php?', 'plugins/editors-xtd/articlesanywhere/elements/articlesanywhere.page.php?name='.JRequest::getCmd( 'name', 'text' ).'&', $page->getListFooter() );
							$pagination = str_replace( 'index.php', 'plugins/editors-xtd/articlesanywhere/elements/articlesanywhere.page.php?name='.JRequest::getCmd( 'name', 'text' ), $pagination );
							echo $pagination;
						?>
					</td>
				</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			$nullDate = $db->getNullDate();
			for ($i=0, $n=count( $rows ); $i < $n; $i++)
			{
				$row = &$rows[$i];

				$publish_up =& JFactory::getDate($row->publish_up);
				$publish_down =& JFactory::getDate($row->publish_down);
				$publish_up->setOffset($config->getValue('config.offset'));
				$publish_down->setOffset($config->getValue('config.offset'));
				if ( $now->toUnix() <= $publish_up->toUnix() && $row->state == 1 ) {
					$img = 'publish_y.png';
					$alt = JText::_( 'Published' );
				} else if ( ( $now->toUnix() <= $publish_down->toUnix() || $row->publish_down == $nullDate ) && $row->state == 1 ) {
					$img = 'publish_g.png';
					$alt = JText::_( 'Published' );
				} else if ( $now->toUnix() > $publish_down->toUnix() && $row->state == 1 ) {
					$img = 'publish_r.png';
					$alt = JText::_( 'Expired' );
				} else if ( $row->state == 0 ) {
					$img = 'publish_x.png';
					$alt = JText::_( 'Unpublished' );
				} else if ( $row->state == -1 ) {
					$img = 'disabled.png';
					$alt = JText::_( 'Archived' );
				}

				$times = '';
				if (isset($row->publish_up)) {
					if ($row->publish_up == $nullDate) {
						$times .= JText::_( 'Start: Always' );
					} else {
						$times .= JText::_( 'Start' ) .": ". $publish_up->toFormat();
					}
				}
				if (isset($row->publish_down)) {
					if ($row->publish_down == $nullDate) {
						$times .= "<br />". JText::_( 'Finish: No Expiry' );
					} else {
						$times .= "<br />". JText::_( 'Finish' ) .": ". $publish_down->toFormat();
					}
				}

				if ( $user->authorize( 'com_users', 'manage' ) ) {
					if ( $row->created_by_alias ) {
						$author = $row->created_by_alias;
					} else {
						$author = $row->author;
					}
				} else {
					if ( $row->created_by_alias ) {
						$author = $row->created_by_alias;
					} else {
						$author = $row->author;
					}
				}

				if ( $client->id == 0 ) {
					if ( !$row->access )  {
						$color_access = 'style="color: green;"';
					} else if ( $row->access == 1 ) {
						$color_access = 'style="color: red;"';
					} else {
						$color_access = 'style="color: black;"';
					}
				}
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td>
						<?php echo $page->getRowOffset( $i ); ?>
					</td>
					<td>
						<?php echo '<label class="hasTip" title="{article '.$row->id.'}...{/article}"><a href="javascript://" onclick="articlesanywhere_jInsertEditorText( \''.$row->id.'\' )">'.$row->id.'</a></label>';?>
					</td>
					<td>
						<?php echo '<label class="hasTip" title="{article '.htmlspecialchars( $row->title, ENT_QUOTES, 'UTF-8' ).'}...{/article}"><a href="javascript://" onclick="articlesanywhere_jInsertEditorText( \''.addslashes( htmlspecialchars( $row->title, ENT_COMPAT, 'UTF-8' ) ).'\' )">'.htmlspecialchars( $row->title, ENT_QUOTES, 'UTF-8' ).'</a></label>'; ?>
					</td>
					<td>
						<?php echo '<label class="hasTip" title="{article '.$row->alias.'}...{/article}"><a href="javascript://" onclick="articlesanywhere_jInsertEditorText( \''.$row->alias.'\' )">'.$row->alias.'</a></label>'; ?>
					</td>
					<td style="text-align:center;">
						<img src="<?php echo JURI::base( true ).'/images/'.$img; ?>" width="16" height="16" border="0" alt="<?php echo $alt; ?>'" />
					</td>
					<td style="text-align:center;">
							<img src="<?php echo JURI::base( true ).'/images/'.( ( $row->frontpage ) ? 'tick.png' : ( $row->state != -1 ? 'publish_x.png' : 'disabled.png' ) ) ;?>" width="16" height="16" border="0" alt="<?php echo ( $row->frontpage ) ? JText::_( 'Yes' ) : JText::_( 'No' );?>" />
					</td>
					<td style="text-align:center;">
						<?php echo $row->ordering; ?>
					</td>
					<?php
					if ( $client->id == 0 ) {
						?>
						<td style="text-align:center;">
							<?php
								echo '<span '.$color_access.'>'.JText::_( $row->groupname ).'</span>';
							?>
						</td>
						<?php
					}
					?>
					<td>
						<?php echo $row->section_name; ?>
					</td>
					<td>
						<?php echo $row->name; ?>
					</td>
					<td>
						<?php echo $author; ?>
					</td>
					<td nowrap="nowrap">
						<?php echo JHTML::_('date',  $row->created, JText::_('DATE_FORMAT_LC4') ); ?>
					</td>
					<td nowrap="nowrap" style="text-align:center;">
						<?php echo $row->hits ?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
		</table>
		<input type="hidden" name="name" value="<?php echo JRequest::getCmd( 'name', 'text' ); ?>" />
		<input type="hidden" name="client" value="<?php echo $client->id;?>" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
	</form>
<?php
}

function getPluginParams( $type, $plugin, $xml = '' ) {
	$db =& JFactory::getDBO();
	$query = "
		SELECT params
		FROM #__plugins
		WHERE folder = '".$type."'
		AND element = '".$plugin."'
		LIMIT 1";
	$db->setQuery( $query );
	$params = $db->loadResult();
	$params = new JParameter( $params );
	if ( $xml && isset( $params->_registry ) && isset( $params->_registry['_default'] ) && isset( $params->_registry['_default']['data'] ) ) {
		$params->loadSetupFile( $xml );
		$xml_params = $params->renderToArray();
		foreach( $params->_registry['_default']['data'] as $key => $val ) {
			if ( $val == '' && isset( $xml_params[$key] ) && isset( $xml_params[$key]['4'] ) ) {
				$params->_registry['_default']['data']->$key =  $xml_params[$key]['4'];
			}
		}
		foreach( $xml_params as $key => $val ) {
			if ( $key != '' && $key['0'] != '@' && !isset( $params->_registry['_default']['data']->$key ) && isset( $val['4'] ) ) {
				$params->_registry['_default']['data']->$key =  $val['4'];
			}
		}
	}

	return getParamValues( $params );
}

function getParamValues( &$params ) {
	$values = '';
	if ( isset( $params->_xml ) ) {
		foreach ( $params->_xml as $xml_group ) {
			foreach ( $xml_group->children() as $xml_child ) {
				$key = $xml_child->attributes('name');
				if ( !empty( $key ) && $key['0'] != '@' ) {
					$val = $params->get( $key );
					if ( !strlen( $val ) ) {
						$val = $xml_child->attributes('default');
						if ( $xml_child->attributes('type') == 'textarea' ) {
							$val = str_replace( '<br />', "\n", $val );
						}
					}
					$values->$key = $val;
				}
			}
		}
	}

	return $values;
}