<?php
/**
 * Component file
 * component:  com_search
 * type:       search
 *
 * @package     Add to Menu
 * @version     1.2.1
 *
 * @author      Peter van Westen <peter@nonumber.nl>
 * @link        http://www.nonumber.nl
 * @copyright   Copyright (C) 2010 NoNumber! All Rights Reserved
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

$component = array(
	/* Name
	 * This is the name of the menu item type
	 */
	'name' => 'Search',

	/* Adjust height
	 * If for some reason the height of the popup window is
	 * not big enough (or too big), you can adjust it
	 * (negative values are also permitted)
	 */
	'adjust_height' => 0,

	/* Requirements (get/post variables)
	 * -> Use '*' to match anything but empty
 	 * -> Use '+' to match anything but false (empty/0/false)
 	 * -> Use arrays to match any of multiple values
	 */
	'required' => array(
	),

	/* Dabase select
	 * Define what options to use to select the unique item
	 * You have to define table, where, name and alias
	 * If no db lookup is required, only define name (and alias)
	 * -> Use '$...' to use available variables
	 */
	'dbselect' => array(
		'name' => 'com_search',
	),

	/* Extra select options
	 * Define what extra options to display
	 * Arrays will be displayed as select boxes
	 * Strings will be placed as hidden form elements
	 * -> Use '$...' to use available variables
	 */
	'extra' => array(
	),

	/* URL params
	 * Define what the menu item url should contain
	 * -> Use '$...' to use available variables
	 */
	'urlparams' => array(
		'option' => 'com_search',
		'view' => 'search',
	),

	/* Menu item params
	 * Define what the extra menu item params
	 * -> Use '$...' to use available variables
	 */
	'menuparams' => array(
	),
);