<?php
/**
 * Element: Dependency
 * Displays an error if given file is not found
 *
 * @package    NoNumber! Elements
 * @version    v1.0.3
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * Dependency Element
 *
 * Available extra parameters:
 * label	The name of the extension that is needed
 * file		The file to check (from the root)
 */
class JElementDependency extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'Dependency';

	function fetchTooltip( $label, $description, &$node, $control_name, $name )
	{
		return;
	}

	function fetchElement( $name, $value, &$node, $control_name )
	{
		global $mainframe;

		$label =	$this->def( $node->attributes( 'label' ), 'the main extension' );
		$file =		$node->attributes( 'file' );
		$file = 	str_replace( '/', DS, $file );

		if ( file_exists( JPATH_ROOT.DS.$file ) ) {
			return;
		}

		$msg = JText::sprintf( 'This extension needs the main extension to function', $label );
		$message_set = 0;
		$messageQueue = $mainframe->getMessageQueue();
		foreach ( $messageQueue as $queue_message ) {
			if ( $queue_message['type'] == 'notice' && $queue_message['message'] == $msg ) {
				$message_set = 1;
				break;
			}
		}
		if ( !$message_set ) {
			$mainframe->enqueueMessage( $msg, 'notice' );
		}
		return;
	}

	function def( $val, $default )
	{
		return ( $val == '' ) ? $default : $val;
	}
}