--
-- Database query file
-- For manual update
--
-- @package    Sourcerer
-- @version    2.3.2
-- @since      File available since Release v2.0.0
--
-- @author     Peter van Westen <peter@nonumber.nl>
-- @link       http://www.nonumber.nl/sourcerer
-- @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
-- @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
--

--
-- NOTE: The queries assume you are using 'jos_' as the prefix.
--       Please change that if you are using another prefix.
--

--
-- Rename old plugin name
--
UPDATE `jos_plugins`
	SET `name` = 'System - Sourcerer'
	WHERE `name` = 'System - Sourcerer!';

--
-- Rename old plugin name
--
UPDATE `jos_plugins`
	SET `name` = 'Editor Button - Sourcerer'
	WHERE `name` = 'Editor Button - Sourcerer!';

--
-- Rename old module name
--
UPDATE `jos_modules`
	SET `title` = 'Sourcerer Module'
	WHERE `title` = 'Sourcerer! Module';

--
-- Change old Sourcerer modules to normal custom HTML modules (because Sourcerer modules won't work anymore!)
--
UPDATE `jos_modules`
	SET `module` = 'mod_custom',
		`content` = replace( replace( `params`, 'text=', '' ), '\\n', '\n' ),
		`params` = ''
	WHERE `module` = 'mod_sourcerer';