<?php
/**
* @version		$Id: flexitags.php 2009-11-14 vistamedia $
* @package      JCE Advlink
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Ryan Demmer
* @author		Emmanuel Danan
* @license      GNU/GPL
* JCE is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined('_JCE_EXT') or die('Restricted access');

$fparams =& JComponentHelper::getParams('com_flexicontent');
if (!defined('FLEXI_SECTION')) define('FLEXI_SECTION', $fparams->get('flexi_section'));
if (!defined('FLEXI_ACCESS')) define('FLEXI_ACCESS', (JPluginHelper::isEnabled('system', 'flexiaccess') && version_compare(PHP_VERSION, '5.0.0', '>')) ? 1 : 0);

class AdvlinkFlexitags 
{
	function getOptions()
	{
		$advlink =& AdvLink::getInstance();
		$list = '';
//		As this function seems to be a little buggish, here's a workaround ;-)
//		if ($advlink->checkAccess('advlink_flexitags', '1')) {
		if ($advlink->plugin->params->get('advlink_flexitags', '1')) {
			$list = '<li id="index.php?option=com_flexicontent&view=tags"><div class="tree-row"><div class="tree-image"></div><span class="folder flexitags nolink"><a href="javascript:;">' . JText::_('FLEXIcontent tags') . '</a></span></div></li>';
		}
		return $list;	
	}
	
	function getItems($args)
	{		
		$advlink =& AdvLink::getInstance();
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');

		$items 	= array();

		$tags	= AdvlinkFlexitags::_Tags();
		foreach ($tags as $tag) {
			$items[] = array(
				'id'		=>	FlexicontentHelperRoute::getTagRoute($tag->slug),
				'name'		=>	$tag->name,
				'class'		=>	'file flexitag'
			);
		}

		return $items;
	}

	function _Tags()
	{
		$db		=& JFactory::getDBO();

		$query = 'SELECT t.name, t.id,'
				. ' CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug'
				. ' FROM #__flexicontent_tags AS t'
				. ' WHERE t.published = 1'
				;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
}
?>