CREATE TABLE IF NOT EXISTS `#__ms_cat` (
  `cat_id` int(11) NOT NULL auto_increment,
  `cat_name` varchar(128) NOT NULL default '',
  `alias` varchar(128) NOT NULL,
  `cat_description` text,
  `cat_image` varchar(255) default NULL,
  `cat_publish` tinyint(1) default '0',
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `ordering` int(11) default NULL,
  `fid` tinyint(1) NOT NULL,
  `msflag` char(1) NOT NULL default 'M',
  PRIMARY KEY  (`cat_id`),
  KEY `idx_cat_name` (`cat_name`),
  KEY `alias` (`alias`)
)  ;

 

CREATE TABLE IF NOT EXISTS `#__ms_catref` (
  `cat_pid` int(11) NOT NULL default '0',
  `cat_cid` int(11) NOT NULL default '0',
  KEY `cat_ref_cat_pid` (`cat_pid`),
  KEY `cat_ref_cat_cid` (`cat_cid`)
)  ;


CREATE TABLE IF NOT EXISTS `#__ms_currency` (
  `currency_id` int(11) NOT NULL auto_increment,
  `currency_name` varchar(64) default NULL,
  `currency_code` varchar(10) default NULL,
  `homecur` int(1) NOT NULL default '0',
  PRIMARY KEY  (`currency_id`),
  KEY `idx_currency_name` (`currency_name`)
)  ;

DELETE FROM `#__ms_currency`;
INSERT INTO `#__ms_currency` VALUES (1, 'USD', '$',1);
INSERT INTO `#__ms_currency` VALUES (2, 'EUR', '',0);
INSERT INTO `#__ms_currency` VALUES (3, 'GBP', '',0);



CREATE TABLE IF NOT EXISTS `#__ms_merchant` (
  `mc_id` int(11) NOT NULL auto_increment,
  `mc_name` varchar(64) default NULL,
  `alias` varchar(128) NOT NULL,
  `mc_url` varchar(255) NOT NULL,
  `mc_logo` varchar(255) NOT NULL,
  `msflag` char(1) NOT NULL default 'M',
  `mc_cid` int(11) default NULL,
  PRIMARY KEY  (`mc_id`)
)  ;

CREATE TABLE IF NOT EXISTS `#__ms_product` (
  `product_id` int(11) NOT NULL auto_increment,
  `product_sku` varchar(64) NOT NULL default '',
  `product_desc` longtext, 
  `product_searchword` text,
  `product_thumb_image` text,
  `product_full_image` text,
  `product_publish` tinyint(1) default NULL,
  `product_url` text,
  `product_price` decimal(10,5) NOT NULL default '0.00000', 
  `product_saleprice` decimal(10,5) NOT NULL default '0.00000',  
  `cdate` int(11) default NULL,
  `product_name` varchar(255) default NULL,
  `alias` varchar(255) NOT NULL,
  `merchant` varchar(255) default NULL,
  `ordering` int(11) NOT NULL,
  `hits` int(11) NOT NULL default '0',
  `mc_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL default '0',
  `cat_id` int(11) NOT NULL,
  `tags` text NOT NULL,
  `fid` int(11) NOT NULL,
  `product_upc` varchar(64) default NULL,
  `product_isbn` varchar(64) default NULL,
  `msflag` char(1) default 'M',
  `importdate` datetime default NULL,
  PRIMARY KEY  (`product_id`),
  KEY `idx_product_sku` (`product_sku`),
  KEY `idx_product_name` (`product_name`),
  KEY `alias` (`alias`),
  KEY `cat_id` (`cat_id`),
  KEY `mc_id` (`mc_id`),
  KEY `product_upc` (`product_upc`),
  KEY `product_isbn` (`product_isbn`)
)   ;

 	

CREATE TABLE IF NOT EXISTS `#__ms_product_cat_ref` (
  `cat_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  KEY `idx_product_cat_ref_cat_id` (`cat_id`),
  KEY `idx_product_cat_ref_product_id` (`product_id`)
)  ;

CREATE TABLE IF NOT EXISTS `#__ms_product_mc_ref` (
  `product_id` int(11) default NULL,
  `mc_id` int(11) default NULL,
  KEY `idx_product_mc_ref_product_id` (`product_id`),
  KEY `idx_product_mc_ref_mc_id` (`mc_id`)
)  ;

CREATE TABLE IF NOT EXISTS `#__msdatafeed_file` (
  `fid` int(11) NOT NULL auto_increment,
  `did` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `feedname` varchar(255) NOT NULL,
  `headerrow` tinyint(1) NOT NULL default '0',
  `delimiter` char(1) NOT NULL default '0',
  `quoted` char(1) NOT NULL default '0',
  `replacefield` int(11) default NULL,
  `feedfind` varchar(20) default NULL,
  `feedreplace` varchar(20) default NULL,
  `colno_productid` int(11) default NULL,
  `colno_productname` int(11) default NULL,
  `colno_productprice` int(11) default NULL, 
  `colno_productsaleprice` int(11) default NULL,
  `colno_productsmallimage` int(11) default NULL,
  `colno_productlargeimage` int(11) default NULL,
  `colno_productdescription` int(11) default NULL,
  `colno_merchantname` int(11) default NULL,
  `colno_producturl` int(11) default NULL,
  `colno_productcategory` int(11) default NULL,
  `colno_productsubcategory` int(11) default NULL,
  `colno_productsubcat2` varchar(255) default NULL,
  `colno_productsubcat3` varchar(255) default NULL,
  `colno_productsubcat4` varchar(255) default NULL,
  `date` datetime default NULL,
  `dateimport` datetime default NULL,
  `ordering` int(11) NOT NULL default '0',
  `customcat` varchar(255) default NULL,
  `createcat` tinyint(1) NOT NULL default '0',
  `currency_id` int(11) default NULL,
  `custom_merchant` varchar(255) default NULL,
  `join_customcat` tinyint(1) default NULL,
  `createmc` tinyint(4) default '0',
  `defineflag` tinyint(4) default NULL,
  `colno_isbn` int(11) default NULL,
  `colno_upc` int(11) default NULL,
  `importstatus` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `filename` (`filename`)
)   ;


CREATE TABLE IF NOT EXISTS `#__ms_product_content` (
  `product_id` varchar(64) NOT NULL,
  `content_id` int(11) NOT NULL,
  `msflag` char(1) default 'M',
  PRIMARY KEY  (`product_id`),
  KEY `idx_product_content_conttent_id` (`content_id`)
)  ;